/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.mapmode.PlayHeadDragMode;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.AudioMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.ButtonMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.tools.AudioPlayer;
import org.openstreetmap.josm.tools.I18n;

public class PlayHeadMarker
extends Marker {
    private Timer timer = null;
    private double animationInterval = 0.0;
    private static PlayHeadMarker playHead = null;
    private MapMode oldMode = null;
    private LatLon oldCoor;
    private boolean enabled = Main.pref.getBoolean("marker.traceaudio", true);
    private boolean wasPlaying = false;
    private int dropTolerance;

    public static PlayHeadMarker create() {
        if (playHead == null) {
            try {
                playHead = new PlayHeadMarker();
            }
            catch (Exception ex) {
                return null;
            }
        }
        return playHead;
    }

    private PlayHeadMarker() {
        super(new LatLon(0.0, 0.0), "", Main.pref.get("marker.audiotracericon", "audio-tracer"), null, -1.0, 0.0);
        if (!this.enabled) {
            return;
        }
        this.dropTolerance = Main.pref.getInteger("marker.playHeadDropTolerance", 50);
        Main.map.mapView.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent ev) {
                Point p = ev.getPoint();
                if (ev.getButton() != 1 || p == null) {
                    return;
                }
                if (playHead.containsPoint(p)) {
                    PlayHeadMarker.this.oldMode = Main.map.mapMode;
                    PlayHeadMarker.this.oldCoor = PlayHeadMarker.this.getCoor();
                    PlayHeadDragMode playHeadDragMode = new PlayHeadDragMode(playHead);
                    Main.map.selectMapMode(playHeadDragMode);
                    playHeadDragMode.mousePressed(ev);
                }
            }
        });
    }

    public boolean containsPoint(Point p) {
        Point screen = Main.map.mapView.getPoint(this.getEastNorth());
        Rectangle r = new Rectangle(screen.x, screen.y, this.symbol.getIconWidth(), this.symbol.getIconHeight());
        return r.contains(p);
    }

    public void startDrag() {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.wasPlaying = AudioPlayer.playing();
        if (this.wasPlaying) {
            try {
                AudioPlayer.pause();
            }
            catch (Exception ex) {
                AudioPlayer.audioMalfunction(ex);
            }
        }
    }

    private void endDrag(boolean reset) {
        if (!this.wasPlaying || reset) {
            try {
                AudioPlayer.pause();
            }
            catch (Exception ex) {
                AudioPlayer.audioMalfunction(ex);
            }
        }
        if (reset) {
            this.setCoor(this.oldCoor);
        }
        Main.map.selectMapMode(this.oldMode);
        Main.map.mapView.repaint();
        this.timer.start();
    }

    public void drag(EastNorth en) {
        this.setEastNorth(en);
        Main.map.mapView.repaint();
    }

    public void reposition(EastNorth en) {
        WayPoint cw = null;
        AudioMarker recent = AudioMarker.recentlyPlayedMarker();
        if (recent != null && recent.parentLayer != null && recent.parentLayer.fromLayer != null) {
            Point p = Main.map.mapView.getPoint(en);
            EastNorth enPlus25px = Main.map.mapView.getEastNorth(p.x + this.dropTolerance, p.y);
            cw = recent.parentLayer.fromLayer.nearestPointOnTrack(en, enPlus25px.east() - en.east());
        }
        AudioMarker ca = null;
        if (cw != null && recent != null && recent.parentLayer != null) {
            for (Marker m : recent.parentLayer.data) {
                if (!(m instanceof AudioMarker)) continue;
                AudioMarker a = (AudioMarker)m;
                if (a.time > cw.time) break;
                ca = a;
            }
        }
        if (ca == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("You need to drag the play head near to the GPX track whose associated sound track you were playing (after the first marker)."), I18n.tr("Warning"), 2);
            this.endDrag(true);
        } else {
            this.setCoor(cw.getCoor());
            ca.play(cw.time - ca.time);
            this.endDrag(false);
        }
    }

    public void synchronize(EastNorth en) {
        AudioMarker recent = AudioMarker.recentlyPlayedMarker();
        if (recent == null) {
            return;
        }
        Point startPoint = Main.map.mapView.getPoint(en);
        ButtonMarker ca = null;
        if (recent.parentLayer != null) {
            double closestAudioMarkerDistanceSquared = 1.0E100;
            for (Marker m : recent.parentLayer.data) {
                double distanceSquared;
                if (!(m instanceof AudioMarker) || !((distanceSquared = m.getEastNorth().distanceSq(en)) < closestAudioMarkerDistanceSquared)) continue;
                ca = (AudioMarker)m;
                closestAudioMarkerDistanceSquared = distanceSquared;
            }
        }
        if (ca != null && !ca.containsPoint(startPoint)) {
            ca = null;
        }
        if (ca == null) {
            Point p = Main.map.mapView.getPoint(en);
            EastNorth enPlus25px = Main.map.mapView.getEastNorth(p.x + this.dropTolerance, p.y);
            WayPoint cw = recent.parentLayer.fromLayer.nearestPointOnTrack(en, enPlus25px.east() - en.east());
            if (cw == null) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("You need to SHIFT-drag the play head onto an audio marker or onto the track point where you want to synchronize."), I18n.tr("Warning"), 2);
                this.endDrag(true);
                return;
            }
            ca = recent.parentLayer.addAudioMarker(cw.time, cw.getCoor());
        }
        if (ca == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Unable to create new audio marker."), I18n.tr("Error"), 0);
            this.endDrag(true);
        } else if (recent.parentLayer.synchronizeAudioMarkers((AudioMarker)ca)) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Audio synchronized at point {0}.", ((AudioMarker)ca).text), I18n.tr("Information"), 1);
            this.setCoor(ca.getCoor());
            this.endDrag(false);
        } else {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Unable to synchronize in layer being played."), I18n.tr("Error"), 0);
            this.endDrag(true);
        }
    }

    public void paint(Graphics g, MapView mv) {
        if (this.time < 0.0) {
            return;
        }
        Point screen = mv.getPoint(this.getEastNorth());
        this.symbol.paintIcon(mv, g, screen.x, screen.y);
    }

    public void animate() {
        if (!this.enabled) {
            return;
        }
        if (this.timer == null) {
            this.animationInterval = Double.parseDouble(Main.pref.get("marker.audioanimationinterval", "1"));
            this.timer = new Timer((int)(this.animationInterval * 1000.0), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PlayHeadMarker.this.timerAction();
                }
            });
            this.timer.setInitialDelay(0);
        } else {
            this.timer.stop();
        }
        this.timer.start();
    }

    public void timerAction() {
        AudioMarker recentlyPlayedMarker = AudioMarker.recentlyPlayedMarker();
        if (recentlyPlayedMarker == null) {
            return;
        }
        double audioTime = recentlyPlayedMarker.time + AudioPlayer.position() - recentlyPlayedMarker.offset - recentlyPlayedMarker.syncOffset;
        if (Math.abs(audioTime - this.time) < this.animationInterval) {
            return;
        }
        if (recentlyPlayedMarker.parentLayer == null) {
            return;
        }
        GpxLayer trackLayer = recentlyPlayedMarker.parentLayer.fromLayer;
        if (trackLayer == null) {
            return;
        }
        WayPoint w1 = null;
        WayPoint w2 = null;
        for (GpxTrack track : trackLayer.data.tracks) {
            for (GpxTrackSegment trackseg : track.getSegments()) {
                for (WayPoint w : trackseg.getWayPoints()) {
                    if (audioTime < w.time) {
                        w2 = w;
                        break;
                    }
                    w1 = w;
                }
                if (w2 == null) continue;
                break;
            }
            if (w2 == null) continue;
            break;
        }
        if (w1 == null) {
            return;
        }
        this.setEastNorth(w2 == null ? w1.getEastNorth() : w1.getEastNorth().interpolate(w2.getEastNorth(), (audioTime - w1.time) / (w2.time - w1.time)));
        this.time = audioTime;
        Main.map.mapView.repaint();
    }
}

