/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.PresetTextComparator;

public class TaggingPresetMenu
extends TaggingPreset {
    public JMenu menu = null;

    public void setDisplayName() {
        this.putValue("Name", this.getName());
        this.putValue("Optional tooltip text", this.group != null ? I18n.tr("Preset group {1} / {0}", this.getLocaleName(), this.group.getName()) : I18n.tr("Preset group {0}", this.getLocaleName()));
        this.putValue("toolbar", "tagginggroup_" + this.getRawName());
    }

    public void setIcon(String iconName) {
        super.setIcon(iconName);
    }

    private Component copyMenuComponent(Component menuComponent) {
        if (menuComponent instanceof JMenu) {
            JMenu menu = (JMenu)menuComponent;
            JMenu result = new JMenu(menu.getAction());
            for (Component item : menu.getMenuComponents()) {
                result.add(this.copyMenuComponent(item));
            }
            result.setText(menu.getText());
            return result;
        }
        if (menuComponent instanceof JMenuItem) {
            JMenuItem menuItem = (JMenuItem)menuComponent;
            JMenuItem result = new JMenuItem(menuItem.getAction());
            result.setText(menuItem.getText());
            return result;
        }
        if (menuComponent instanceof JSeparator) {
            return new JSeparator();
        }
        return menuComponent;
    }

    public void actionPerformed(ActionEvent e) {
        Object s = e.getSource();
        if (this.menu != null && s instanceof Component) {
            Component co = (Component)s;
            JPopupMenu pm = new JPopupMenu(this.getName());
            for (Component c : this.menu.getMenuComponents()) {
                pm.add(this.copyMenuComponent(c));
            }
            pm.show(co, co.getWidth() / 2, co.getHeight() / 2);
        }
    }

    public void sortMenu() {
        TaggingPresetMenu.sortMenu(this.menu);
    }

    public static void sortMenu(JMenu menu) {
        Component[] items = menu.getMenuComponents();
        PresetTextComparator comp = new PresetTextComparator();
        ArrayList<JMenuItem> sortarray = new ArrayList<JMenuItem>();
        int lastSeparator = 0;
        for (int i = 0; i < items.length; ++i) {
            int oldPos;
            int pos;
            Component item = items[i];
            if (item instanceof JMenu) {
                TaggingPresetMenu.sortMenu((JMenu)item);
            }
            if (item instanceof JMenuItem) {
                sortarray.add((JMenuItem)item);
                if (i != items.length - 1) continue;
                Collections.sort(sortarray, comp);
                pos = 0;
                for (JMenuItem menuItem : sortarray) {
                    oldPos = lastSeparator == 0 ? pos : pos + lastSeparator + 1;
                    menu.add((Component)menuItem, oldPos);
                    ++pos;
                }
                sortarray = new ArrayList();
                lastSeparator = 0;
                continue;
            }
            if (!(item instanceof JSeparator)) continue;
            Collections.sort(sortarray, comp);
            pos = 0;
            for (JMenuItem menuItem : sortarray) {
                oldPos = lastSeparator == 0 ? pos : pos + lastSeparator + 1;
                menu.add((Component)menuItem, oldPos);
                ++pos;
            }
            sortarray = new ArrayList();
            lastSeparator = i;
        }
    }
}

