/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerObjectReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class OsmServerBackreferenceReader
extends OsmServerReader {
    private long id;
    private OsmPrimitiveType primitiveType;
    private boolean readFull;

    public OsmServerBackreferenceReader(OsmPrimitive primitive) throws IllegalArgumentException {
        CheckParameterUtil.ensureValidPrimitiveId(primitive, "primitive");
        this.id = primitive.getId();
        this.primitiveType = OsmPrimitiveType.from(primitive);
        this.readFull = false;
    }

    public OsmServerBackreferenceReader(long id, OsmPrimitiveType type) throws IllegalArgumentException {
        if (id <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected. Got ''{1}''.", "id", id));
        }
        CheckParameterUtil.ensureParameterNotNull((Object)type, "type");
        this.id = id;
        this.primitiveType = type;
        this.readFull = false;
    }

    public OsmServerBackreferenceReader(OsmPrimitive primitive, boolean readFull) {
        this(primitive);
        this.readFull = readFull;
    }

    public OsmServerBackreferenceReader(long id, OsmPrimitiveType type, boolean readFull) throws IllegalArgumentException {
        this(id, type);
        this.readFull = false;
    }

    public boolean isReadFull() {
        return this.readFull;
    }

    public void setReadFull(boolean readFull) {
        this.readFull = readFull;
    }

    protected DataSet getReferringWays(ProgressMonitor progressMonitor) throws OsmTransferException {
        InputStream in = null;
        progressMonitor.beginTask(null, 2);
        try {
            progressMonitor.indeterminateSubTask(I18n.tr("Downloading from OSM Server..."));
            StringBuffer sb = new StringBuffer();
            sb.append(this.primitiveType.getAPIName()).append("/").append(this.id).append("/ways");
            in = this.getInputStream(sb.toString(), progressMonitor.createSubTaskMonitor(1, true));
            if (in == null) {
                DataSet dataSet = null;
                return dataSet;
            }
            progressMonitor.subTask(I18n.tr("Downloading referring ways ..."));
            DataSet dataSet = OsmReader.parseDataSet(in, progressMonitor.createSubTaskMonitor(1, true));
            return dataSet;
        }
        catch (OsmTransferException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.cancel) {
                DataSet dataSet = null;
                return dataSet;
            }
            throw new OsmTransferException(e);
        }
        finally {
            progressMonitor.finishTask();
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
                this.activeConnection = null;
            }
        }
    }

    protected DataSet getReferringRelations(ProgressMonitor progressMonitor) throws OsmTransferException {
        InputStream in = null;
        progressMonitor.beginTask(null, 2);
        try {
            progressMonitor.subTask(I18n.tr("Contacting OSM Server..."));
            StringBuffer sb = new StringBuffer();
            sb.append(this.primitiveType.getAPIName()).append("/").append(this.id).append("/relations");
            in = this.getInputStream(sb.toString(), progressMonitor.createSubTaskMonitor(1, true));
            if (in == null) {
                DataSet dataSet = null;
                return dataSet;
            }
            progressMonitor.subTask(I18n.tr("Downloading referring relations ..."));
            DataSet dataSet = OsmReader.parseDataSet(in, progressMonitor.createSubTaskMonitor(1, true));
            return dataSet;
        }
        catch (OsmTransferException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.cancel) {
                DataSet dataSet = null;
                return dataSet;
            }
            throw new OsmTransferException(e);
        }
        finally {
            progressMonitor.finishTask();
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
                this.activeConnection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSet readIncompletePrimitives(DataSet ds, ProgressMonitor progressMonitor) throws OsmTransferException {
        progressMonitor.beginTask(null, 2);
        try {
            ArrayList<Way> waysToCheck = new ArrayList<Way>(ds.getWays());
            if (this.isReadFull() || this.primitiveType.equals((Object)OsmPrimitiveType.NODE)) {
                for (Way way : waysToCheck) {
                    if (way.isNew() || !way.isIncomplete()) continue;
                    OsmServerObjectReader reader = new OsmServerObjectReader(way.getId(), OsmPrimitiveType.from(way), true);
                    DataSet wayDs = reader.parseOsm(progressMonitor.createSubTaskMonitor(1, false));
                    DataSetMerger visitor = new DataSetMerger(ds, wayDs);
                    visitor.merge();
                }
            }
            if (this.isReadFull()) {
                ArrayList<Relation> relationsToCheck = new ArrayList<Relation>(ds.getRelations());
                for (Relation relation : relationsToCheck) {
                    if (relation.isNew() || !relation.isIncomplete()) continue;
                    OsmServerObjectReader reader = new OsmServerObjectReader(relation.getId(), OsmPrimitiveType.from(relation), true);
                    DataSet wayDs = reader.parseOsm(progressMonitor.createSubTaskMonitor(1, false));
                    DataSetMerger visitor = new DataSetMerger(ds, wayDs);
                    visitor.merge();
                }
            }
            DataSet dataSet = ds;
            return dataSet;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            DataSetMerger visitor;
            DataSet ds;
            progressMonitor.beginTask(null, 3);
            DataSet ret = new DataSet();
            if (this.primitiveType.equals((Object)OsmPrimitiveType.NODE)) {
                ds = this.getReferringWays(progressMonitor.createSubTaskMonitor(1, false));
                visitor = new DataSetMerger(ret, ds);
                visitor.merge();
                ret = visitor.getTargetDataSet();
            }
            ds = this.getReferringRelations(progressMonitor.createSubTaskMonitor(1, false));
            visitor = new DataSetMerger(ret, ds);
            visitor.merge();
            ret = visitor.getTargetDataSet();
            this.readIncompletePrimitives(ret, progressMonitor.createSubTaskMonitor(1, false));
            if (ret != null) {
                ret.deleteInvisible();
            }
            DataSet dataSet = ret;
            return dataSet;
        }
        finally {
            progressMonitor.finishTask();
        }
    }
}

