/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.text.MessageFormat;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmHistoryReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class OsmServerHistoryReader
extends OsmServerReader {
    private OsmPrimitiveType primitiveType;
    private long id;

    public OsmServerHistoryReader(OsmPrimitiveType type, long id) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)type, "type");
        if (id < 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' >= 0 expected. Got ''{1}''.", "id", id));
        }
        this.primitiveType = type;
        this.id = id;
    }

    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public HistoryDataSet parseHistory(ProgressMonitor progressMonitor) throws OsmTransferException {
        InputStream in = null;
        progressMonitor.beginTask("");
        try {
            HistoryDataSet data;
            progressMonitor.indeterminateSubTask(I18n.tr("Contacting OSM Server..."));
            StringBuffer sb = new StringBuffer();
            sb.append(this.primitiveType.getAPIName()).append("/").append(this.id).append("/history");
            in = this.getInputStream(sb.toString(), progressMonitor.createSubTaskMonitor(1, true));
            if (in == null) {
                HistoryDataSet historyDataSet = null;
                return historyDataSet;
            }
            progressMonitor.indeterminateSubTask(I18n.tr("Downloading history..."));
            OsmHistoryReader reader = new OsmHistoryReader(in);
            HistoryDataSet historyDataSet = data = reader.parse(progressMonitor.createSubTaskMonitor(1, true));
            return historyDataSet;
        }
        catch (OsmTransferException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.cancel) {
                HistoryDataSet historyDataSet = null;
                return historyDataSet;
            }
            throw new OsmTransferException(e);
        }
        finally {
            progressMonitor.finishTask();
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
                this.activeConnection = null;
            }
        }
    }
}

