/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmWriter
extends XmlWriter
implements Visitor {
    public static final String DEFAULT_API_VERSION = "0.6";
    private boolean osmConform;
    private boolean withBody = true;
    private String version;
    private Changeset changeset;
    private static final Comparator<OsmPrimitive> byIdComparator = new Comparator<OsmPrimitive>(){

        @Override
        public int compare(OsmPrimitive o1, OsmPrimitive o2) {
            return o1.getUniqueId() < o2.getUniqueId() ? -1 : (o1.getUniqueId() == o2.getUniqueId() ? 0 : 1);
        }
    };
    private static final Comparator<Map.Entry<String, String>> byKeyComparator = new Comparator<Map.Entry<String, String>>(){

        @Override
        public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
            return o1.getKey().compareTo(o2.getKey());
        }
    };

    public OsmWriter(PrintWriter out, boolean osmConform, String version) {
        super(out);
        this.osmConform = osmConform;
        this.version = version == null ? DEFAULT_API_VERSION : version;
    }

    public void setWithBody(boolean wb) {
        this.withBody = wb;
    }

    public void setChangeset(Changeset cs) {
        this.changeset = cs;
    }

    public void setVersion(String v) {
        this.version = v;
    }

    public void header() {
        this.out.println("<?xml version='1.0' encoding='UTF-8'?>");
        this.out.print("<osm version='");
        this.out.print(this.version);
        this.out.println("' generator='JOSM'>");
    }

    public void footer() {
        this.out.println("</osm>");
    }

    private Collection<OsmPrimitive> sortById(Collection<? extends OsmPrimitive> primitives) {
        ArrayList<OsmPrimitive> result = new ArrayList<OsmPrimitive>(primitives.size());
        result.addAll(primitives);
        Collections.sort(result, byIdComparator);
        return result;
    }

    public void writeContent(DataSet ds) {
        for (OsmPrimitive n : this.sortById(ds.getNodes())) {
            if (!this.shouldWrite(n)) continue;
            this.visit((Node)n);
        }
        for (OsmPrimitive w : this.sortById(ds.getWays())) {
            if (!this.shouldWrite(w)) continue;
            this.visit((Way)w);
        }
        for (OsmPrimitive e : this.sortById(ds.getRelations())) {
            if (!this.shouldWrite(e)) continue;
            this.visit((Relation)e);
        }
    }

    private boolean shouldWrite(OsmPrimitive osm) {
        return !osm.isNewOrUndeleted() || !osm.isDeleted();
    }

    public void writeDataSources(DataSet ds) {
        for (DataSource s : ds.dataSources) {
            this.out.println("  <bounds minlat='" + s.bounds.getMin().lat() + "' minlon='" + s.bounds.getMin().lon() + "' maxlat='" + s.bounds.getMax().lat() + "' maxlon='" + s.bounds.getMax().lon() + "' origin='" + XmlWriter.encode(s.origin) + "' />");
        }
    }

    @Override
    public void visit(Node n) {
        if (n.isIncomplete()) {
            return;
        }
        this.addCommon(n, "node");
        this.out.print(" lat='" + n.getCoor().lat() + "' lon='" + n.getCoor().lon() + "'");
        if (!this.withBody) {
            this.out.println("/>");
        } else {
            this.addTags(n, "node", true);
        }
    }

    @Override
    public void visit(Way w) {
        if (w.isIncomplete()) {
            return;
        }
        this.addCommon(w, "way");
        if (!this.withBody) {
            this.out.println("/>");
        } else {
            this.out.println(">");
            for (Node n : w.getNodes()) {
                this.out.println("    <nd ref='" + n.getUniqueId() + "' />");
            }
            this.addTags(w, "way", false);
        }
    }

    @Override
    public void visit(Relation e) {
        if (e.isIncomplete()) {
            return;
        }
        this.addCommon(e, "relation");
        if (!this.withBody) {
            this.out.println("/>");
        } else {
            this.out.println(">");
            for (RelationMember em : e.getMembers()) {
                this.out.print("    <member type='");
                this.out.print(OsmPrimitiveType.from(em.getMember()).getAPIName());
                this.out.println("' ref='" + em.getMember().getUniqueId() + "' role='" + XmlWriter.encode(em.getRole()) + "' />");
            }
            this.addTags(e, "relation", false);
        }
    }

    @Override
    public void visit(Changeset cs) {
        this.out.print("  <changeset ");
        this.out.print(" id='" + cs.getId() + "'");
        if (cs.getUser() != null) {
            this.out.print(" user='" + cs.getUser().getName() + "'");
            this.out.print(" uid='" + cs.getUser().getId() + "'");
        }
        if (cs.getCreatedAt() != null) {
            this.out.print(" created_at='" + DateUtils.fromDate(cs.getCreatedAt()) + "'");
        }
        if (cs.getClosedAt() != null) {
            this.out.print(" closed_at='" + DateUtils.fromDate(cs.getClosedAt()) + "'");
        }
        this.out.print(" open='" + (cs.isOpen() ? "true" : "false") + "'");
        if (cs.getMin() != null) {
            this.out.print(" min_lon='" + cs.getMin().lonToString(CoordinateFormat.DECIMAL_DEGREES) + "'");
            this.out.print(" min_lat='" + cs.getMin().latToString(CoordinateFormat.DECIMAL_DEGREES) + "'");
        }
        if (cs.getMax() != null) {
            this.out.print(" max_lon='" + cs.getMin().lonToString(CoordinateFormat.DECIMAL_DEGREES) + "'");
            this.out.print(" max_lat='" + cs.getMin().latToString(CoordinateFormat.DECIMAL_DEGREES) + "'");
        }
        this.out.println(">");
        this.addTags(cs, "changeset", false);
    }

    private void addTags(Tagged osm, String tagname, boolean tagOpen) {
        if (osm.hasKeys()) {
            if (tagOpen) {
                this.out.println(">");
            }
            ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>(osm.getKeys().entrySet());
            Collections.sort(entries, byKeyComparator);
            for (Map.Entry entry : entries) {
                if (!(osm instanceof Changeset) && "created_by".equals(entry.getKey())) continue;
                this.out.println("    <tag k='" + XmlWriter.encode((String)entry.getKey()) + "' v='" + XmlWriter.encode((String)entry.getValue()) + "' />");
            }
            this.out.println("  </" + tagname + ">");
        } else if (tagOpen) {
            this.out.println(" />");
        } else {
            this.out.println("  </" + tagname + ">");
        }
    }

    private void addCommon(OsmPrimitive osm, String tagname) {
        this.out.print("  <" + tagname);
        if (osm.getUniqueId() == 0L) {
            throw new IllegalStateException(I18n.tr("Unexpected id 0 for osm primitive found"));
        }
        this.out.print(" id='" + osm.getUniqueId() + "'");
        if (!this.osmConform) {
            String action = null;
            if (osm.isDeleted()) {
                action = "delete";
            } else if (osm.isModified()) {
                action = "modify";
            }
            if (action != null) {
                this.out.print(" action='" + action + "'");
            }
        }
        if (!osm.isTimestampEmpty()) {
            this.out.print(" timestamp='" + DateUtils.fromDate(osm.getTimestamp()) + "'");
        }
        if (osm.getUser() != null) {
            if (osm.getUser().isLocalUser()) {
                this.out.print(" user='" + XmlWriter.encode(osm.getUser().getName()) + "'");
            } else if (osm.getUser().isOsmUser()) {
                this.out.print(" uid='" + osm.getUser().getId() + "'");
                this.out.print(" user='" + XmlWriter.encode(osm.getUser().getName()) + "'");
            }
        }
        this.out.print(" visible='" + osm.isVisible() + "'");
        if (osm.getVersion() != 0L) {
            this.out.print(" version='" + osm.getVersion() + "'");
        }
        if (this.changeset != null && this.changeset.getId() != 0) {
            this.out.print(" changeset='" + this.changeset.getId() + "'");
        } else if (osm.getChangesetId() > 0 && !osm.isNew()) {
            this.out.print(" changeset='" + osm.getChangesetId() + "'");
        }
    }

    public void close() {
        this.out.close();
    }

    public void flush() {
        this.out.flush();
    }
}

