/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.HashMap;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmUrlToBounds {
    private static final String SHORTLINK_PREFIX = "http://osm.org/go/";
    private static final char[] SHORTLINK_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_', '@'};

    public static Bounds parse(String url) {
        Bounds b = OsmUrlToBounds.parseShortLink(url);
        if (b != null) {
            return b;
        }
        int i = url.indexOf(63);
        if (i == -1) {
            return null;
        }
        String[] args = url.substring(i + 1).split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String arg : args) {
            int eq = arg.indexOf(61);
            if (eq == -1) continue;
            map.put(arg.substring(0, eq), arg.substring(eq + 1));
        }
        try {
            if (map.containsKey("bbox")) {
                String[] bbox = ((String)map.get("bbox")).split(",");
                b = new Bounds(new LatLon(Double.parseDouble(bbox[1]), Double.parseDouble(bbox[0])), new LatLon(Double.parseDouble(bbox[3]), Double.parseDouble(bbox[2])));
            } else if (map.containsKey("minlat")) {
                String s = (String)map.get("minlat");
                Double minlat = Double.parseDouble(s);
                s = map.get("minlon");
                Double minlon = Double.parseDouble(s);
                s = map.get("maxlat");
                Double maxlat = Double.parseDouble(s);
                s = map.get("maxlon");
                Double maxlon = Double.parseDouble(s);
                b = new Bounds(new LatLon(minlat, minlon), new LatLon(maxlat, maxlon));
            } else {
                b = OsmUrlToBounds.positionToBounds(OsmUrlToBounds.parseDouble(map, "lat"), OsmUrlToBounds.parseDouble(map, "lon"), Integer.parseInt(map.get("zoom")));
            }
        }
        catch (NumberFormatException x) {
        }
        catch (NullPointerException x) {
            // empty catch block
        }
        return b;
    }

    private static double parseDouble(HashMap<String, String> map, String key) {
        if (map.containsKey(key)) {
            return Double.parseDouble(map.get(key));
        }
        return Double.parseDouble(map.get("m" + key));
    }

    private static Bounds parseShortLink(String url) {
        if (!url.startsWith(SHORTLINK_PREFIX)) {
            return null;
        }
        String shortLink = url.substring(SHORTLINK_PREFIX.length());
        HashMap<Character, Integer> array = new HashMap<Character, Integer>();
        for (int i = 0; i < SHORTLINK_CHARS.length; ++i) {
            array.put(Character.valueOf(SHORTLINK_CHARS[i]), i);
        }
        long x = 0L;
        long y = 0L;
        int zoom = 0;
        int zoomOffset = 0;
        for (char ch : shortLink.toCharArray()) {
            if (array.containsKey(Character.valueOf(ch))) {
                int val = (Integer)array.get(Character.valueOf(ch));
                for (int i = 0; i < 3; ++i) {
                    x <<= 1;
                    if ((val & 0x20) != 0) {
                        x |= 1L;
                    }
                    y <<= 1;
                    if (((val <<= 1) & 0x20) != 0) {
                        y |= 1L;
                    }
                    val <<= 1;
                }
                zoom += 3;
                continue;
            }
            --zoomOffset;
        }
        return OsmUrlToBounds.positionToBounds((double)(y <<= 32 - zoom) * 180.0 / 4.294967296E9 - 90.0, (double)(x <<= 32 - zoom) * 360.0 / 4.294967296E9 - 180.0, zoom - 8 - zoomOffset % 3 - 2);
    }

    public static Bounds positionToBounds(double lat, double lon, int zoom) {
        double size = 180.0 / Math.pow(2.0, zoom);
        return new Bounds(new LatLon(lat - size / 2.0, lon - size), new LatLon(lat + size / 2.0, lon + size));
    }

    public static int getZoom(Bounds b) {
        int zoom;
        double latMin = Math.log(Math.tan(0.7853981633974483 + b.getMin().lat() / 180.0 * Math.PI / 2.0)) * 180.0 / Math.PI;
        double latMax = Math.log(Math.tan(0.7853981633974483 + b.getMax().lat() / 180.0 * Math.PI / 2.0)) * 180.0 / Math.PI;
        double size = Math.max(Math.abs(latMax - latMin), Math.abs(b.getMax().lon() - b.getMin().lon()));
        for (zoom = 0; zoom <= 20 && !(size >= 180.0); size *= 2.0, ++zoom) {
        }
        return zoom;
    }

    public static String getURL(Bounds b) {
        return OsmUrlToBounds.getURL(b.getCenter(), OsmUrlToBounds.getZoom(b));
    }

    public static String getURL(LatLon pos, int zoom) {
        int decimals = (int)Math.pow(10.0, zoom / 3);
        double lat = Math.round(pos.lat() * (double)decimals);
        double lon = Math.round(pos.lon() * (double)decimals);
        return "http://www.openstreetmap.org/?lat=" + (lat /= (double)decimals) + "&lon=" + (lon /= (double)decimals) + "&zoom=" + zoom;
    }
}

