/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.fiber;

import java.util.Map;
import java.util.WeakHashMap;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ExecutionContext;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Fiber"})
public abstract class Fiber
extends RubyObject
implements ExecutionContext {
    private final Map<Object, IRubyObject> contextVariables = new WeakHashMap<Object, IRubyObject>();
    protected volatile Block block;
    protected volatile RubyThread parent;
    protected boolean root;
    protected volatile Fiber transferredFrom;
    protected volatile Fiber transferredTo;

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, Block block) {
        Ruby runtime2 = context.getRuntime();
        if (!(this.root || block != null && block.isGiven())) {
            throw runtime2.newArgumentError("tried to create Proc object without a block");
        }
        this.block = block;
        this.parent = context.getThread();
        this.initFiber(context);
        return this;
    }

    public Fiber(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    protected abstract void initFiber(ThreadContext var1);

    protected abstract IRubyObject resumeOrTransfer(ThreadContext var1, IRubyObject var2, boolean var3);

    public abstract IRubyObject yield(ThreadContext var1, IRubyObject var2);

    public abstract boolean isAlive();

    public boolean isRoot() {
        return this.root;
    }

    public Fiber makeRootFiber() {
        this.root = true;
        return this;
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject resume(ThreadContext context) {
        return this.resumeOrTransfer(context, context.nil, false);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject resume(ThreadContext context, IRubyObject arg2) {
        return this.resumeOrTransfer(context, arg2, false);
    }

    @JRubyMethod(rest=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject resume(ThreadContext context, IRubyObject[] args2) {
        return this.resumeOrTransfer(context, context.getRuntime().newArrayNoCopyLight(args2), false);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject transfer(ThreadContext context) {
        return this.resumeOrTransfer(context, context.nil, true);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject transfer(ThreadContext context, IRubyObject arg2) {
        return this.resumeOrTransfer(context, arg2, true);
    }

    @JRubyMethod(rest=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject transfer(ThreadContext context, IRubyObject[] args2) {
        return this.resumeOrTransfer(context, context.getRuntime().newArrayNoCopyLight(args2), true);
    }

    @Override
    public Map<Object, IRubyObject> getContextVariables() {
        return this.contextVariables;
    }

    public Fiber getTransferredFrom() {
        return this.transferredFrom;
    }

    public void setTransferredFrom(Fiber transferredFrom) {
        this.transferredFrom = transferredFrom;
    }

    public Fiber getTransferredTo() {
        return this.transferredTo;
    }

    public void setTransferredTo(Fiber transferredTo) {
        this.transferredTo = transferredTo;
    }
}

