/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxw.aportisdoc;

import java.io.IOException;
import java.util.Enumeration;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.ConvertException;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.DocumentDeserializer;
import org.openoffice.xmerge.converter.palm.PalmDB;
import org.openoffice.xmerge.converter.palm.PalmDocument;
import org.openoffice.xmerge.converter.palm.Record;
import org.openoffice.xmerge.converter.xml.OfficeConstants;
import org.openoffice.xmerge.converter.xml.sxw.SxwDocument;
import org.openoffice.xmerge.converter.xml.sxw.aportisdoc.DocConstants;
import org.openoffice.xmerge.converter.xml.sxw.aportisdoc.DocDecoder;
import org.openoffice.xmerge.util.Debug;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class DocumentDeserializerImpl
implements OfficeConstants,
DocConstants,
DocumentDeserializer {
    private ConvertData cd = null;

    public DocumentDeserializerImpl(ConvertData convertData) {
        this.cd = convertData;
    }

    @Override
    public Document deserialize() throws IOException, ConvertException {
        int n = this.cd.getNumDocuments();
        SxwDocument sxwDocument = null;
        boolean bl = false;
        Enumeration enumeration = this.cd.getDocumentEnumeration();
        while (enumeration.hasMoreElements()) {
            PalmDocument palmDocument = (PalmDocument)enumeration.nextElement();
            PalmDB palmDB = palmDocument.getPdb();
            this.log("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.log("<AportisDoc>");
            Record[] recordArray = palmDB.getRecords();
            String string = palmDocument.getName();
            DocDecoder docDecoder = new DocDecoder();
            String string2 = docDecoder.parseRecords(recordArray);
            sxwDocument = this.buildDocument(string, string2);
            this.log("</AportisDoc>");
        }
        return sxwDocument;
    }

    private SxwDocument buildDocument(String string, String string2) throws IOException {
        int n;
        SxwDocument sxwDocument = new SxwDocument(string);
        sxwDocument.initContentDOM();
        org.w3c.dom.Document document = sxwDocument.getContentDOM();
        NodeList nodeList = document.getElementsByTagName("office:body");
        Node node = nodeList.item(0);
        char[] cArray = string2.toCharArray();
        int n2 = -1;
        Element element = document.createElement("text:p");
        this.log("<PARA>");
        block5: for (n = 0; n < cArray.length; ++n) {
            switch (cArray[n]) {
                case '\t': {
                    if (n2 >= 0) {
                        this.addTextNode(document, element, cArray, n2, n - 1);
                        n2 = -1;
                    }
                    Element element2 = document.createElement("text:tab-stop");
                    element.appendChild(element2);
                    this.log("<TAB/>");
                    continue block5;
                }
                case '\n': {
                    if (n2 >= 0) {
                        this.addTextNode(document, element, cArray, n2, n - 1);
                        n2 = -1;
                    }
                    node.appendChild(element);
                    element = document.createElement("text:p");
                    this.log("</PARA>");
                    this.log("<PARA>");
                    continue block5;
                }
                case ' ': {
                    int n3 = 0;
                    while (cArray[n + 1 + n3] == ' ') {
                        ++n3;
                    }
                    if (n3 > 0) {
                        if (n2 >= 0) {
                            this.addTextNode(document, element, cArray, n2, n);
                            n2 = -1;
                        }
                        Element element3 = document.createElement("text:s");
                        element3.setAttribute("text:c", Integer.toString(n3));
                        element.appendChild(element3);
                        n += n3;
                        this.log("<SPACE count=\"" + n3 + "\" />");
                        continue block5;
                    }
                    if (n2 >= 0) continue block5;
                    n2 = n;
                    this.log("<TEXT>");
                    continue block5;
                }
                default: {
                    if (n2 >= 0) continue block5;
                    n2 = n;
                    this.log("<TEXT>");
                }
            }
        }
        n = cArray.length - 1;
        if (n2 >= 0) {
            this.addTextNode(document, element, cArray, n2, n);
        }
        if (cArray[n] != '\n') {
            node.appendChild(element);
        }
        this.log("</PARA>");
        return sxwDocument;
    }

    private void addTextNode(org.w3c.dom.Document document, Node node, char[] cArray, int n, int n2) {
        String string = new String(cArray, n, n2 - n + 1);
        Text text = document.createTextNode(string);
        node.appendChild(text);
        this.log(string);
        this.log("</TEXT>");
    }

    private void log(String string) {
        Debug.log(4, string);
    }
}

