/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.modules.output.html;

import org.jfree.layouting.input.style.keys.font.FontFamilyValues;
import org.jfree.layouting.output.AbstractOutputProcessorMetaData;
import org.pentaho.reporting.libraries.fonts.awt.AWTFontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.DefaultFontStorage;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontStorage;

public class HtmlOutputProcessorMetaData
extends AbstractOutputProcessorMetaData {
    public static final int PAGINATION_NONE = 0;
    public static final int PAGINATION_MANUAL = 1;
    public static final int PAGINATION_FULL = 2;
    private int paginationMode;

    public HtmlOutputProcessorMetaData(int n) {
        this(HtmlOutputProcessorMetaData.createFontStorage(), n);
    }

    private static FontStorage createFontStorage() {
        return new DefaultFontStorage((FontRegistry)new AWTFontRegistry());
    }

    public HtmlOutputProcessorMetaData(FontStorage fontStorage, int n) {
        super(fontStorage);
        this.paginationMode = n;
        this.setFamilyMapping(FontFamilyValues.CURSIVE, "sans-serif");
        this.setFamilyMapping(FontFamilyValues.FANTASY, "fantasy");
        this.setFamilyMapping(FontFamilyValues.MONOSPACE, "monospace");
        this.setFamilyMapping(FontFamilyValues.SERIF, "serif");
        this.setFamilyMapping(FontFamilyValues.SANS_SERIF, "sans-serif");
    }

    public FontFamily getDefaultFontFamily() {
        return this.getFontRegistry().getFontFamily("sans-serif");
    }

    public String getExportDescriptor() {
        if (this.paginationMode == 2) {
            return "pageable/html";
        }
        return "streaming/html";
    }

    public boolean isIterative() {
        return this.paginationMode != 0;
    }
}

