/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.CellValue;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.EndianConverter;

public class FloatNumber
extends CellValue {
    protected byte[] num = new byte[8];

    public FloatNumber(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    public FloatNumber(int n, int n2, String string, int n3) throws IOException {
        this.setIxfe(n3);
        this.setRow(n);
        this.setCol(n2);
        double d = Double.parseDouble(string);
        this.num = EndianConverter.writeDouble(d);
    }

    @Override
    public short getBiffType() {
        return 3;
    }

    @Override
    public int read(InputStream inputStream) throws IOException {
        int n = super.read(inputStream);
        Debug.log(4, " num : " + this.getString());
        return n += inputStream.read(this.num);
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.getBiffType());
        super.write(outputStream);
        outputStream.write(this.num);
        Debug.log(4, "Writing FloatNumber record");
    }

    @Override
    public String getString() throws IOException {
        double d = EndianConverter.readDouble(this.num);
        Double d2 = new Double(d);
        return d2.toString();
    }
}

