/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.monospace;

import org.pentaho.reporting.libraries.fonts.monospace.MonospaceFontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontRecord;
import org.pentaho.reporting.libraries.fonts.registry.FontType;

public class MonospaceFontRecord
implements FontRecord,
FontIdentifier {
    private MonospaceFontFamily fontFamily;
    private boolean bold;
    private boolean italics;

    public MonospaceFontRecord(MonospaceFontFamily fontFamily, boolean bold, boolean italics) {
        if (fontFamily == null) {
            throw new NullPointerException();
        }
        this.fontFamily = fontFamily;
        this.bold = bold;
        this.italics = italics;
    }

    public FontFamily getFamily() {
        return this.fontFamily;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return false;
    }

    public boolean isOblique() {
        return this.italics;
    }

    public boolean isScalable() {
        return false;
    }

    public FontType getFontType() {
        return FontType.MONOSPACE;
    }

    public FontIdentifier getIdentifier() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonospaceFontRecord that = (MonospaceFontRecord)o;
        if (this.bold != that.bold) {
            return false;
        }
        if (this.italics != that.italics) {
            return false;
        }
        return this.fontFamily.equals(that.fontFamily);
    }

    public int hashCode() {
        int result = this.fontFamily.hashCode();
        result = 29 * result + (this.bold ? 1 : 0);
        result = 29 * result + (this.italics ? 1 : 0);
        return result;
    }
}

