/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import javax.swing.tree.TreeNode;
import org.openide.explorer.view.NodeModel;
import org.openide.explorer.view.VisualizerEvent;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;

final class VisualizerChildren {
    public static final VisualizerChildren EMPTY = new VisualizerChildren();
    public final VisualizerNode parent;
    private final List<VisualizerNode> visNodes;
    private List<Node> snapshot;

    private VisualizerChildren() {
        this.visNodes = Collections.emptyList();
        this.snapshot = Collections.emptyList();
        this.parent = null;
    }

    public VisualizerChildren(VisualizerNode parent, List<Node> snapshot) {
        this.parent = parent;
        int size = snapshot.size();
        this.visNodes = new ArrayList<VisualizerNode>(size);
        for (int i = 0; i < size; ++i) {
            this.visNodes.add(null);
        }
        this.snapshot = snapshot;
    }

    private final void recomputeIndexes(VisualizerNode tn) {
        int i;
        assert (this.visNodes.size() == this.snapshot.size()) : "visnodes.size()=" + this.visNodes.size() + " snapshot.size()=" + this.snapshot.size();
        for (i = 0; i < this.visNodes.size(); ++i) {
            VisualizerNode node = this.visNodes.get(i);
            if (node == null) continue;
            node.indexOf = i;
        }
        if (tn != null && tn.indexOf == -1) {
            i = 0;
            while (i < this.visNodes.size()) {
                VisualizerNode visNode = (VisualizerNode)this.getChildAt(i);
                visNode.indexOf = i++;
                if (visNode != tn) continue;
                return;
            }
        }
    }

    public TreeNode getChildAt(int pos) {
        if (pos >= this.visNodes.size()) {
            return VisualizerNode.EMPTY;
        }
        VisualizerNode visNode = this.visNodes.get(pos);
        if (visNode == null) {
            Node node = this.snapshot.get(pos);
            visNode = VisualizerNode.getVisualizer(this, node);
            visNode.indexOf = pos;
            this.visNodes.set(pos, visNode);
            this.parent.notifyVisualizerChildrenChange(false, this);
        }
        return visNode;
    }

    public int getChildCount() {
        return this.visNodes.size();
    }

    public Enumeration<VisualizerNode> children(final boolean create) {
        return new Enumeration<VisualizerNode>(){
            private int index;

            @Override
            public boolean hasMoreElements() {
                return this.index < VisualizerChildren.this.visNodes.size();
            }

            @Override
            public VisualizerNode nextElement() {
                return create ? (VisualizerNode)VisualizerChildren.this.getChildAt(this.index++) : (VisualizerNode)VisualizerChildren.this.visNodes.get(this.index++);
            }
        };
    }

    public int getIndex(TreeNode p1) {
        VisualizerNode visNode = (VisualizerNode)p1;
        if (visNode.indexOf != -1) {
            if (visNode.indexOf >= this.visNodes.size() || this.visNodes.get(visNode.indexOf) != visNode) {
                return -1;
            }
        } else {
            this.recomputeIndexes(visNode);
        }
        return visNode.indexOf;
    }

    final String dumpIndexes(VisualizerNode visNode) {
        StringBuilder sb = new StringBuilder();
        sb.append("EMPTY: " + (visNode == VisualizerNode.EMPTY) + ", Lazy: " + this.snapshot.getClass().getName().endsWith("LazySnapshot"));
        sb.append("\nSeeking for: ").append(visNode.toId());
        sb.append("\nwith parent: ").append((VisualizerNode)visNode.getParent() != null ? ((VisualizerNode)visNode.getParent()).toId() : "null");
        sb.append("\nSeeking in : ").append(this.parent != null ? this.parent.toId() : "null").append("\n");
        this.addVisNodesInfo(sb);
        return sb.toString();
    }

    private void addVisNodesInfo(StringBuilder sb) {
        for (int i = 0; i < this.visNodes.size(); ++i) {
            VisualizerNode node = this.visNodes.get(i);
            sb.append("  ").append(i);
            if (node != null) {
                sb.append(" = ").append(node.toId());
            } else {
                sb.append(" = null");
            }
            sb.append('\n');
        }
    }

    final String dumpEventInfo(VisualizerEvent ev) {
        StringBuilder sb = new StringBuilder();
        sb.append("\nEvent: " + ev.getClass().getName());
        sb.append("\nOriginal event: " + ev.originalEvent.getClass().getName());
        sb.append("\ncurrent vis. nodes:");
        this.addVisNodesInfo(sb);
        sb.append("\nIndexes: ");
        int[] arr = ev.getArray();
        for (int i = 0; i < arr.length; ++i) {
            sb.append(Integer.toString(arr[i]));
            sb.append(" ");
        }
        sb.append("\n");
        sb.append(ev.originalEvent.toString());
        return sb.toString();
    }

    public void added(VisualizerEvent.Added ev) {
        if (this != this.parent.getChildren()) {
            return;
        }
        this.snapshot = ev.getSnapshot();
        ListIterator<VisualizerNode> it = this.visNodes.listIterator();
        int[] indxs = ev.getArray();
        int current = 0;
        for (int inIndxs = 0; inIndxs < indxs.length; ++inIndxs) {
            while (current++ < indxs[inIndxs]) {
                it.next();
            }
            it.add(null);
        }
        this.recomputeIndexes(null);
        for (VisualizerNode parent = this.parent; parent != null; parent = (VisualizerNode)parent.getParent()) {
            Object[] listeners = parent.getListenerList();
            for (int i = listeners.length - 1; i >= 0; i -= 2) {
                ((NodeModel)listeners[i]).added(ev);
            }
        }
    }

    public void removed(VisualizerEvent.Removed ev) {
        if (this != this.parent.getChildren()) {
            return;
        }
        this.snapshot = ev.getSnapshot();
        int[] idxs = ev.getArray();
        if (idxs.length == 0) {
            return;
        }
        assert (this.visNodes.size() > idxs[idxs.length - 1]) : this.dumpEventInfo(ev);
        for (int i = idxs.length - 1; i >= 0; --i) {
            VisualizerNode visNode = this.visNodes.remove(idxs[i]);
            ev.removed.add(visNode != null ? visNode : VisualizerNode.EMPTY);
        }
        this.recomputeIndexes(null);
        for (VisualizerNode parent = this.parent; parent != null; parent = (VisualizerNode)parent.getParent()) {
            Object[] listeners = parent.getListenerList();
            for (int i = listeners.length - 1; i >= 0; i -= 2) {
                ((NodeModel)listeners[i]).removed(ev);
            }
        }
        if (this.visNodes.isEmpty()) {
            this.parent.notifyVisualizerChildrenChange(true, this);
        }
    }

    public void reordered(VisualizerEvent.Reordered ev) {
        if (this != this.parent.getChildren()) {
            return;
        }
        this.snapshot = ev.getSnapshot();
        int[] indxs = ev.getArray();
        VisualizerNode[] old = this.visNodes.toArray(new VisualizerNode[this.visNodes.size()]);
        VisualizerNode[] arr = new VisualizerNode[old.length];
        int s = indxs.length;
        try {
            for (int i = 0; i < s; ++i) {
                VisualizerNode old_i = old[i];
                int indxs_i = indxs[i];
                if (arr[indxs_i] != null) {
                    System.err.println("Writing to this index for the second time: " + indxs_i);
                    System.err.println("Length of indxs array: " + indxs.length);
                    System.err.println("Length of actual array: " + old.length);
                    System.err.println("Indices of reorder event:");
                    int j = 0;
                    while (i < indxs.length) {
                        System.err.println("\t" + indxs[j]);
                        ++j;
                    }
                    Thread.dumpStack();
                    return;
                }
                arr[indxs_i] = old_i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            System.err.println("Length of actual array: " + old.length);
            System.err.println("Indices of reorder event:");
            for (int i = 0; i < indxs.length; ++i) {
                System.err.println("\t" + indxs[i]);
            }
            return;
        }
        this.visNodes.clear();
        this.visNodes.addAll(Arrays.asList(arr));
        this.recomputeIndexes(null);
        for (VisualizerNode parent = this.parent; parent != null; parent = (VisualizerNode)parent.getParent()) {
            Object[] listeners = parent.getListenerList();
            for (int i = listeners.length - 1; i >= 0; i -= 2) {
                ((NodeModel)listeners[i]).reordered(ev);
            }
        }
    }

    public String toString() {
        String str = "";
        if (this.parent != null) {
            str = "Parent: " + this.parent + " ";
        }
        str = str + "[";
        for (VisualizerNode vn : this.visNodes) {
            VisualizerChildren vch;
            str = str + vn;
            if (vn != null && (vch = vn.getChildren(false)) != EMPTY) {
                str = str + vch;
            }
            str = str + " ";
        }
        str = str + " {" + this.snapshot + "}";
        str = str + "]";
        return str;
    }
}

