/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.gsf;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.api.Severity;

public class CssHintsProvider
implements HintsProvider {
    private boolean cancelled = false;
    private static final CssRule ERROR_RULE = new CssRule(HintSeverity.ERROR);
    private static final CssRule WARNING_RULE = new CssRule(HintSeverity.WARNING);

    public void computeHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints) {
    }

    public void computeSuggestions(HintsProvider.HintsManager manager, RuleContext context, List<Hint> suggestions, int caretOffset) {
    }

    public void computeSelectionHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> suggestions, int start, int end) {
    }

    public void computeErrors(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints, List<Error> unhandled) {
        for (Error e : context.parserResult.getDiagnostics()) {
            assert (e.getDescription() != null);
            Hint h = new Hint((Rule)CssHintsProvider.getCssRule(e.getSeverity()), e.getDescription(), e.getFile(), new OffsetRange(e.getStartPosition(), e.getEndPosition()), Collections.emptyList(), 10);
            hints.add(h);
        }
    }

    public void cancel() {
        this.cancelled = true;
    }

    public List<Rule> getBuiltinRules() {
        return null;
    }

    public RuleContext createRuleContext() {
        return new RuleContext();
    }

    private static CssRule getCssRule(Severity s) {
        switch (s) {
            case WARNING: {
                return WARNING_RULE;
            }
            case ERROR: {
                return ERROR_RULE;
            }
        }
        throw new AssertionError((Object)"Unexpected severity level");
    }

    private static final class CssRule
    implements Rule.ErrorRule {
        private HintSeverity severity;

        private CssRule(HintSeverity severity) {
            this.severity = severity;
        }

        public Set<?> getCodes() {
            return Collections.emptySet();
        }

        public boolean appliesTo(RuleContext context) {
            return true;
        }

        public String getDisplayName() {
            return "css";
        }

        public boolean showInTasklist() {
            return true;
        }

        public HintSeverity getDefaultSeverity() {
            return this.severity;
        }
    }
}

