/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.view.svg;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.microedition.m2g.SVGImage;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.editor.structure.api.DocumentModelException;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.PerseusController;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.composer.ScreenManager;
import org.netbeans.modules.mobility.svgcore.export.SaveElementAsImage;
import org.netbeans.modules.mobility.svgcore.export.ScreenSizeHelper;
import org.netbeans.modules.mobility.svgcore.items.form.SVGComponentDrop;
import org.netbeans.modules.mobility.svgcore.model.SVGFileModel;
import org.netbeans.modules.mobility.svgcore.navigator.SVGNavigatorContent;
import org.netbeans.modules.mobility.svgcore.palette.SVGPaletteItemDataObject;
import org.netbeans.modules.mobility.svgcore.view.svg.AbstractSVGAction;
import org.netbeans.modules.mobility.svgcore.view.svg.AbstractSVGToggleAction;
import org.netbeans.modules.mobility.svgcore.view.svg.AnimationCookie;
import org.netbeans.modules.mobility.svgcore.view.svg.ParsingTask;
import org.netbeans.modules.mobility.svgcore.view.svg.SelectionCookie;
import org.netbeans.modules.xml.multiview.XmlMultiViewEditorSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatableElement;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;
import org.xml.sax.SAXException;

public final class SVGViewTopComponent
extends TopComponent
implements SceneManager.SelectionListener {
    private static final long serialVersionUID = 5862679852552354L;
    private static final float ZOOM_STEP = 1.1f;
    private static final float SLIDER_DEFAULT_STEP = 0.1f;
    private static final String PREFERRED_ID = "SVGViewTopComponent";
    private static final String[] ZOOM_VALUES = new String[]{"400%", "300%", "200%", "100%", "75%", "50%", "25%"};
    private static final String DND_PALETTE_MIME = "x-java-openide-dataobjectdnd";
    private final transient SVGDataObject m_svgDataObject;
    private transient ParsingTask parsingTask;
    private transient Lookup lookup = null;
    private transient JPanel basePanel;
    private transient UpdateThread m_timeUpdater = null;
    private transient JToolBar m_toolbar;
    private transient JToolBar animationToolbar;
    private transient JSlider slider;
    private transient JSpinner currentTimeSpinner;
    private transient JComboBox zoomComboBox;
    private transient AbstractButton startAnimationButton;
    private transient AbstractButton pauseAnimationButton;
    private transient AbstractButton scaleToggleButton;
    private transient AbstractButton showViewBoxToggleButton;
    private transient ChangeListener changeListener;
    private transient boolean doScale = false;
    private transient ButtonMouseListener buttonListener;
    private transient PropertyChangeListener nameChangeL;
    private transient ToggleScaleAction scaleAction;
    private transient ZoomToFitAction zoomToFitAction;
    private transient ZoomInAction zoomInAction;
    private transient ZoomOutAction zoomOutAction;
    private transient ToggleShowViewBoxAction showViewBoxAction;
    private transient RotateLeftModeAction rotateLeftModeAction;
    private transient RotateRightModeAction rotateRightModeAction;
    private final transient AbstractSVGToggleAction allowEditAction = new AbstractSVGToggleAction("svg_allow_edit"){

        @Override
        public void actionPerformed(ActionEvent e) {
            SceneManager smgr = SVGViewTopComponent.this.getSceneManager();
            if (smgr.isReadOnly()) {
                PerseusController pc = SVGViewTopComponent.this.getPerseusController();
                if (pc != null && pc.isAnimatorStarted()) {
                    SVGViewTopComponent.this.startAnimationAction.actionPerformed(e);
                }
                SVGViewTopComponent.this.insertGraphicsAction.setEnabled(true);
                SVGViewTopComponent.this.rotateLeftModeAction.setEnabled(true);
                SVGViewTopComponent.this.rotateRightModeAction.setEnabled(true);
                smgr.setReadOnly(false);
            } else {
                SVGViewTopComponent.this.insertGraphicsAction.setEnabled(false);
                SVGViewTopComponent.this.rotateLeftModeAction.setEnabled(false);
                SVGViewTopComponent.this.rotateRightModeAction.setEnabled(false);
                smgr.setReadOnly(true);
            }
            SVGViewTopComponent.this.updateAnimationActions();
            SVGViewTopComponent.this.updateDataTransferActions();
            smgr.updateActionState();
            this.setIsSelected(!smgr.isReadOnly());
        }
    };
    private final transient AbstractSVGToggleAction startAnimationAction = new AbstractSVGToggleAction("svg_anim_start"){

        @Override
        public void actionPerformed(ActionEvent e) {
            PerseusController pc = SVGViewTopComponent.this.getPerseusController();
            if (pc != null) {
                if (!pc.isAnimatorStarted()) {
                    if (!SVGViewTopComponent.this.getSceneManager().isReadOnly()) {
                        SVGViewTopComponent.this.allowEditAction.actionPerformed(e);
                    }
                    pc.startAnimator();
                    if (SVGViewTopComponent.this.m_timeUpdater == null) {
                        SVGViewTopComponent.this.m_timeUpdater = new UpdateThread();
                        SVGViewTopComponent.this.m_timeUpdater.start();
                    }
                } else {
                    pc.stopAnimator();
                    SVGViewTopComponent.this.updateAnimationTime(pc.getAnimatorTime(), SVGViewTopComponent.this.getSceneManager().getAnimationDuration());
                    if (SVGViewTopComponent.this.m_timeUpdater != null) {
                        SVGViewTopComponent.this.m_timeUpdater.interrupt();
                        SVGViewTopComponent.this.m_timeUpdater = null;
                    }
                    SVGViewTopComponent.this.updateImage();
                }
                SVGViewTopComponent.this.updateAnimationActions();
            }
        }
    };
    private final transient AbstractSVGToggleAction pauseAnimationAction = new AbstractSVGToggleAction("svg_anim_pause", false){

        @Override
        public void actionPerformed(ActionEvent e) {
            PerseusController pc = SVGViewTopComponent.this.getPerseusController();
            if (pc != null) {
                if (pc.getAnimatorState() == 2) {
                    pc.pauseAnimator();
                } else {
                    pc.startAnimator();
                }
                SVGViewTopComponent.this.updateAnimationActions();
            }
        }
    };
    private final transient AbstractSVGAction insertGraphicsAction = new AbstractSVGAction("svg_insert_graphics", false){

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(0);
            int r = chooser.showDialog(SwingUtilities.getWindowAncestor((Component)((Object)SVGViewTopComponent.this)), NbBundle.getMessage(SVGViewTopComponent.class, (String)"LBL_CHOOSE_SVG_FILE"));
            if (r == 0) {
                final File file = chooser.getSelectedFile();
                if (!file.isFile()) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SVGViewTopComponent.class, (String)"ERROR_NotSVGFile", (Object)file), 2));
                    return;
                }
                Thread th = new Thread("InsertGraphicsTask"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            SVGViewTopComponent.this.getSceneManager().setBusyState("operation", true);
                            SVGViewTopComponent.this.m_svgDataObject.getModel().mergeImage(file);
                        }
                        catch (Exception ex) {
                            SceneManager.error("Insert graphics failed.", ex);
                        }
                        finally {
                            SVGViewTopComponent.this.getSceneManager().setBusyState("operation", false);
                        }
                    }
                };
                th.setPriority(1);
                th.setDaemon(true);
                th.start();
            }
        }
    };
    private final transient Action m_pasteAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Clipboard clipboard = SVGViewTopComponent.getClipboard();
            if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                try {
                    String text = (String)clipboard.getData(DataFlavor.stringFlavor);
                    String id = SVGViewTopComponent.this.m_svgDataObject.getModel().mergeImage(text, false);
                    SVGViewTopComponent.this.getSceneManager().setSelection(id, true);
                }
                catch (Exception ex) {
                    SceneManager.error("Paste failed.", ex);
                }
                return;
            }
        }
    };
    private final transient Action m_copyAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SVGViewTopComponent.this.putElementToClipboard(false);
        }
    };
    private final transient Action m_cutAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SVGViewTopComponent.this.putElementToClipboard(true);
        }
    };

    public SVGViewTopComponent(SVGDataObject dObj) {
        this.m_svgDataObject = dObj;
        this.initialize();
    }

    Action[] getImageContextActions() {
        return new Action[]{this.zoomToFitAction, this.scaleToggleButton.getAction(), this.rotateLeftModeAction, this.rotateRightModeAction, this.getToggleHighlightAction()};
    }

    private Action getToggleHighlightAction() {
        Action[] acts = this.getSceneManager().getToolbarActions("svg_toggle_highlight");
        assert (acts.length > 0 && acts[0] != null);
        return acts[0];
    }

    private SceneManager getSceneManager() {
        return this.m_svgDataObject.getSceneManager();
    }

    private PerseusController getPerseusController() {
        return this.getSceneManager().getPerseusController();
    }

    private ScreenManager getScreenManager() {
        return this.getSceneManager().getScreenManager();
    }

    private Lookup createLookup() {
        Lookup elementLookup = this.getSceneManager().getLoookup();
        ActionMap map = this.getActionMap();
        return Lookups.fixed((Object[])new Object[]{new FilterNode(this.m_svgDataObject.getNodeDelegate(), null, (Lookup)new ProxyLookup(new Lookup[]{new SVGElementNode(elementLookup).getLookup(), this.m_svgDataObject.getNodeDelegate().getLookup()})), new SVGCookie(), map});
    }

    private void initialize() {
        this.lookup = this.createLookup();
        this.associateLookup(this.lookup);
        this.initComponents();
        this.nameChangeL = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("cookie".equals(evt.getPropertyName()) || "name".equals(evt.getPropertyName()) || "modified".equals(evt.getPropertyName())) {
                    SVGViewTopComponent.this.updateName();
                }
                if (SVGViewTopComponent.this.isVisible() && "external_change".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SceneManager.log(Level.INFO, "Document modified, refreshing image.");
                            SVGViewTopComponent.this.updateImage();
                        }
                    });
                }
            }
        };
        this.m_svgDataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.nameChangeL, (Object)((Object)this.m_svgDataObject)));
        this.m_toolbar = this.createToolBar();
        this.animationToolbar = this.createAnimationBar();
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PerseusController pctl = SVGViewTopComponent.this.getPerseusController();
                if (pctl == null) {
                    return;
                }
                if (e.getSource() == SVGViewTopComponent.this.slider) {
                    float currentTime = (float)SVGViewTopComponent.this.slider.getValue() * 0.1f;
                    pctl.setAnimatorTime(currentTime);
                    SVGViewTopComponent.this.updateAnimationTime(currentTime, SVGViewTopComponent.this.getSceneManager().getAnimationDuration());
                } else if (e.getSource() == SVGViewTopComponent.this.currentTimeSpinner) {
                    float currentTime = ((Float)SVGViewTopComponent.this.currentTimeSpinner.getValue()).floatValue();
                    pctl.setAnimatorTime(currentTime);
                    SVGViewTopComponent.this.updateAnimationTime(currentTime, SVGViewTopComponent.this.getSceneManager().getAnimationDuration());
                }
            }
        };
        this.slider.addChangeListener(this.changeListener);
        this.currentTimeSpinner.addChangeListener(this.changeListener);
        this.basePanel = new JPanel();
        this.basePanel.setBackground(Color.WHITE);
        this.add(this.basePanel, "Center");
        Box bottom = new Box(1);
        bottom.add(this.animationToolbar);
        bottom.add(this.getScreenManager().getStatusBar());
        this.add(bottom, "South");
        this.updateName();
    }

    private void updateAnimationTime(float time, float maxTime) {
        this.currentTimeSpinner.removeChangeListener(this.changeListener);
        this.slider.removeChangeListener(this.changeListener);
        if (maxTime != -1.0f) {
            this.slider.setMaximum(Math.round(maxTime / 0.1f));
        }
        this.slider.setValue(Math.round(time / 0.1f));
        time = (float)Math.round(time * 10.0f) / 10.0f;
        this.currentTimeSpinner.setValue(new Float(time));
        this.slider.addChangeListener(this.changeListener);
        this.currentTimeSpinner.addChangeListener(this.changeListener);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public JComponent getToolbar() {
        return this.m_toolbar;
    }

    JPanel getBasePanel() {
        return this.basePanel;
    }

    public int getPersistenceType() {
        return 1;
    }

    private void putElementToClipboard(final boolean removeObject) {
        final SVGObject[] obj = this.getSceneManager().getSelected();
        if (obj != null) {
            assert (obj.length > 0);
            assert (obj[0] != null);
            Thread th = new Thread(){

                @Override
                public void run() {
                    try {
                        String elId = obj[0].getElementId();
                        String text = SVGViewTopComponent.this.getModel().getElementAsText(elId);
                        StringSelection strSet = new StringSelection(text);
                        Clipboard clipboard = SVGViewTopComponent.getClipboard();
                        clipboard.setContents(strSet, strSet);
                        if (removeObject) {
                            SVGViewTopComponent.this.getSceneManager().deleteObject(obj[0]);
                        }
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            };
            th.setPriority(1);
            th.setName("PutElementToClipboardThread");
            th.start();
        }
    }

    public void componentOpened() {
        this.getModel().setChanged(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SVGNavigatorContent.getDefault().navigate(SVGViewTopComponent.this.m_svgDataObject);
            }
        });
        this.addSvgPanel();
        this.getActionMap().put("paste-from-clipboard", this.m_pasteAction);
        this.getActionMap().put("copy-to-clipboard", this.m_copyAction);
        this.getActionMap().put("cut-to-clipboard", this.m_cutAction);
        this.getSceneManager().addSelectionListener(this);
    }

    public void componentClosed() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SVGNavigatorContent.getDefault().navigate(null);
            }
        });
        this.removeSvgPanel();
    }

    public boolean isFocusable() {
        return true;
    }

    public void componentActivated() {
        super.componentActivated();
        this.updateDataTransferActions();
    }

    public void componentDeactivated() {
        super.componentDeactivated();
    }

    private void addSvgPanel() {
        assert (SwingUtilities.isEventDispatchThread()) : "Not in AWT event dispach thread";
        LoadPanel loadPanel = new LoadPanel();
        this.basePanel.add(loadPanel);
        this.basePanel.setLayout(new BorderLayout());
    }

    public void onShow() {
        if (this.getModel().isChanged()) {
            this.basePanel.removeAll();
            this.updateImage();
            this.getModel().setChanged(false);
        }
    }

    public void componentHidden() {
        PerseusController perseus = this.getPerseusController();
        if (perseus != null) {
            float stoppedTime = perseus.getAnimatorTime();
            perseus.stopAnimator();
            perseus.setAnimatorTime(stoppedTime);
            this.updateAnimationActions();
        }
    }

    private void removeSvgPanel() {
        assert (SwingUtilities.isEventDispatchThread()) : "Not in AWT event dispach thread";
        this.getSceneManager().resetImage();
        this.basePanel.removeAll();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private void updateName() {
        if (!this.m_svgDataObject.isValid()) {
            return;
        }
        String name = this.m_svgDataObject.getNodeDelegate().getDisplayName();
        this.setName(name);
        XmlMultiViewEditorSupport edSup = (XmlMultiViewEditorSupport)this.m_svgDataObject.getCookie(XmlMultiViewEditorSupport.class);
        if (edSup != null) {
            edSup.updateDisplayName();
        }
    }

    private void addButtonsForActions(JToolBar toolbar, Action[] toolbarActions, GridBagConstraints constrains) {
        for (Action action : toolbarActions) {
            if (action != null) {
                this.initButton(toolbar, action, action instanceof AbstractSVGToggleAction);
                continue;
            }
            toolbar.add((Component)SVGViewTopComponent.createToolBarSeparator(), constrains);
        }
    }

    private JToolBar createToolBar() {
        final SceneManager smgr = this.getSceneManager();
        JToolBar toolbar = new JToolBar();
        toolbar.setLayout(new GridBagLayout());
        toolbar.setFloatable(false);
        toolbar.setFocusable(true);
        Border b = (Border)UIManager.get("Nb.Editor.Toolbar.border");
        toolbar.setBorder(b);
        GridBagConstraints constrains = new GridBagConstraints();
        constrains.anchor = 17;
        constrains.insets = new Insets(0, 3, 0, 2);
        toolbar.add((Component)SVGViewTopComponent.createToolBarSeparator(), constrains);
        this.buttonListener = new ButtonMouseListener();
        this.addButtonsForActions(toolbar, smgr.getToolbarActions("svg_prev_sel", "svg_next_sel", "svg_parent_sel"), constrains);
        toolbar.add((Component)SVGViewTopComponent.createToolBarSeparator(), constrains);
        this.zoomToFitAction = new ZoomToFitAction();
        this.initButton(toolbar, this.zoomToFitAction, false);
        this.zoomComboBox = new JComboBox<String>(ZOOM_VALUES);
        this.initCombo(toolbar, this.zoomComboBox);
        final ComboBoxEditor cbe = this.zoomComboBox.getEditor();
        this.zoomComboBox.setEditor(new ComboBoxEditor(){
            private String m_lastValue = "";

            @Override
            public Component getEditorComponent() {
                return cbe.getEditorComponent();
            }

            @Override
            public void setItem(Object anObject) {
                cbe.setItem(anObject);
            }

            @Override
            public Object getItem() {
                int len;
                String value;
                Object o = cbe.getItem();
                if (o != null && (value = o.toString()) != null && (len = (value = value.trim()).length()) > 0) {
                    if (value.endsWith("%")) {
                        value = value.substring(0, len - 1);
                    }
                    try {
                        float floatValue = Float.parseFloat(value);
                        this.m_lastValue = Math.round(floatValue) + "%";
                        return this.m_lastValue;
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((JTextComponent)cbe.getEditorComponent()).setText(m_lastValue);
                    }
                });
                return this.m_lastValue;
            }

            @Override
            public void selectAll() {
                cbe.selectAll();
            }

            @Override
            public void addActionListener(ActionListener l) {
                cbe.addActionListener(l);
            }

            @Override
            public void removeActionListener(ActionListener l) {
                cbe.removeActionListener(l);
            }
        });
        this.zoomComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String selection;
                ScreenManager scMgr;
                if (smgr.isImageLoaded() && (scMgr = SVGViewTopComponent.this.getScreenManager()) != null && (selection = (String)SVGViewTopComponent.this.zoomComboBox.getSelectedItem()) != null) {
                    if ((selection = selection.trim()).endsWith("%")) {
                        selection = selection.substring(0, selection.length() - 1);
                    }
                    try {
                        float zoom = Float.parseFloat(selection) / 100.0f;
                        if (zoom > 0.0f && zoom < 100.0f) {
                            scMgr.setZoomRatio(zoom);
                        }
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.zoomInAction = new ZoomInAction();
        this.initButton(toolbar, this.zoomInAction, false);
        this.zoomOutAction = new ZoomOutAction();
        this.initButton(toolbar, this.zoomOutAction, false);
        toolbar.add((Component)SVGViewTopComponent.createToolBarSeparator(), constrains);
        this.addButtonsForActions(toolbar, smgr.getToolbarActions("svg_toggle_tooltip", "svg_toggle_highlight"), constrains);
        constrains = new GridBagConstraints();
        constrains.anchor = 17;
        constrains.insets = new Insets(0, 3, 0, 2);
        toolbar.add((Component)SVGViewTopComponent.createToolBarSeparator(), constrains);
        this.scaleAction = new ToggleScaleAction();
        this.scaleToggleButton = this.initButton(toolbar, this.scaleAction, true);
        this.showViewBoxAction = new ToggleShowViewBoxAction();
        this.showViewBoxToggleButton = this.initButton(toolbar, this.showViewBoxAction, true);
        toolbar.add((Component)SVGViewTopComponent.createToolBarSeparator(), constrains);
        this.initButton(toolbar, this.allowEditAction, true);
        this.allowEditAction.setIsSelected(!smgr.isReadOnly());
        this.allowEditAction.setEnabled(this.m_svgDataObject.getPrimaryFile().canWrite());
        toolbar.add((Component)SVGViewTopComponent.createToolBarSeparator(), constrains);
        this.initButton(toolbar, this.insertGraphicsAction, false);
        toolbar.add((Component)SVGViewTopComponent.createToolBarSeparator(), constrains);
        this.rotateLeftModeAction = new RotateLeftModeAction();
        this.initButton(toolbar, this.rotateLeftModeAction, false);
        this.rotateRightModeAction = new RotateRightModeAction();
        this.initButton(toolbar, this.rotateRightModeAction, false);
        toolbar.add((Component)SVGViewTopComponent.createToolBarSeparator(), constrains);
        this.addButtonsForActions(toolbar, smgr.getToolbarActions("svg_delete", null, "svg_move_to_top", "svg_move_to_bottom", "svg_move_forward", "svg_move_backward"), constrains);
        constrains = new GridBagConstraints();
        constrains.anchor = 17;
        constrains.fill = 2;
        constrains.weightx = 1.0;
        toolbar.add((Component)new JPanel(), constrains);
        return toolbar;
    }

    private JToolBar createAnimationBar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setLayout(new GridBagLayout());
        toolbar.setFloatable(false);
        toolbar.setFocusable(true);
        Border b = (Border)UIManager.get("Nb.Editor.Toolbar.border");
        toolbar.setBorder(b);
        GridBagConstraints constrains = new GridBagConstraints();
        constrains.anchor = 17;
        constrains.insets = new Insets(0, 3, 0, 2);
        toolbar.add(Box.createHorizontalStrut(5));
        this.startAnimationButton = this.initButton(toolbar, this.startAnimationAction, true);
        this.startAnimationAction.setIsSelected(false);
        this.pauseAnimationButton = this.initButton(toolbar, this.pauseAnimationAction, true);
        this.pauseAnimationAction.setIsSelected(false);
        toolbar.add((Component)SVGViewTopComponent.createToolBarSeparator(), constrains);
        float currentMaximum = 30.0f;
        this.slider = new JSlider(0, 0, (int)(currentMaximum / 0.1f), 0);
        constrains = new GridBagConstraints();
        constrains.anchor = 17;
        constrains.fill = 2;
        constrains.weightx = 100.0;
        toolbar.add((Component)this.slider, constrains);
        toolbar.add(Box.createHorizontalStrut(11));
        this.currentTimeSpinner = new JSpinner();
        this.currentTimeSpinner.setToolTipText(NbBundle.getMessage(SVGViewTopComponent.class, (String)"HINT_CurrentTime"));
        this.currentTimeSpinner.setModel(new SpinnerNumberModel(new Float(0.0f), new Float(0.0), new Float(2.1474836E9f), new Float(0.1)));
        JComponent editor = this.currentTimeSpinner.getEditor();
        if (editor instanceof JSpinner.NumberEditor) {
            DecimalFormat format = ((JSpinner.NumberEditor)editor).getFormat();
            format.setMinimumFractionDigits(2);
            format.setMaximumFractionDigits(2);
            this.currentTimeSpinner.setValue(new Float(0.0f));
        }
        Font font = this.currentTimeSpinner.getFont();
        FontMetrics fm = this.currentTimeSpinner.getFontMetrics(font);
        int w = fm.stringWidth("000.0");
        Dimension d = this.currentTimeSpinner.getPreferredSize();
        d.width = w + 20;
        this.currentTimeSpinner.setPreferredSize(d);
        constrains = new GridBagConstraints();
        constrains.anchor = 17;
        JLabel currentTimeLabel = new JLabel(NbBundle.getMessage(SVGViewTopComponent.class, (String)"LBL_CurrentTime"));
        toolbar.add((Component)currentTimeLabel, constrains);
        toolbar.add(Box.createHorizontalStrut(4));
        constrains = new GridBagConstraints();
        constrains.anchor = 17;
        constrains.fill = 0;
        constrains.weightx = 0.0;
        toolbar.add((Component)this.currentTimeSpinner, constrains);
        currentTimeLabel.setLabelFor(this.currentTimeSpinner);
        toolbar.add(Box.createHorizontalStrut(4));
        constrains = new GridBagConstraints();
        constrains.anchor = 17;
        JLabel sec = new JLabel(NbBundle.getMessage(SVGViewTopComponent.class, (String)"LBL_Seconds"));
        toolbar.add((Component)sec, constrains);
        toolbar.add(Box.createHorizontalStrut(10));
        return toolbar;
    }

    private AbstractButton initButton(JComponent bar, Action action, boolean isToggle) {
        AbstractButton button;
        Border buttonBorder = UIManager.getBorder("nb.tabbutton.border");
        if (isToggle) {
            final JToggleButton tButton = new JToggleButton(action);
            action.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("selected".equals(evt.getPropertyName())) {
                        tButton.setSelected((Boolean)evt.getNewValue());
                        tButton.repaint();
                    }
                }
            });
            Boolean state = (Boolean)action.getValue("selected");
            if (state != null) {
                tButton.setSelected(state);
            }
            button = tButton;
        } else {
            button = new JButton(action);
        }
        if (buttonBorder != null) {
            button.setBorder(buttonBorder);
        }
        GridBagConstraints constrains = new GridBagConstraints();
        constrains.anchor = 17;
        button.setContentAreaFilled(true);
        button.setBorderPainted(true);
        if (button instanceof JButton) {
            button.addMouseListener((MouseListener)((Object)this.buttonListener));
        }
        button.setFocusable(false);
        bar.add((Component)button, constrains);
        return button;
    }

    private void initCombo(JComponent bar, JComboBox comboBox) {
        GridBagConstraints constrains = new GridBagConstraints();
        constrains.anchor = 17;
        comboBox.setFocusable(false);
        Dimension size = comboBox.getPreferredSize();
        comboBox.setPreferredSize(size);
        comboBox.setSize(size);
        comboBox.setMinimumSize(size);
        comboBox.setMaximumSize(size);
        comboBox.setEditable(true);
        bar.add((Component)comboBox, constrains);
    }

    private void updateDataTransferActions() {
        boolean isReadOnly = this.getSceneManager().isReadOnly();
        boolean isSelected = this.getSceneManager().getSelected() != null;
        this.m_pasteAction.setEnabled(!isReadOnly);
        this.m_cutAction.setEnabled(!isReadOnly && isSelected);
        this.m_copyAction.setEnabled(isSelected);
    }

    private void updateAnimationActions() {
        PerseusController pc = this.getPerseusController();
        if (pc != null) {
            int state = pc.getAnimatorState();
            boolean isReadOnly = this.getSceneManager().isReadOnly();
            boolean isAnimAvailable = state != 0;
            SVGViewTopComponent.enableComponentsInToolbar(this.animationToolbar, isReadOnly && isAnimAvailable, this.startAnimationButton, this.pauseAnimationButton);
            this.startAnimationAction.setEnabled(isAnimAvailable);
            boolean isActive = isReadOnly && pc.isAnimatorStarted();
            this.startAnimationAction.setIsSelected(isActive);
            this.pauseAnimationAction.setEnabled(isActive);
            this.pauseAnimationAction.setIsSelected(state == 3);
        } else {
            this.disableAnimationActions();
        }
    }

    private void disableAnimationActions() {
        SVGViewTopComponent.enableComponentsInToolbar(this.animationToolbar, false, this.startAnimationButton, this.pauseAnimationButton);
        this.startAnimationAction.setEnabled(false);
        this.pauseAnimationAction.setEnabled(false);
    }

    private static JSeparator createToolBarSeparator() {
        JSeparator toolBarSeparator = new JSeparator(1);
        Dimension dim = new Dimension(2, 22);
        toolBarSeparator.setPreferredSize(dim);
        toolBarSeparator.setSize(dim);
        toolBarSeparator.setMinimumSize(dim);
        return toolBarSeparator;
    }

    protected void updateZoomCombo() {
        this.zoomComboBox.getEditor().setItem(Integer.toString((int)((double)(this.getScreenManager().getZoomRatio() * 100.0f) + 0.5)) + "%");
    }

    protected synchronized void updateImage() {
        assert (SwingUtilities.isEventDispatchThread()) : "Not in AWT event dispach thread";
        this.disableImageContext();
        this.getSceneManager().saveSelection();
        if (this.parsingTask != null) {
            this.parsingTask.cancel();
        }
        try {
            this.parsingTask = new ParsingTask(this.m_svgDataObject, this);
            this.parsingTask.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void enableImageContext() {
        for (Action action : this.getImageContextActions()) {
            action.setEnabled(true);
        }
        this.updateAnimationActions();
    }

    void showImage(SVGImage img) {
        assert (SwingUtilities.isEventDispatchThread()) : "Not in AWT event dispach thread";
        SceneManager smgr = this.getSceneManager();
        this.basePanel.removeAll();
        smgr.setImage(img);
        smgr.restoreSelection();
        JComponent topComponent = smgr.getComposerGUI();
        topComponent.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getWheelRotation() < 0) {
                    SVGViewTopComponent.this.zoomOutAction.actionPerformed(null);
                } else {
                    SVGViewTopComponent.this.zoomInAction.actionPerformed(null);
                }
            }
        });
        this.basePanel.add((Component)topComponent, "Center");
        topComponent.setDropTarget(new DropTarget(topComponent, new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent dtde) {
                SVGViewTopComponent.this.doDrag(dtde);
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
            }

            @Override
            public void dragOver(DropTargetDragEvent dtde) {
                SVGViewTopComponent.this.doDrag(dtde);
            }

            @Override
            public void drop(DropTargetDropEvent dtde) {
                SVGViewTopComponent.this.doDrop(dtde);
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent dtde) {
            }
        }));
        smgr.registerPopupActions(new Action[]{this.insertGraphicsAction, this.zoomToFitAction, this.zoomInAction, this.zoomOutAction, this.scaleAction, this.showViewBoxAction, this.rotateLeftModeAction, this.rotateRightModeAction, this.startAnimationAction, this.pauseAnimationAction, this.allowEditAction}, this, this.lookup);
        this.updateZoomCombo();
        this.enableImageContext();
        smgr.processEvent(SceneManager.createEvent(this, 2535));
        SVGLocatableElement elem = this.getPerseusController().getViewBoxMarker();
        ScreenManager scrMgr = this.getScreenManager();
        if (elem == null) {
            this.showViewBoxAction.setEnabled(false);
            scrMgr.setShowAllArea(true);
        } else {
            this.showViewBoxAction.setEnabled(true);
        }
        this.rotateLeftModeAction.setEnabled(true);
        this.rotateRightModeAction.setEnabled(true);
        this.showViewBoxToggleButton.setSelected(scrMgr.getShowAllArea());
        scrMgr.setLandscapeMode(this.getPerseusController().isImgHorizontallyOriented());
        topComponent.requestFocus();
        this.repaintAll();
    }

    private void disableImageContext() {
        for (Action action : this.getImageContextActions()) {
            action.setEnabled(false);
        }
        this.disableAnimationActions();
    }

    private void doDrag(DropTargetDragEvent dtde) {
        if (this.getDroppedDataObject(dtde) != null) {
            dtde.acceptDrag(3);
        } else {
            dtde.rejectDrag();
        }
    }

    private float[] getSVGPoint(DropTargetDropEvent dtde) {
        Point onTopComponent = dtde.getLocation();
        Point imageZero = this.getScreenManager().getAnimatorView().getLocation();
        float zoom = this.getScreenManager().getZoomRatio();
        float x = (float)(onTopComponent.getX() - imageZero.getX()) / zoom;
        float y = (float)(onTopComponent.getY() - imageZero.getY()) / zoom;
        return new float[]{x, y};
    }

    private void doDrop(DropTargetDropEvent dtde) {
        float[] point = this.getSVGPoint(dtde);
        DataObject dObj = this.getDroppedDataObject(dtde);
        if (dObj != null) {
            dtde.acceptDrop(3);
            try {
                if (this.dropDataObject(dObj, point)) {
                    dtde.dropComplete(true);
                }
            }
            catch (Exception e) {
                SceneManager.error("Could not obtain dropped data.", e);
                dtde.dropComplete(false);
            }
        } else {
            dtde.rejectDrop();
        }
    }

    public boolean dropDataObject(DataObject dObj, float[] point) throws IOException, SAXException, DocumentModelException, BadLocationException {
        if (dObj instanceof XMLDataObject) {
            Document doc = ((XMLDataObject)dObj).getDocument();
            SVGComponentDrop dropSupport = this.getAEDClass(doc);
            if (dropSupport != null) {
                return dropSupport.handleTransfer(this.m_svgDataObject, point);
            }
            String snippet = this.getSnippetBody(doc);
            if (snippet != null) {
                return SVGComponentDrop.getDefault(snippet).handleTransfer(this.m_svgDataObject, point);
            }
            SceneManager.log(Level.SEVERE, "Nothing to drop, empty body and class!");
            return true;
        }
        if (dObj instanceof SVGPaletteItemDataObject) {
            this.dropFile(((SVGPaletteItemDataObject)dObj).getReferencedFile());
            return true;
        }
        if (dObj instanceof SVGDataObject) {
            this.dropFile(FileUtil.toFile((FileObject)dObj.getPrimaryFile()));
            return true;
        }
        return false;
    }

    private String getSnippetBody(Document doc) {
        String snippet = null;
        NodeList bodyTags = doc.getElementsByTagName("body");
        if (bodyTags.getLength() > 0) {
            snippet = bodyTags.item(0).getTextContent();
        }
        return snippet;
    }

    private SVGComponentDrop getAEDClass(Document doc) {
        String className = this.getClassName(doc);
        if (className != null) {
            try {
                Class<?> nameClass = this.getClass().getClassLoader().loadClass(className);
                if (SVGComponentDrop.class.isAssignableFrom(nameClass)) {
                    SVGComponentDrop impl = (SVGComponentDrop)nameClass.newInstance();
                    return impl;
                }
                SceneManager.log(Level.SEVERE, "className doesn't implement SVGComponentDrop!");
            }
            catch (Exception ex) {
                SceneManager.log(Level.SEVERE, "can't create " + className + " instance", ex);
            }
        }
        return null;
    }

    private String getClassName(Document doc) {
        NamedNodeMap attrs;
        Node nameNode;
        Node classNode;
        String name = null;
        NodeList classTags = doc.getElementsByTagName("class");
        if (classTags.getLength() > 0 && (classNode = classTags.item(0)).hasAttributes() && (nameNode = (attrs = classNode.getAttributes()).getNamedItem("name")) != null) {
            name = nameNode.getNodeValue();
        }
        return name;
    }

    private void dropFile(File file) throws FileNotFoundException, IOException, DocumentModelException, BadLocationException {
        if (file != null && file.exists() && file.isFile()) {
            SceneManager.log(Level.INFO, "Dropping file " + file.getPath());
            String id = this.m_svgDataObject.getModel().mergeImage(file);
            this.getSceneManager().setSelection(id, true);
        } else {
            SceneManager.log(Level.SEVERE, "Nothing to drop, file " + file + " not found");
        }
    }

    private DataObject getDroppedDataObject(DropTargetEvent dte) {
        if (!this.getSceneManager().isReadOnly()) {
            DataFlavor[] flavors;
            for (DataFlavor flavor : flavors = dte instanceof DropTargetDragEvent ? ((DropTargetDragEvent)dte).getCurrentDataFlavors() : ((DropTargetDropEvent)dte).getCurrentDataFlavors()) {
                if (!DND_PALETTE_MIME.equals(flavor.getSubType())) continue;
                try {
                    Transferable transferable = dte instanceof DropTargetDragEvent ? ((DropTargetDragEvent)dte).getTransferable() : ((DropTargetDropEvent)dte).getTransferable();
                    DataObject dObj = (DataObject)transferable.getTransferData(flavor);
                    if (dObj instanceof XMLDataObject || dObj instanceof SVGPaletteItemDataObject || dObj instanceof SVGDataObject) {
                        return dObj;
                    }
                }
                catch (Exception e) {
                    SceneManager.error("Failed to get dropped data object", e);
                }
            }
        }
        return null;
    }

    @Override
    public void selectionChanged(SVGObject[] newSelection, SVGObject[] oldSelection, boolean isReadOnly) {
        this.updateDataTransferActions();
    }

    private void repaintAll() {
        this.getScreenManager().getAnimatorView().invalidate();
        this.basePanel.validate();
        this.basePanel.repaint();
    }

    private SVGFileModel getModel() {
        return this.m_svgDataObject.getModel();
    }

    private static Clipboard getClipboard() {
        Clipboard c = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
        if (c == null) {
            c = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return c;
    }

    private static void enableComponentsInToolbar(Container component, boolean enable, Component ... skip) {
        block0: for (Component comp : component.getComponents()) {
            if (skip != null) {
                for (Component skipped : skip) {
                    if (skipped == comp) continue block0;
                }
            }
            comp.setEnabled(enable);
            SVGViewTopComponent.enableComponentsInToolbar((Container)comp, enable, new Component[0]);
        }
    }

    private class SVGCookie
    implements SelectionCookie,
    AnimationCookie {
        private SVGCookie() {
        }

        @Override
        public void startAnimation(SVGDataObject doj, final String id) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SVGViewTopComponent.this.startAnimationAction.actionPerformed(null);
                    SVGViewTopComponent.this.getPerseusController().startAnimation(id);
                }
            });
        }

        @Override
        public void stopAnimation(SVGDataObject doj, final String id) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SVGViewTopComponent.this.getPerseusController().stopAnimation(id);
                }
            });
        }

        @Override
        public void updateSelection(SVGDataObject doj, final String id, int startOff, boolean doubleClick) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SVGViewTopComponent.this.getSceneManager().setSelection(id, false);
                }
            });
        }
    }

    private class ZoomOutAction
    extends AbstractSVGAction {
        private static final long serialVersionUID = 5862679852552354L;

        ZoomOutAction() {
            super("svg_zoom_out");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScreenManager smgr = SVGViewTopComponent.this.getScreenManager();
            smgr.setZoomRatio(smgr.getZoomRatio() / 1.1f);
            SVGViewTopComponent.this.updateZoomCombo();
        }
    }

    private class ZoomInAction
    extends AbstractSVGAction {
        private static final long serialVersionUID = 5862679852552354L;

        ZoomInAction() {
            super("svg_zoom_in");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScreenManager smgr = SVGViewTopComponent.this.getScreenManager();
            smgr.setZoomRatio(smgr.getZoomRatio() * 1.1f);
            SVGViewTopComponent.this.updateZoomCombo();
        }
    }

    private class ZoomToFitAction
    extends AbstractSVGAction {
        private static final long serialVersionUID = 5862679852552354L;

        ZoomToFitAction() {
            super("svg_zoom_fit");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScreenManager smgr = SVGViewTopComponent.this.getScreenManager();
            Rectangle imgBounds = smgr.getImageBounds();
            Rectangle panelBounds = smgr.getComponent().getBounds();
            float zoomRatio = Math.min((float)(panelBounds.width - 20) / (float)imgBounds.width, (float)(panelBounds.height - 20) / (float)imgBounds.height);
            smgr.setZoomRatio(zoomRatio * smgr.getZoomRatio());
            SVGViewTopComponent.this.updateZoomCombo();
        }
    }

    private abstract class AbstractRotateModeAction
    extends AbstractSVGAction
    implements Presenter.Popup {
        private static final long serialVersionUID = 5862679852552354L;
        private boolean rotateRight;

        AbstractRotateModeAction(String name, boolean rotateRight) {
            super(name);
            this.rotateRight = rotateRight;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScreenManager smgr = SVGViewTopComponent.this.getScreenManager();
            boolean b = !smgr.isLandscapeMode();
            Map<DocumentElement, String[]> attrsByElement = this.changeViewBox(b);
            Map<String, String[]> attrsById = this.rotateElements();
            SVGViewTopComponent.this.getModel().setAttributes(attrsById, attrsByElement);
            smgr.setLandscapeMode(b);
            SVGViewTopComponent.this.updateImage();
        }

        private Map<DocumentElement, String[]> changeViewBox(boolean isLandscape) {
            SVGSVGElement svg = SVGViewTopComponent.this.getSceneManager().getPerseusController().getSVGRootElement();
            SVGRect rect = svg.getRectTrait("viewBox");
            if (SVGViewTopComponent.this.getScreenManager().isLandscapeMode() != isLandscape) {
                float w = rect.getWidth();
                float h = rect.getHeight();
                rect.setHeight(w);
                rect.setWidth(h);
                SVGViewTopComponent.this.getModel();
                DocumentElement svgRoot = SVGFileModel.getSVGRoot(SVGViewTopComponent.this.getModel().getModel());
                String[] attributes = new String[]{"viewBox", rect.getX() + " " + rect.getY() + " " + rect.getWidth() + " " + rect.getHeight(), "width", String.valueOf(rect.getWidth()), "height", String.valueOf(rect.getHeight())};
                HashMap<DocumentElement, String[]> textChanges = new HashMap<DocumentElement, String[]>();
                textChanges.put(svgRoot, attributes);
                return textChanges;
            }
            return null;
        }

        private Map<String, String[]> rotateElements() {
            float[] fArray;
            float translateW;
            SceneManager m_sceneMgr = SVGViewTopComponent.this.getSceneManager();
            int angle = this.rotateRight ? 90 : -90;
            SVGSVGElement svgRoot = m_sceneMgr.getPerseusController().getSVGRootElement();
            SVGRect viewBoxRect = svgRoot.getRectTrait("viewBox");
            float translateH = viewBoxRect != null ? viewBoxRect.getHeight() : 0.0f;
            float f = translateW = viewBoxRect != null ? viewBoxRect.getWidth() : 0.0f;
            if (this.rotateRight) {
                float[] fArray2 = new float[2];
                fArray2[0] = translateH;
                fArray = fArray2;
                fArray2[1] = 0.0f;
            } else {
                float[] fArray3 = new float[2];
                fArray3[0] = 0.0f;
                fArray = fArray3;
                fArray3[1] = translateW;
            }
            float[] translate = fArray;
            Rectangle bBox = new Rectangle();
            HashMap<String, String[]> textChanges = new HashMap<String, String[]>();
            for (SVGElement elem = (SVGElement)svgRoot.getFirstElementChild(); elem != null; elem = (SVGElement)elem.getNextElementSibling()) {
                this.rotateElement(elem, angle, translate, textChanges, bBox);
            }
            m_sceneMgr.getScreenManager().repaint(bBox, 5);
            m_sceneMgr.getScreenManager().refresh();
            return textChanges;
        }

        private void rotateElement(SVGElement elem, int angle, float[] translate, Map<String, String[]> textChanges, Rectangle bBox) {
            SVGObject obj = SVGViewTopComponent.this.getSceneManager().getPerseusController().getObjectForSVGElement(elem);
            if (obj == null) {
                return;
            }
            bBox.add(obj.getScreenBBox());
            obj.setLandscape(angle, translate);
            bBox.add(obj.getScreenBBox());
            if (!"$VIEWBOX$".equals(obj.getElementId())) {
                textChanges.put(obj.getElementId(), obj.prepareTextChanges());
            }
            obj.commitChanges();
        }
    }

    private class RotateRightModeAction
    extends AbstractRotateModeAction {
        public RotateRightModeAction() {
            super("svg_rotate_r_mode", true);
        }
    }

    private class RotateLeftModeAction
    extends AbstractRotateModeAction {
        public RotateLeftModeAction() {
            super("svg_rotate_l_mode", false);
        }
    }

    private class ToggleShowViewBoxAction
    extends AbstractSVGAction
    implements Presenter.Popup {
        private static final long serialVersionUID = 5862679852552354L;

        ToggleShowViewBoxAction() {
            super("svg_toggle_view");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScreenManager smgr = SVGViewTopComponent.this.getScreenManager();
            boolean b = !smgr.getShowAllArea();
            smgr.setShowAllArea(b);
            SVGViewTopComponent.this.showViewBoxToggleButton.setSelected(b);
            SVGViewTopComponent.this.repaint();
        }
    }

    private class ToggleScaleAction
    extends AbstractSVGAction {
        private static final long serialVersionUID = 5862679852552354L;
        private float m_previousZoomRatio;

        ToggleScaleAction() {
            super("svg_toggle_scale");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScreenManager smgr = SVGViewTopComponent.this.getScreenManager();
            SVGViewTopComponent.this.doScale = !SVGViewTopComponent.this.doScale;
            if (SVGViewTopComponent.this.doScale) {
                this.m_previousZoomRatio = smgr.getZoomRatio();
                String activeConfiguration = null;
                FileObject primaryFile = SVGViewTopComponent.this.m_svgDataObject.getPrimaryFile();
                Project p = FileOwnerQuery.getOwner((FileObject)primaryFile);
                if (p != null && p instanceof J2MEProject) {
                    J2MEProject project = (J2MEProject)p;
                    activeConfiguration = project.getConfigurationHelper().getActiveConfiguration().getDisplayName();
                }
                Dimension dim = ScreenSizeHelper.getCurrentDeviceScreenSize(primaryFile, activeConfiguration);
                Rectangle imgBounds = smgr.getImageBounds();
                float ratio = (float)(dim.getHeight() / imgBounds.getHeight());
                smgr.setZoomRatio(ratio * this.m_previousZoomRatio);
            } else {
                smgr.setZoomRatio(this.m_previousZoomRatio);
            }
            SVGViewTopComponent.this.scaleToggleButton.setSelected(SVGViewTopComponent.this.doScale);
            SVGViewTopComponent.this.zoomInAction.setEnabled(!SVGViewTopComponent.this.doScale);
            SVGViewTopComponent.this.zoomOutAction.setEnabled(!SVGViewTopComponent.this.doScale);
            SVGViewTopComponent.this.zoomToFitAction.setEnabled(!SVGViewTopComponent.this.doScale);
            SVGViewTopComponent.this.zoomComboBox.setEnabled(!SVGViewTopComponent.this.doScale);
            SVGViewTopComponent.this.repaint();
        }
    }

    private class ButtonMouseListener
    extends MouseUtils.PopupMouseAdapter {
        private ButtonMouseListener() {
        }

        public void mouseEntered(MouseEvent evt) {
            JButton button;
            if (evt.getSource() instanceof JButton && (button = (JButton)evt.getSource()).isEnabled()) {
                button.setContentAreaFilled(true);
                button.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent evt) {
            JButton button;
            if (evt.getSource() instanceof JButton && (button = (JButton)evt.getSource()).isEnabled()) {
                button.setContentAreaFilled(false);
                button.setBorderPainted(false);
            }
        }

        protected void showPopup(MouseEvent evt) {
        }
    }

    private class SVGElementNode
    extends AbstractNode {
        SVGElementNode(Lookup lookup) {
            super(Children.LEAF, lookup);
        }

        protected Class[] cookieClasses() {
            return new Class[]{SVGObject.class};
        }

        public Action[] getActions(boolean context) {
            return new SystemAction[]{SystemAction.get(SaveElementAsImage.class)};
        }
    }

    private static class LoadPanel
    extends JPanel {
        private static final long serialVersionUID = 5862679852552354L;

        LoadPanel() {
            this.setLayout(new BorderLayout());
            this.setBackground(Color.WHITE);
            JLabel loadingLabel = new JLabel(NbBundle.getMessage(SVGViewTopComponent.class, (String)"MSG_Loading"));
            loadingLabel.setBackground(Color.WHITE);
            Font font = loadingLabel.getFont();
            loadingLabel.setFont(font.deriveFont(20.0f));
            this.add((Component)loadingLabel, "Center");
        }
    }

    private final class UpdateThread
    extends Thread {
        public UpdateThread() {
            super("AnimatorTimeUpdater");
            this.setDaemon(true);
            this.setPriority(1);
        }

        @Override
        public void run() {
            try {
                PerseusController pctrl;
                while ((pctrl = SVGViewTopComponent.this.getPerseusController()) != null && !this.isInterrupted()) {
                    if (pctrl.getAnimatorState() == 2) {
                        final float time = pctrl.getAnimatorTime();
                        final float maxTime = SVGViewTopComponent.this.getSceneManager().getAnimationDuration();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SVGViewTopComponent.this.updateAnimationTime(time, maxTime);
                            }
                        });
                    }
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

