/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.subpanels;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.wsitconf.spi.SaveablePanel;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMDeliveryAssurance;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMSequenceBinding;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.openide.util.NbBundle;

public class AdvancedRMPanel
extends JPanel
implements SaveablePanel {
    private Binding binding;
    private boolean inSync = false;
    private DefaultFormatterFactory milisecondsff = null;
    private DefaultFormatterFactory maxBufff = null;
    private ConfigVersion cfgVersion = null;
    private JComboBox deliveryAssuranceCombo;
    private JLabel deliveryAssuranceLabel;
    private JCheckBox flowControlChBox;
    private JLabel inactivityTimeoutLabel;
    private JFormattedTextField inactivityTimeoutTextfield;
    private JLabel maxBufLabel;
    private JFormattedTextField maxBufTextField;

    public AdvancedRMPanel(Binding binding, ConfigVersion cfgVersion) {
        this.binding = binding;
        this.cfgVersion = cfgVersion;
        this.milisecondsff = new DefaultFormatterFactory();
        NumberFormat millisecondsFormat = NumberFormat.getIntegerInstance();
        millisecondsFormat.setGroupingUsed(false);
        NumberFormatter millisecondsFormatter = new NumberFormatter(millisecondsFormat);
        millisecondsFormat.setMaximumIntegerDigits(8);
        millisecondsFormatter.setCommitsOnValidEdit(true);
        millisecondsFormatter.setMinimum(Integer.valueOf(0));
        millisecondsFormatter.setMaximum(Integer.valueOf(99999999));
        this.milisecondsff.setDefaultFormatter(millisecondsFormatter);
        this.maxBufff = new DefaultFormatterFactory();
        NumberFormat maxBufFormat = NumberFormat.getIntegerInstance();
        maxBufFormat.setGroupingUsed(false);
        NumberFormatter maxBufFormatter = new NumberFormatter(maxBufFormat);
        maxBufFormat.setMaximumIntegerDigits(8);
        maxBufFormatter.setCommitsOnValidEdit(true);
        maxBufFormatter.setMinimum(Integer.valueOf(0));
        maxBufFormatter.setMaximum(Integer.valueOf(99999999));
        this.maxBufff.setDefaultFormatter(maxBufFormatter);
        this.initComponents();
        this.inSync = true;
        for (RMDeliveryAssurance assurance : RMDeliveryAssurance.values()) {
            this.deliveryAssuranceCombo.addItem(assurance);
        }
        this.inSync = false;
        this.sync();
        this.refresh();
    }

    private void sync() {
        this.inSync = true;
        String inactivityTimeout = RMModelHelper.getInstance(this.cfgVersion).getInactivityTimeout(this.binding);
        if (inactivityTimeout == null) {
            this.setTextField(this.inactivityTimeoutTextfield, "600000");
        } else {
            this.setTextField(this.inactivityTimeoutTextfield, inactivityTimeout);
        }
        String maxRcvBufferSize = RMModelHelper.getMaxReceiveBufferSize(this.binding);
        if (maxRcvBufferSize == null) {
            this.setTextField(this.maxBufTextField, "32");
        } else {
            this.setTextField(this.maxBufTextField, maxRcvBufferSize);
        }
        this.setChBox(this.flowControlChBox, RMModelHelper.isFlowControl(this.binding));
        RMDeliveryAssurance assurance = RMDeliveryAssurance.getValue(this.cfgVersion, this.binding);
        if (assurance == null) {
            assurance = RMDeliveryAssurance.getDefault();
        }
        this.setCombo(this.deliveryAssuranceCombo, (Object)assurance);
        RMSequenceBinding seq = RMSequenceBinding.getValue(this.cfgVersion, this.binding);
        if (seq == null) {
            seq = RMSequenceBinding.getDefault();
        }
        this.enableDisable();
        this.inSync = false;
    }

    protected void setCombo(JComboBox combo, Object item) {
        if (item == null) {
            combo.setSelectedIndex(0);
        } else {
            combo.setSelectedItem(item);
        }
    }

    private Number getTextField(JFormattedTextField textField) {
        return (Number)textField.getValue();
    }

    private void setTextField(JFormattedTextField field, String value) {
        field.setText(value);
    }

    protected void setChBox(JCheckBox chBox, Boolean enable) {
        if (enable == null) {
            chBox.setSelected(false);
        } else {
            chBox.setSelected(enable);
        }
    }

    @Override
    public void storeState() {
        Number timeout;
        boolean flowControl = this.flowControlChBox.isSelected();
        if (flowControl != RMModelHelper.isFlowControl(this.binding)) {
            RMModelHelper.getInstance(this.cfgVersion).enableFlowControl(this.binding, flowControl);
        }
        if ((timeout = this.getTextField(this.inactivityTimeoutTextfield)) == null || "600000".equals(timeout.toString())) {
            RMModelHelper.getInstance(this.cfgVersion).setInactivityTimeout(this.binding, null);
        } else {
            RMModelHelper.getInstance(this.cfgVersion).setInactivityTimeout(this.binding, timeout.toString());
        }
        Number bufSize = this.getTextField(this.maxBufTextField);
        if (bufSize == null || "32".equals(bufSize.toString())) {
            RMModelHelper.setMaxReceiveBufferSize(this.binding, null);
        } else {
            RMModelHelper.setMaxReceiveBufferSize(this.binding, bufSize.toString());
        }
        ((RMDeliveryAssurance)((Object)this.deliveryAssuranceCombo.getSelectedItem())).set(this.cfgVersion, this.binding);
    }

    private void enableDisable() {
        boolean flowSelected = this.flowControlChBox.isSelected();
        this.maxBufLabel.setEnabled(flowSelected);
        this.maxBufTextField.setEnabled(flowSelected);
    }

    private void initComponents() {
        this.flowControlChBox = new JCheckBox();
        this.maxBufLabel = new JLabel();
        this.inactivityTimeoutLabel = new JLabel();
        this.inactivityTimeoutTextfield = new JFormattedTextField();
        this.maxBufTextField = new JFormattedTextField();
        this.deliveryAssuranceLabel = new JLabel();
        this.deliveryAssuranceCombo = new JComboBox();
        this.flowControlChBox.setText(NbBundle.getMessage(AdvancedRMPanel.class, (String)"LBL_AdvancedRM_FlowControlChBox"));
        this.flowControlChBox.setMargin(new Insets(0, 0, 0, 0));
        this.flowControlChBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedRMPanel.this.flowControlChBoxActionPerformed(evt);
            }
        });
        this.maxBufLabel.setText(NbBundle.getMessage(AdvancedRMPanel.class, (String)"LBL_AdvancedRM_maxBufLabel"));
        this.inactivityTimeoutLabel.setText(NbBundle.getMessage(AdvancedRMPanel.class, (String)"LBL_AdvancedRM_InactivityTimeoutLabel"));
        this.inactivityTimeoutTextfield.setFormatterFactory(this.milisecondsff);
        this.maxBufTextField.setColumns(8);
        this.maxBufTextField.setFormatterFactory(this.maxBufff);
        this.deliveryAssuranceLabel.setText(NbBundle.getMessage(AdvancedRMPanel.class, (String)"LBL_AdvancedRM_DeliveryAssurance"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.flowControlChBox).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.maxBufLabel).add((Component)this.inactivityTimeoutLabel).add((Component)this.deliveryAssuranceLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.deliveryAssuranceCombo, 0, 135, Short.MAX_VALUE).add((Component)this.inactivityTimeoutTextfield, -1, 135, Short.MAX_VALUE).add((Component)this.maxBufTextField, -1, 135, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.deliveryAssuranceLabel).add((Component)this.deliveryAssuranceCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.flowControlChBox).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.maxBufLabel).add((Component)this.maxBufTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.inactivityTimeoutLabel).add((Component)this.inactivityTimeoutTextfield, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.deliveryAssuranceCombo, this.inactivityTimeoutTextfield, this.maxBufTextField}, 2);
        this.flowControlChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedRMPanel.class, (String)"LBL_AdvancedRM_FlowControl_ACSD"));
        this.maxBufLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedRMPanel.class, (String)"LBL_AdvancedRM_MaxFlowBufSize_ACSD"));
        this.inactivityTimeoutLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedRMPanel.class, (String)"LBL_AdvancedRM_InactTimeout_ACSD"));
        this.inactivityTimeoutTextfield.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AdvancedRMPanel.class, (String)"TXT_AdvancedRM_InactTimeout_ACSN"));
        this.inactivityTimeoutTextfield.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedRMPanel.class, (String)"TXT_AdvancedRM_InactTimeout_ACSD"));
        this.maxBufTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AdvancedRMPanel.class, (String)"TXT_AdvancedRM_MaxBuf_ACSN"));
        this.maxBufTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedRMPanel.class, (String)"TXT_AdvancedRM_MaxBuf_ACSD"));
    }

    private void refresh() {
        GroupLayout layout = (GroupLayout)this.getLayout();
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.flowControlChBox).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.maxBufLabel).add((Component)this.inactivityTimeoutLabel).add((Component)this.deliveryAssuranceLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.deliveryAssuranceCombo, 0, -1, Short.MAX_VALUE).add((Component)this.inactivityTimeoutTextfield, -1, 135, Short.MAX_VALUE).add((Component)this.maxBufTextField, -1, 135, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.deliveryAssuranceLabel).add((Component)this.deliveryAssuranceCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.flowControlChBox).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.maxBufLabel).add((Component)this.maxBufTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.inactivityTimeoutLabel).add((Component)this.inactivityTimeoutTextfield, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.deliveryAssuranceCombo, this.inactivityTimeoutTextfield, this.maxBufTextField}, 2);
        this.flowControlChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedRMPanel.class, (String)"LBL_AdvancedRM_FlowControl_ACSD"));
        this.maxBufLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedRMPanel.class, (String)"LBL_AdvancedRM_MaxFlowBufSize_ACSD"));
        this.inactivityTimeoutLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedRMPanel.class, (String)"LBL_AdvancedRM_InactTimeout_ACSD"));
        this.inactivityTimeoutTextfield.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AdvancedRMPanel.class, (String)"TXT_AdvancedRM_InactTimeout_ACSN"));
        this.inactivityTimeoutTextfield.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedRMPanel.class, (String)"TXT_AdvancedRM_InactTimeout_ACSD"));
        this.maxBufTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AdvancedRMPanel.class, (String)"TXT_AdvancedRM_MaxBuf_ACSN"));
        this.maxBufTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedRMPanel.class, (String)"TXT_AdvancedRM_MaxBuf_ACSD"));
        this.validate();
    }

    private void flowControlChBoxActionPerformed(ActionEvent evt) {
        this.enableDisable();
    }
}

