/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform.startup;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

public class LibraryConverter
extends FileChangeAdapter {
    private static final byte[] target = "<type>j2me</type>".getBytes();

    public LibraryConverter() {
        try {
            FileObject rep = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)"org-netbeans-api-project-libraries/Libraries");
            rep.addFileChangeListener((FileChangeListener)this);
            FileObject[] fo = rep.getChildren();
            for (int i = 0; i < fo.length; ++i) {
                this.convertLibrary(fo[i]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void fileDataCreated(FileEvent fe) {
        this.convertLibrary(fe.getFile());
    }

    public void convertLibrary(FileObject fo) {
        block7: {
            if (fo == null || !fo.isData() || !"xml".equals(fo.getExt())) {
                return;
            }
            int size = (int)fo.getSize();
            if (size <= 0) {
                return;
            }
            final byte[] buffer = new byte[size];
            DataInputStream in = null;
            try {
                in = new DataInputStream(fo.getInputStream());
                in.readFully(buffer);
                in.close();
                if (this.replace(buffer)) {
                    final String name = fo.getNameExt();
                    final FileObject parent = fo.getParent();
                    fo.delete();
                    parent.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() throws IOException {
                            OutputStream out = null;
                            try {
                                out = parent.createData(name).getOutputStream();
                                out.write(buffer);
                            }
                            finally {
                                if (out != null) {
                                    try {
                                        out.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                        }
                    });
                }
            }
            catch (IOException ioe) {
                if (in == null) break block7;
                try {
                    in.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    private boolean replace(byte[] source) {
        if (source.length < target.length) {
            return false;
        }
        byte first = target[0];
        int max = source.length - target.length;
        for (int i = 0; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + target.length - 1;
            int k = 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            source[i + 8] = 115;
            return true;
        }
        return false;
    }
}

