/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.ide;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.api.UISupport;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerServerSettings;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.ide.JBDeploymentStatus;
import org.netbeans.modules.j2ee.jboss4.ide.JBLogWriter;
import org.netbeans.modules.j2ee.jboss4.ide.JBStartServer;
import org.netbeans.modules.j2ee.jboss4.ide.ui.JBPluginUtils;
import org.netbeans.modules.j2ee.jboss4.util.JBProperties;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

class JBStartRunnable
implements Runnable {
    private static final String CONF_FILE_NAME = "run.conf.bat";
    private static final String RUN_FILE_NAME = "run.bat";
    private static final String JBOSS_HOME = "JBOSS_HOME";
    private static final String STARTUP_SH = File.separator + "bin" + File.separator + "run.sh";
    private static final String STARTUP_BAT = File.separator + "bin" + File.separator + "run.bat";
    private static final String CONF_BAT = File.separator + "bin" + File.separator + "run.conf.bat";
    private static final String JAVA_OPTS = "JAVA_OPTS";
    private static final Pattern IF_JAVA_OPTS_PATTERN = Pattern.compile(".*if(\\s+not)?\\s+(\"x%JAVA_OPTS%\"\\s+==\\s+\"x\")\\s+.*", 32);
    private static final String NEW_IF_CONDITION_STRING = "\"xx\" == \"x\"";
    private static final SpecificationVersion JDK_14 = new SpecificationVersion("1.4");
    private JBDeploymentManager dm;
    private String instanceName;
    private JBStartServer startServer;
    private ProfilerServerSettings profilerSettings;

    JBStartRunnable(ProfilerServerSettings profilerServerSettings, JBDeploymentManager jBDeploymentManager, JBStartServer jBStartServer) {
        this.dm = jBDeploymentManager;
        this.instanceName = jBDeploymentManager.getInstanceProperties().getProperty("displayName");
        this.startServer = jBStartServer;
        this.profilerSettings = profilerServerSettings;
    }

    @Override
    public void run() {
        InstanceProperties instanceProperties = this.dm.getInstanceProperties();
        boolean bl = this.checkPorts(instanceProperties);
        if (!bl) {
            return;
        }
        Process process = this.createProcess(instanceProperties);
        if (process == null) {
            return;
        }
        JBLogWriter jBLogWriter = this.createLogWriter();
        this.waitForServerToStart(jBLogWriter, process);
    }

    private String[] createEnvironment(InstanceProperties instanceProperties) {
        int n;
        String[] stringArray;
        JBProperties jBProperties = this.dm.getProperties();
        String string = jBProperties.getJavaOpts();
        StringBuilder stringBuilder = new StringBuilder(string);
        boolean bl = jBProperties.isVersion(JBPluginUtils.JBOSS_5_0_0);
        if (!bl && jBProperties.getProxyEnabled()) {
            String[] object = stringArray = new String[]{"http.proxyHost", "http.proxyPort", "http.nonProxyHosts", "https.proxyHost", "https.proxyPort"};
            n = object.length;
            for (int i = 0; i < n; ++i) {
                String string2;
                String string3 = object[i];
                if (string.indexOf(string3) != -1 || (string2 = System.getProperty(string3)) == null) continue;
                if ("http.nonProxyHosts".equals(string3)) {
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new StringReader(string2));
                        String string4 = null;
                        StringBuilder stringBuilder2 = new StringBuilder();
                        while ((string4 = bufferedReader.readLine()) != null) {
                            stringBuilder2.append(string4);
                        }
                        string2 = stringBuilder2.toString();
                        string2 = "\"" + string2 + "\"";
                    }
                    catch (IOException iOException) {
                        Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(JBStartRunnable.class, (String)"ERR_NonProxyHostParsingError"));
                        Logger.getLogger("global").log(Level.WARNING, null, iOException);
                        string2 = null;
                    }
                }
                if (string2 == null) continue;
                stringBuilder.append(" -D").append(string3).append("=").append(string2);
            }
        }
        Object object = stringArray = this.startServer.getMode() != JBStartServer.MODE.PROFILE ? jBProperties.getJavaPlatform() : this.profilerSettings.getJavaPlatform();
        if (this.startServer.getMode() == JBStartServer.MODE.DEBUG && stringBuilder.toString().indexOf("-Xdebug") == -1) {
            if (stringArray.getSpecification().getVersion().compareTo((Object)JDK_14) <= 0) {
                stringBuilder.append(" -classic");
            }
            stringBuilder.append(" -Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,address=").append(this.dm.getDebuggingPort()).append(",server=y,suspend=n");
        } else if (this.startServer.getMode() == JBStartServer.MODE.PROFILE) {
            String[] stringArray2 = this.profilerSettings.getJvmArgs();
            for (n = 0; n < stringArray2.length; ++n) {
                stringBuilder.append(" ").append(stringArray2[n]);
            }
        }
        string = stringBuilder.toString();
        String string5 = JBStartRunnable.getJavaHome((JavaPlatform)stringArray);
        String[] stringArray3 = new String[]{"JAVA=" + string5 + File.separator + "bin" + File.separator + "java", "JAVA_HOME=" + string5, "JBOSS_HOME=" + instanceProperties.getProperty("root-dir"), "JAVA_OPTS=" + string};
        return stringArray3;
    }

    private boolean checkPorts(InstanceProperties instanceProperties) {
        try {
            String string;
            int n;
            String string2 = instanceProperties.getProperty("displayName");
            String string3 = instanceProperties.getProperty("port");
            int n2 = Integer.parseInt(string3);
            if (n2 <= 0) {
                return true;
            }
            if (!JBPluginUtils.isPortFree(n2)) {
                this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED_HTTP_PORT_IN_USE", string3));
                return false;
            }
            String string4 = instanceProperties.getProperty("server-dir");
            String string5 = JBPluginUtils.getJnpPort(string4);
            int n3 = new Integer(string5);
            if (!JBPluginUtils.isPortFree(n3)) {
                this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED_JNP_PORT_IN_USE", string5));
                return false;
            }
            String string6 = JBPluginUtils.getRMINamingServicePort(string4);
            int n4 = new Integer(string6);
            if (!JBPluginUtils.isPortFree(n4)) {
                this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED_RMI_PORT_IN_USE", string6));
                return false;
            }
            String string7 = instanceProperties.getProperty("server");
            if (!"minimal".equals(string7) && !JBPluginUtils.isPortFree(n = new Integer(string = JBPluginUtils.getRMIInvokerPort(string4)).intValue())) {
                this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED_INVOKER_PORT_IN_USE", string));
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return true;
    }

    private NbProcessDescriptor createProcessDescriptor(InstanceProperties instanceProperties, String[] stringArray) {
        String string = this.getRunFileName(instanceProperties, stringArray);
        if (!new File(string).exists()) {
            this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED_FNF"));
            return null;
        }
        String string2 = instanceProperties.getProperty("server");
        String string3 = ("all".equals(string2) ? "-b 127.0.0.1 " : "") + "-c " + string2;
        return new NbProcessDescriptor(string, string3);
    }

    private String getRunFileName(InstanceProperties instanceProperties, String[] stringArray) {
        SpacesInPathFix spacesInPathFix = new SpacesInPathFix(instanceProperties, stringArray);
        return spacesInPathFix.getRunFileName();
    }

    private static String getJavaHome(JavaPlatform javaPlatform) {
        FileObject fileObject = (FileObject)javaPlatform.getInstallFolders().iterator().next();
        return FileUtil.toFile((FileObject)fileObject).getAbsolutePath();
    }

    private String createProgressMessage(String string) {
        return this.createProgressMessage(string, null);
    }

    private String createProgressMessage(String string, String string2) {
        return NbBundle.getMessage(JBStartRunnable.class, (String)string, (Object)this.instanceName, (Object)string2);
    }

    private Process createProcess(InstanceProperties instanceProperties) {
        NbProcessDescriptor nbProcessDescriptor;
        String[] stringArray;
        if (this.startServer.getMode() == JBStartServer.MODE.PROFILE && (stringArray = JBLogWriter.getInstance(this.instanceName)) != null && stringArray.isRunning()) {
            stringArray.stop();
        }
        if ((nbProcessDescriptor = this.createProcessDescriptor(instanceProperties, stringArray = this.createEnvironment(instanceProperties))) == null) {
            return null;
        }
        try {
            return nbProcessDescriptor.exec(null, stringArray, true, null);
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, null, iOException);
            String string = instanceProperties.getProperty("root-dir");
            String string2 = string + (Utilities.isWindows() ? STARTUP_BAT : STARTUP_SH);
            this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED_PD", string2));
            return null;
        }
    }

    private InputOutput openConsole() {
        InputOutput inputOutput = UISupport.getServerIO((String)this.dm.getUrl());
        if (inputOutput == null) {
            return null;
        }
        try {
            inputOutput.getOut().reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        inputOutput.select();
        return inputOutput;
    }

    private void fireStartProgressEvent(StateType stateType, String string) {
        this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.START, stateType, string));
    }

    private JBLogWriter createLogWriter() {
        InputOutput inputOutput = this.openConsole();
        return JBLogWriter.createInstance(inputOutput, this.instanceName);
    }

    private void waitForServerToStart(JBLogWriter jBLogWriter, Process process) {
        this.fireStartProgressEvent(StateType.RUNNING, this.createProgressMessage("MSG_START_SERVER_IN_PROGRESS"));
        JBStartServer.ACTION_STATUS aCTION_STATUS = jBLogWriter.start(process, this.startServer);
        this.dm.setNeedsRestart(false);
        if (aCTION_STATUS == JBStartServer.ACTION_STATUS.SUCCESS) {
            this.fireStartProgressEvent(StateType.COMPLETED, this.createProgressMessage("MSG_SERVER_STARTED"));
        } else if (aCTION_STATUS == JBStartServer.ACTION_STATUS.FAILURE) {
            this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_START_SERVER_FAILED"));
        } else if (aCTION_STATUS == JBStartServer.ACTION_STATUS.UNKNOWN) {
            this.fireStartProgressEvent(StateType.FAILED, this.createProgressMessage("MSG_StartServerTimeout"));
        }
    }

    private class SpacesInPathFix {
        private InstanceProperties myProps;
        private boolean needChange;

        SpacesInPathFix(InstanceProperties instanceProperties, String[] stringArray) {
            this.myProps = instanceProperties;
            this.needChange = this.runFileNeedChange(stringArray);
        }

        String getRunFileName() {
            String string = this.getProperties().getProperty("root-dir");
            String string2 = string + (Utilities.isWindows() ? STARTUP_BAT : STARTUP_SH);
            if (this.needChange) {
                String string3 = this.readFile(string2);
                String string4 = this.readFile(string + CONF_BAT);
                Matcher matcher = IF_JAVA_OPTS_PATTERN.matcher(string3);
                Matcher matcher2 = IF_JAVA_OPTS_PATTERN.matcher(string4);
                boolean bl = matcher.matches();
                boolean bl2 = matcher2.matches();
                try {
                    if (bl || bl2) {
                        File file = File.createTempFile(JBStartRunnable.RUN_FILE_NAME, ".bat");
                        File file2 = File.createTempFile(JBStartRunnable.CONF_FILE_NAME, ".bat", file.getParentFile());
                        file.deleteOnExit();
                        file2.deleteOnExit();
                        boolean bl3 = false;
                        string3 = this.replaceJavaOpts(string3, matcher);
                        string4 = this.replaceJavaOpts(string4, matcher2);
                        string3 = string3.replace(JBStartRunnable.CONF_FILE_NAME, file2.getName());
                        this.writeFile(file, string3);
                        this.writeFile(file2, string4);
                        return file.getAbsolutePath();
                    }
                }
                catch (IOException iOException) {
                    Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(JBStartRunnable.class, (String)"ERR_WriteError"));
                    Logger.getLogger("global").log(Level.WARNING, null, iOException);
                }
            }
            return string2;
        }

        private String replaceJavaOpts(String string, Matcher matcher) {
            String string2 = string;
            int n = 0;
            ArrayList<String> arrayList = new ArrayList<String>(1);
            while (matcher.find(n)) {
                if (matcher.groupCount() <= 1) continue;
                n = matcher.end(2);
                arrayList.add(matcher.group(2));
            }
            for (String string3 : arrayList) {
                string2 = string2.replace(string3, JBStartRunnable.NEW_IF_CONDITION_STRING);
            }
            return string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeFile(File file, String string) {
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(file));
                bufferedWriter.write(string);
            }
            catch (IOException iOException) {
                Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(JBStartRunnable.class, (String)"ERR_WriteError"));
                Logger.getLogger("global").log(Level.WARNING, null, iOException);
            }
            finally {
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger("global").log(Level.WARNING, null, iOException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String readFile(String string) {
            StringBuilder stringBuilder = null;
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(new File(string)));
                stringBuilder = new StringBuilder();
                String string2 = "";
                do {
                    stringBuilder.append(string2);
                    stringBuilder.append("\r\n");
                } while ((string2 = bufferedReader.readLine()) != null);
            }
            catch (IOException iOException) {
                Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(JBStartRunnable.class, (String)"ERR_ReadError"));
                Logger.getLogger("global").log(Level.WARNING, null, iOException);
                String string3 = null;
                return string3;
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger("global").log(Level.WARNING, null, iOException);
                }
            }
            return stringBuilder.toString();
        }

        private InstanceProperties getProperties() {
            return this.myProps;
        }

        private boolean runFileNeedChange(String[] stringArray) {
            JBProperties jBProperties = JBStartRunnable.this.dm.getProperties();
            if (jBProperties.isVersion(JBPluginUtils.JBOSS_5_0_1) && Utilities.isWindows()) {
                for (String string : stringArray) {
                    if (!string.startsWith("JAVA_OPTS=")) continue;
                    return string.indexOf(34) >= 0;
                }
            }
            return false;
        }
    }
}

