/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.serialization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.modules.vmd.api.codegen.CodeSetterPresenter;
import org.netbeans.modules.vmd.api.codegen.Parameter;
import org.netbeans.modules.vmd.api.codegen.Setter;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PresenterDeserializer;
import org.netbeans.modules.vmd.api.model.Versionable;
import org.netbeans.modules.vmd.midp.codegen.MidpParameter;
import org.netbeans.modules.vmd.midp.codegen.MidpSetter;
import org.netbeans.modules.vmd.midp.serialization.XMLUtils;
import org.w3c.dom.Node;

public class MidpSetterPresenterDeserializer
extends PresenterDeserializer {
    public static final String SETTER_NODE = "MidpSetter";
    public static final String NAME_ATTR = "name";
    public static final String PARAMETERS_ATTR = "parameters";

    public MidpSetterPresenterDeserializer() {
        super("vmd-midp");
    }

    public PresenterDeserializer.PresenterFactory deserialize(Node node) {
        if (!SETTER_NODE.equalsIgnoreCase(node.getNodeName())) {
            return null;
        }
        String name = XMLUtils.getAttributeValue(node, NAME_ATTR);
        String parametersString = XMLUtils.getAttributeValue(node, PARAMETERS_ATTR);
        StringTokenizer tokenizer = new StringTokenizer(parametersString, ",");
        ArrayList<String> parameters = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            parameters.add(tokenizer.nextToken());
        }
        return new MidpPropertyPresenterFactory(name, parameters.toArray(new String[parameters.size()]));
    }

    private static class MidpPropertyPresenterFactory
    extends PresenterDeserializer.PresenterFactory {
        private String name;
        private String[] parameters;

        public MidpPropertyPresenterFactory(String name, String[] parameters) {
            this.name = name;
            this.parameters = parameters;
        }

        public List<Presenter> createPresenters(ComponentDescriptor descriptor) {
            MidpSetter setter = this.name != null ? MidpSetter.createSetter(this.name, Versionable.FOREVER) : MidpSetter.createConstructor(descriptor.getTypeDescriptor().getThisType(), Versionable.FOREVER);
            setter.addParameters(this.parameters);
            return Arrays.asList(new CodeSetterPresenter().addParameters((Parameter[])MidpParameter.create(this.parameters)).addSetters(new Setter[]{setter}));
        }
    }
}

