/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.e2e.mapping;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.mobility.e2e.classdata.ClassData;
import org.netbeans.modules.mobility.javon.JavonMapping;
import org.netbeans.modules.mobility.javon.JavonSerializer;
import org.netbeans.modules.mobility.javon.Traversable;

public class GenericTypeSerializer
implements JavonSerializer {
    @Override
    public String getName() {
        return "Generic type serializer";
    }

    @Override
    public boolean isTypeSupported(Traversable traversable, TypeMirror typeMirror, Map<String, ClassData> map) {
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
            String string = typeElement.getQualifiedName().toString();
            if ("java.util.List".equals(string) || "java.util.Vector".equals(string) || "java.util.Stack".equals(string)) {
                List<? extends TypeMirror> list = ((DeclaredType)typeMirror).getTypeArguments();
                if (list.size() == 0) {
                    return false;
                }
                if (list.size() != 1) {
                    return false;
                }
                for (TypeMirror typeMirror2 : list) {
                    TypeElement typeElement2 = (TypeElement)((DeclaredType)typeMirror2).asElement();
                    if (typeElement2.getQualifiedName().toString().startsWith("java.util")) {
                        return false;
                    }
                    if (traversable.isTypeSupported(typeMirror2, map)) continue;
                    return false;
                }
                return true;
            }
            if ("java.util.Hashtable".equals(string)) {
                List<? extends TypeMirror> list = ((DeclaredType)typeMirror).getTypeArguments();
                if (list.size() == 0) {
                    return false;
                }
                if (list.size() != 2) {
                    return false;
                }
                for (TypeMirror typeMirror3 : list) {
                    TypeElement typeElement3 = (TypeElement)((DeclaredType)typeMirror3).asElement();
                    if (typeElement3.getQualifiedName().toString().startsWith("java.util")) {
                        return false;
                    }
                    if (traversable.isTypeSupported(typeMirror3, map)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public ClassData getType(Traversable traversable, TypeMirror typeMirror, Map<String, ClassData> map) {
        if (this.isTypeSupported(traversable, typeMirror, map)) {
            TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
            String string = typeElement.getQualifiedName().toString();
            if ("java.util.List".equals(string)) {
                ClassData classData = new ClassData("java.util", "List", false, false, (JavonSerializer)this);
                List<? extends TypeMirror> list = ((DeclaredType)typeMirror).getTypeArguments();
                ArrayList<ClassData> arrayList = new ArrayList<ClassData>();
                for (TypeMirror object : list) {
                    ClassData classData2 = traversable.traverseType(object, map);
                    if (classData2 == null) {
                        return null;
                    }
                    arrayList.add(classData2);
                }
                classData.setParameterTypes(arrayList);
                for (ClassData object : arrayList) {
                    traversable.registerType(object);
                }
                return classData;
            }
            if ("java.util.Vector".equals(string)) {
                ClassData classData = new ClassData("java.util", "Vector", false, false, (JavonSerializer)this);
                List<? extends TypeMirror> list = ((DeclaredType)typeMirror).getTypeArguments();
                ArrayList<ClassData> arrayList = new ArrayList<ClassData>();
                for (TypeMirror object : list) {
                    ClassData classData3 = traversable.traverseType(object, map);
                    if (classData3 == null) {
                        return null;
                    }
                    arrayList.add(classData3);
                }
                classData.setParameterTypes(arrayList);
                for (ClassData classData4 : arrayList) {
                    traversable.registerType(classData4);
                }
                return classData;
            }
            if ("java.util.Stack".equals(string)) {
                ClassData classData = new ClassData("java.util", "Stack", false, false, (JavonSerializer)this);
                List<? extends TypeMirror> list = ((DeclaredType)typeMirror).getTypeArguments();
                ArrayList<ClassData> arrayList = new ArrayList<ClassData>();
                for (TypeMirror typeMirror2 : list) {
                    ClassData classData5 = traversable.traverseType(typeMirror2, map);
                    if (classData5 == null) {
                        return null;
                    }
                    arrayList.add(classData5);
                }
                classData.setParameterTypes(arrayList);
                for (ClassData classData6 : arrayList) {
                    traversable.registerType(classData6);
                }
                return classData;
            }
            if ("java.util.Hashtable".equals(string)) {
                ClassData classData = new ClassData("java.util", "Hashtable", false, false, (JavonSerializer)this);
                List<? extends TypeMirror> list = ((DeclaredType)typeMirror).getTypeArguments();
                ArrayList<ClassData> arrayList = new ArrayList<ClassData>();
                for (TypeMirror typeMirror3 : list) {
                    ClassData classData7 = traversable.traverseType(typeMirror3, map);
                    if (classData7 == null) {
                        return null;
                    }
                    arrayList.add(classData7);
                }
                classData.setParameterTypes(arrayList);
                for (ClassData classData8 : arrayList) {
                    traversable.registerType(classData8);
                }
                return classData;
            }
        }
        return null;
    }

    @Override
    public String instanceOf(JavonMapping javonMapping, ClassData classData) {
        ClassData classData2 = classData.getParameterTypes().get(0);
        String string = classData.getFullyQualifiedName();
        if ("java.util.List".equals(string)) {
            if ("client".equals(javonMapping.getProperty("target"))) {
                return classData2.getSerializer().instanceOf(javonMapping, classData2) + "[]";
            }
            return classData.getName() + "<" + classData2.getSerializer().instanceOf(javonMapping, classData2) + ">";
        }
        if ("java.util.Vector".equals(string)) {
            if ("client".equals(javonMapping.getProperty("target"))) {
                return classData.getName();
            }
            return classData.getName() + "<" + classData2.getSerializer().instanceOf(javonMapping, classData2) + ">";
        }
        if ("java.util.Stack".equals(string)) {
            if ("client".equals(javonMapping.getProperty("target"))) {
                return classData.getName();
            }
            return classData.getName() + "<" + classData2.getSerializer().instanceOf(javonMapping, classData2) + ">";
        }
        if ("java.util.Hashtable".equals(string)) {
            if ("client".equals(javonMapping.getProperty("target"))) {
                return classData.getName();
            }
            return classData.getName() + "<" + classData2.getSerializer().instanceOf(javonMapping, classData2) + "," + classData.getParameterTypes().get(1).getSerializer().instanceOf(javonMapping, classData.getParameterTypes().get(1)) + ">";
        }
        throw new IllegalArgumentException("Invalid type: " + string);
    }

    @Override
    public String toObject(JavonMapping javonMapping, ClassData classData, String string) {
        return string;
    }

    @Override
    public String fromObject(JavonMapping javonMapping, ClassData classData, String string) {
        return "(" + classData.getSerializer().instanceOf(javonMapping, classData) + ")" + string;
    }

    @Override
    public String toStream(JavonMapping javonMapping, ClassData classData, String string, String string2) {
        ClassData classData2 = classData.getParameterTypes().get(0);
        int n = javonMapping.getRegistry().getRegisteredTypeId(classData);
        String string3 = classData.getSerializer().instanceOf(javonMapping, classData);
        String string4 = classData.getFullyQualifiedName();
        if ("java.util.List".equals(string4)) {
            if ("client".equals(javonMapping.getProperty("target"))) {
                String string5 = "";
                string5 = string5 + string3 + " g_" + n + " = (" + string3 + ") o;\n";
                string5 = string5 + "out.writeInt( g_" + n + ".length );\n";
                string5 = string5 + "for( int i = 0; i < g_" + n + ".length; i++ ) {\n";
                string5 = string5 + "writeObject( out, g_" + n + "[i], " + javonMapping.getRegistry().getRegisteredTypeId(classData2) + " );\n";
                string5 = string5 + "}";
                return string5;
            }
            String string6 = "";
            string6 = string6 + "@SuppressWarnings( \"unchecked\" )\n";
            string6 = string6 + string3 + " g_" + n + " = (" + string3 + ") o;\n";
            string6 = string6 + "output.writeInt( g_" + n + ".size());\n";
            string6 = string6 + "for( " + classData2.getSerializer().instanceOf(javonMapping, classData2) + " g : g_" + n + " ) {\n";
            string6 = string6 + "writeObject( output, g, " + javonMapping.getRegistry().getRegisteredTypeId(classData2) + " );\n";
            string6 = string6 + "}";
            return string6;
        }
        if ("java.util.Vector".equals(string4)) {
            if ("client".equals(javonMapping.getProperty("target"))) {
                String string7 = "";
                string7 = string7 + "java.util.Vector g_" + n + " = (java.util.Vector) o;\n";
                string7 = string7 + "out.writeInt( g_" + n + ".size());\n";
                string7 = string7 + "for( int i = 0; i < g_" + n + ".size(); i++ ) {\n";
                string7 = string7 + "writeObject( out, g_" + n + ".elementAt( i ), " + javonMapping.getRegistry().getRegisteredTypeId(classData2) + " );\n";
                string7 = string7 + "}";
                return string7;
            }
            String string8 = "";
            string8 = string8 + "@SuppressWarnings( \"unchecked\" )\n";
            string8 = string8 + string3 + " g_" + n + " = (" + string3 + ") o;\n";
            string8 = string8 + "output.writeInt( g_" + n + ".size());\n";
            string8 = string8 + "for( " + classData2.getSerializer().instanceOf(javonMapping, classData2) + " g : g_" + n + " ) {\n";
            string8 = string8 + "writeObject( output, g, " + javonMapping.getRegistry().getRegisteredTypeId(classData2) + " );\n";
            string8 = string8 + "}";
            return string8;
        }
        if ("java.util.Stack".equals(string4)) {
            if ("client".equals(javonMapping.getProperty("target"))) {
                String string9 = "";
                string9 = string9 + "java.util.Stack g_" + n + " = (java.util.Stack) o;\n";
                string9 = string9 + "out.writeInt( g_" + n + ".size());\n";
                string9 = string9 + "for( int i = 0; i < g_" + n + ".size(); i++ ) {\n";
                string9 = string9 + "writeObject( out, g_" + n + ".elementAt( i ), " + javonMapping.getRegistry().getRegisteredTypeId(classData2) + " );\n";
                string9 = string9 + "}";
                return string9;
            }
            String string10 = "";
            string10 = string10 + "@SuppressWarnings( \"unchecked\" )\n";
            string10 = string10 + string3 + " g_" + n + " = (" + string3 + ") o;\n";
            string10 = string10 + "output.writeInt( g_" + n + ".size());\n";
            string10 = string10 + "for( " + classData2.getSerializer().instanceOf(javonMapping, classData2) + " g : g_" + n + " ) {\n";
            string10 = string10 + "writeObject( output, g, " + javonMapping.getRegistry().getRegisteredTypeId(classData2) + " );\n";
            string10 = string10 + "}";
            return string10;
        }
        if ("java.util.Hashtable".equals(string4)) {
            if ("client".equals(javonMapping.getProperty("target"))) {
                String string11 = classData2.getSerializer().instanceOf(javonMapping, classData2);
                String string12 = "";
                string12 = string12 + "java.util.Hashtable g_" + n + " = (java.util.Hashtable) o;\n";
                string12 = string12 + "out.writeInt( g_" + n + ".size());\n";
                string12 = string12 + "for( Enumeration en = g_" + n + ".keys(); en.hasMoreElements(); ) {\n";
                string12 = string12 + string11 + " key = (" + string11 + ") en.nextElement();\n";
                string12 = string12 + "writeObject( out, key, " + javonMapping.getRegistry().getRegisteredTypeId(classData2) + " );\n";
                string12 = string12 + "writeObject( out, g_" + n + ".get( key ), " + javonMapping.getRegistry().getRegisteredTypeId(classData.getParameterTypes().get(1)) + " );\n";
                string12 = string12 + "}";
                return string12;
            }
            String string13 = "";
            string13 = string13 + "@SuppressWarnings( \"unchecked\" )\n";
            string13 = string13 + string3 + " g_" + n + " = (" + string3 + ") o;\n";
            string13 = string13 + "output.writeInt( g_" + n + ".size());\n";
            string13 = string13 + "for( " + classData2.getSerializer().instanceOf(javonMapping, classData2) + " key : g_" + n + ".keySet()) {\n";
            string13 = string13 + "writeObject( output, key, " + javonMapping.getRegistry().getRegisteredTypeId(classData2) + " );\n";
            string13 = string13 + "writeObject( output, g_" + n + ".get( key ), " + javonMapping.getRegistry().getRegisteredTypeId(classData.getParameterTypes().get(1)) + " );\n";
            string13 = string13 + "}";
            return string13;
        }
        return "";
    }

    @Override
    public String fromStream(JavonMapping javonMapping, ClassData classData, String string, String string2) {
        ClassData classData2 = classData.getParameterTypes().get(0);
        int n = javonMapping.getRegistry().getRegisteredTypeId(classData);
        String string3 = classData.getSerializer().instanceOf(javonMapping, classData);
        String string4 = classData.getFullyQualifiedName();
        if ("java.util.List".equals(string4)) {
            if ("client".equals(javonMapping.getProperty("target"))) {
                String string5 = "";
                string5 = string5 + "int g_" + n + "_length = in.readInt();\n";
                string5 = string5 + string3 + " g_" + n + "_result = new " + classData2.getSerializer().instanceOf(javonMapping, classData2) + "[g_" + n + "_length];\n";
                string5 = string5 + "for( int i = 0; i < g_" + n + "_length; i++ ) {\n";
                string5 = string5 + "g_" + n + "_result[i] = (" + classData2.getSerializer().instanceOf(javonMapping, classData2) + ") readObject( in );\n";
                string5 = string5 + "}\n";
                string5 = string5 + "result = g_" + n + "_result;";
                return string5;
            }
            String string6 = "";
            string6 = string6 + "int g_" + n + "_length = in.readInt();\n";
            string6 = string6 + string3 + " g_" + n + "_result = new ArrayList<" + classData2.getSerializer().instanceOf(javonMapping, classData2) + ">();\n";
            string6 = string6 + "for( int i = 0; i < g_" + n + "_length; i++ ) {\n";
            string6 = string6 + "g_" + n + "_result.add((" + classData2.getSerializer().instanceOf(javonMapping, classData2) + ") readObject( in ));\n";
            string6 = string6 + "}\n";
            string6 = string6 + "result = g_" + n + "_result;";
            return string6;
        }
        if ("java.util.Vector".equals(string4)) {
            if ("client".equals(javonMapping.getProperty("target"))) {
                String string7 = "";
                string7 = string7 + "int g_" + n + "_length = in.readInt();\n";
                string7 = string7 + string3 + " g_" + n + "_result = new " + string3 + "();\n";
                string7 = string7 + "for( int i = 0; i < g_" + n + "_length; i++ ) {\n";
                string7 = string7 + "g_" + n + "_result.addElement((" + classData2.getSerializer().instanceOf(javonMapping, classData2) + ") readObject( in ));\n";
                string7 = string7 + "}\n";
                string7 = string7 + "result = g_" + n + "_result;";
                return string7;
            }
            String string8 = "";
            string8 = string8 + "int g_" + n + "_length = in.readInt();\n";
            string8 = string8 + string3 + " g_" + n + "_result = new " + string3 + "();\n";
            string8 = string8 + "for( int i = 0; i < g_" + n + "_length; i++ ) {\n";
            string8 = string8 + "g_" + n + "_result.addElement((" + classData2.getSerializer().instanceOf(javonMapping, classData2) + ") readObject( in ));\n";
            string8 = string8 + "}\n";
            string8 = string8 + "result = g_" + n + "_result;";
            return string8;
        }
        if ("java.util.Stack".equals(string4)) {
            if ("client".equals(javonMapping.getProperty("target"))) {
                String string9 = "";
                string9 = string9 + "int g_" + n + "_length = in.readInt();\n";
                string9 = string9 + string3 + " g_" + n + "_result = new " + string3 + "();\n";
                string9 = string9 + "for( int i = 0; i < g_" + n + "_length; i++ ) {\n";
                string9 = string9 + "g_" + n + "_result.addElement((" + classData2.getSerializer().instanceOf(javonMapping, classData2) + ") readObject( in ));\n";
                string9 = string9 + "}\n";
                string9 = string9 + "result = g_" + n + "_result;";
                return string9;
            }
            String string10 = "";
            string10 = string10 + "int g_" + n + "_length = in.readInt();\n";
            string10 = string10 + string3 + " g_" + n + "_result = new " + string3 + "();\n";
            string10 = string10 + "for( int i = 0; i < g_" + n + "_length; i++ ) {\n";
            string10 = string10 + "g_" + n + "_result.addElement((" + classData2.getSerializer().instanceOf(javonMapping, classData2) + ") readObject( in ));\n";
            string10 = string10 + "}\n";
            string10 = string10 + "result = g_" + n + "_result;";
            return string10;
        }
        if ("java.util.Hashtable".equals(string4)) {
            if ("client".equals(javonMapping.getProperty("target"))) {
                String string11 = "";
                string11 = string11 + "int g_" + n + "_length = in.readInt();\n";
                string11 = string11 + string3 + " g_" + n + "_result = new " + string3 + "();\n";
                string11 = string11 + "for( int i = 0; i < g_" + n + "_length; i++ ) {\n";
                string11 = string11 + "g_" + n + "_result.put((" + classData2.getSerializer().instanceOf(javonMapping, classData2) + ") readObject( in ), (" + classData.getParameterTypes().get(1).getSerializer().instanceOf(javonMapping, classData.getParameterTypes().get(1)) + ") readObject( in ));\n";
                string11 = string11 + "}\n";
                string11 = string11 + "result = g_" + n + "_result;";
                return string11;
            }
            String string12 = "";
            string12 = string12 + "int g_" + n + "_length = in.readInt();\n";
            string12 = string12 + string3 + " g_" + n + "_result = new " + string3 + "();\n";
            string12 = string12 + "for( int i = 0; i < g_" + n + "_length; i++ ) {\n";
            string12 = string12 + "g_" + n + "_result.put((" + classData2.getSerializer().instanceOf(javonMapping, classData2) + ") readObject( in ), (" + classData.getParameterTypes().get(1).getSerializer().instanceOf(javonMapping, classData.getParameterTypes().get(1)) + ") readObject( in ));\n";
            string12 = string12 + "}\n";
            string12 = string12 + "result = g_" + n + "_result;";
            return string12;
        }
        throw new IllegalArgumentException("Invalid type: " + string3);
    }

    @Override
    public Set<ClassData> getReferencedTypes(ClassData classData, Set<ClassData> set) {
        HashSet<ClassData> hashSet = new HashSet<ClassData>();
        hashSet.add(classData);
        set.add(classData);
        for (ClassData classData2 : classData.getParameterTypes()) {
            hashSet.addAll(classData2.getSerializer().getReferencedTypes(classData2, set));
            set.add(classData2);
        }
        return hashSet;
    }
}

