/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import org.netbeans.modules.search.CleanTask;
import org.netbeans.modules.search.IssuesPanel;
import org.netbeans.modules.search.Manager;
import org.netbeans.modules.search.ReplaceTask;
import org.netbeans.modules.search.ResultViewPanel;
import org.netbeans.modules.search.SearchTask;
import org.openide.awt.MouseUtils;
import org.openide.awt.TabbedPaneFactory;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class ResultView
extends TopComponent {
    private static final boolean isMacLaf = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private static final Color macBackground = UIManager.getColor("NbExplorerView.background");
    private static final String ID = "search-results";
    private static Reference<ResultView> instance = null;
    private JPopupMenu pop;
    private PopupListener popL;
    private CloseListener closeL;
    private JPanel emptyPanel;
    private final CardLayout contentCards;
    private Map<SearchTask, ResultViewPanel> searchToViewMap = new HashMap<SearchTask, ResultViewPanel>();
    private Map<ResultViewPanel, SearchTask> viewToSearchMap = new HashMap<ResultViewPanel, SearchTask>();
    private Map<ReplaceTask, SearchTask> replaceToSearchMap = new HashMap<ReplaceTask, SearchTask>();
    private Map<SearchTask, ReplaceTask> searchToReplaceMap = new HashMap<SearchTask, ReplaceTask>();

    static synchronized ResultView getInstance() {
        ResultView view = (ResultView)WindowManager.getDefault().findTopComponent(ID);
        if (view == null) {
            view = ResultView.getDefault();
        }
        return view;
    }

    public static synchronized ResultView getDefault() {
        ResultView view;
        if (instance == null) {
            view = new ResultView();
            instance = new WeakReference<ResultView>(view);
        } else {
            view = instance.get();
            if (view == null) {
                view = new ResultView();
                instance = new WeakReference<ResultView>(view);
            }
        }
        return view;
    }

    private ResultView() {
        this.contentCards = new CardLayout();
        this.setLayout(this.contentCards);
        this.setName("Search Results");
        this.setDisplayName(NbBundle.getMessage(ResultView.class, (String)"TITLE_SEARCH_RESULTS"));
        this.setToolTipText(NbBundle.getMessage(ResultView.class, (String)"TOOLTIP_SEARCH_RESULTS"));
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/search/res/find.gif"));
        this.initAccessibility();
        this.pop = new JPopupMenu();
        this.pop.add(new Close());
        this.pop.add(new CloseAll());
        this.pop.add(new CloseAllButCurrent());
        this.popL = new PopupListener();
        this.closeL = new CloseListener();
        this.initActions();
        this.emptyPanel = new JPanel();
        this.add(this.emptyPanel, "Center");
        if (isMacLaf) {
            this.emptyPanel.setBackground(macBackground);
            this.setBackground(macBackground);
            this.setOpaque(true);
        }
    }

    private void initActions() {
        ActionMap map = this.getActionMap();
        map.put("jumpNext", new PrevNextAction(false));
        map.put("jumpPrev", new PrevNextAction(true));
    }

    public int getPersistenceType() {
        return 0;
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    private Object readResolve() throws ObjectStreamException {
        return ResultView.getDefault();
    }

    private void initAccessibility() {
        ResourceBundle bundle = NbBundle.getBundle(ResultView.class);
        this.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_ResultViewTopComponent"));
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ResultViewTopComponent"));
    }

    public void fillOutput() {
        this.getCurrentResultViewPanel().fillOutput();
    }

    void closeResults() {
        this.close();
    }

    void displayIssuesToUser(ReplaceTask task, String title, String[] problems, boolean reqAtt) {
        assert (EventQueue.isDispatchThread());
        IssuesPanel issuesPanel = new IssuesPanel(title, problems);
        if (isMacLaf) {
            issuesPanel.setBackground(macBackground);
        }
        this.searchToViewMap.get(this.replaceToSearchMap.get(task)).displayIssues(issuesPanel);
        if (!this.isOpened()) {
            this.open();
        }
        if (reqAtt) {
            this.requestAttention(true);
        }
    }

    protected void componentOpened() {
        assert (EventQueue.isDispatchThread());
        Manager.getInstance().searchWindowOpened();
        ResultViewPanel panel = this.getCurrentResultViewPanel();
        if (panel != null) {
            panel.componentOpened();
        }
    }

    public void requestFocus() {
        ResultViewPanel panel = this.getCurrentResultViewPanel();
        if (panel != null) {
            panel.tree.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        ResultViewPanel panel = this.getCurrentResultViewPanel();
        if (panel != null) {
            return panel.tree.requestFocusInWindow();
        }
        return false;
    }

    private ResultViewPanel getCurrentResultViewPanel() {
        Component comp;
        if (this.getComponentCount() > 0 && ((comp = this.getComponent(0)) instanceof JTabbedPane ? (comp = ((JTabbedPane)comp).getSelectedComponent()) instanceof ResultViewPanel : comp instanceof ResultViewPanel)) {
            return (ResultViewPanel)comp;
        }
        return null;
    }

    private void addTabPanel(JPanel panel) {
        Component comp = this.getComponent(0);
        if (comp instanceof JTabbedPane) {
            ((JTabbedPane)comp).addTab(this.getTabTitle(panel), null, panel, panel.getToolTipText());
            ((JTabbedPane)comp).setSelectedComponent(panel);
            comp.validate();
        } else {
            this.remove(comp);
            JTabbedPane pane = TabbedPaneFactory.createCloseButtonTabbedPane();
            pane.setMinimumSize(new Dimension(0, 0));
            pane.addMouseListener((MouseListener)((Object)this.popL));
            pane.addPropertyChangeListener(this.closeL);
            if (isMacLaf) {
                pane.setBackground(macBackground);
                pane.setOpaque(true);
            }
            this.add(pane, "Center");
            if (comp instanceof ResultViewPanel) {
                pane.addTab(this.getTabTitle(comp), null, comp, ((JPanel)comp).getToolTipText());
            }
            pane.addTab(this.getTabTitle(panel), null, panel, panel.getToolTipText());
            pane.setSelectedComponent(panel);
            pane.validate();
        }
        this.validate();
        this.requestActive();
    }

    private String getTabTitle(Component panel) {
        return NbBundle.getMessage(ResultView.class, (String)"TEXT_MSG_RESULTS_FOR_X", (Object)String.valueOf(panel.getName()));
    }

    private void updateTabTitle(JPanel panel) {
        Component comp;
        if (this.getComponentCount() != 0 && (comp = this.getComponent(0)) instanceof JTabbedPane) {
            JTabbedPane pane = (JTabbedPane)comp;
            int index = pane.indexOfComponent(panel);
            pane.setTitleAt(index, this.getTabTitle(panel));
            pane.setToolTipTextAt(index, panel.getToolTipText());
        }
    }

    private void removePanel(JPanel panel) {
        Component comp;
        Component component = comp = this.getComponentCount() > 0 ? this.getComponent(0) : null;
        if (comp instanceof JTabbedPane) {
            ResultViewPanel rvp;
            JTabbedPane tabs = (JTabbedPane)comp;
            if (panel == null) {
                panel = (JPanel)tabs.getSelectedComponent();
            }
            if ((rvp = (ResultViewPanel)panel).isSearchInProgress()) {
                Manager.getInstance().stopSearching(this.viewToSearchMap.get(panel));
            }
            tabs.remove(panel);
            if (tabs.getComponentCount() == 1) {
                Component c = tabs.getComponent(0);
                tabs.removeMouseListener((MouseListener)((Object)this.popL));
                tabs.removePropertyChangeListener(this.closeL);
                this.remove(tabs);
                this.add(c, "Center");
                this.setName(((JPanel)c).getToolTipText());
            }
        } else if (comp instanceof ResultViewPanel) {
            ResultViewPanel rvp = (ResultViewPanel)comp;
            if (rvp.isSearchInProgress()) {
                Manager.getInstance().stopSearching(this.viewToSearchMap.get(comp));
            }
            this.remove(comp);
            this.add(this.emptyPanel, "Center");
            this.close();
        } else {
            this.close();
        }
        Manager.getInstance().scheduleCleanTask(new CleanTask(this.viewToSearchMap.get(panel).getResultModel()));
        SearchTask sTask = this.viewToSearchMap.remove(panel);
        this.searchToViewMap.remove(sTask);
        ReplaceTask rTask = this.searchToReplaceMap.remove(sTask);
        this.replaceToSearchMap.remove(rTask);
        this.validate();
    }

    protected void componentClosed() {
        assert (EventQueue.isDispatchThread());
        Manager.getInstance().searchWindowClosed();
        this.closeAll(false);
    }

    void notifySearchPending(SearchTask task, int blockingTask) {
        assert (EventQueue.isDispatchThread());
        ResultViewPanel panel = task.getResultModel().getResultView();
        panel.removeIssuesPanel();
        String msgKey = null;
        switch (blockingTask) {
            case 8: {
                msgKey = "TEXT_FINISHING_REPLACE";
                break;
            }
            case 1: {
                msgKey = "TEXT_FINISHING_PREV_SEARCH";
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        panel.setRootDisplayName(NbBundle.getMessage(ResultView.class, (String)msgKey));
        panel.setBtnStopEnabled(true);
        panel.setBtnReplaceEnabled(false);
    }

    void searchTaskStateChanged(SearchTask task, int changeType) {
        assert (EventQueue.isDispatchThread());
        ResultViewPanel panel = task.getResultModel().getResultView();
        switch (changeType) {
            case 1: {
                panel.removeIssuesPanel();
                this.updateTabTitle(panel);
                panel.searchStarted();
                break;
            }
            case 2: {
                panel.searchFinished();
                break;
            }
            case 3: {
                panel.searchInterrupted();
                break;
            }
            case 4: {
                panel.searchCancelled();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    void showAllDetailsFinished() {
        assert (EventQueue.isDispatchThread());
    }

    void addSearchPair(ResultViewPanel panel, SearchTask task) {
        if (task != null && panel != null) {
            SearchTask oldTask = this.viewToSearchMap.get(panel);
            if (oldTask != null) {
                this.searchToViewMap.remove(oldTask);
            }
            this.searchToViewMap.put(task, panel);
            this.viewToSearchMap.put(panel, task);
        }
    }

    void addReplacePair(ReplaceTask taskReplace, ResultViewPanel panel) {
        if (taskReplace != null && panel != null) {
            SearchTask taskSearch = this.viewToSearchMap.get(panel);
            this.replaceToSearchMap.put(taskReplace, taskSearch);
            this.searchToReplaceMap.put(taskSearch, taskReplace);
        }
    }

    synchronized ResultViewPanel initiateResultView(SearchTask task) {
        assert (EventQueue.isDispatchThread());
        ResultViewPanel panel = this.searchToViewMap.get(task);
        if (panel == null) {
            panel = new ResultViewPanel(task);
            if (isMacLaf) {
                panel.setBackground(macBackground);
            }
            this.addSearchPair(panel, task);
            panel.setName(task.getSearchCriteria().getTextPatternExpr());
            this.addTabPanel(panel);
        } else {
            panel.setName(task.getSearchCriteria().getTextPatternExpr());
        }
        return panel;
    }

    void closeAndSendFocusToEditor(ReplaceTask task) {
        TopComponent tc;
        assert (EventQueue.isDispatchThread());
        this.removePanel(this.searchToViewMap.get(this.replaceToSearchMap.get(task)));
        Mode m = WindowManager.getDefault().findMode("editor");
        if (m != null && (tc = m.getSelectedTopComponent()) != null) {
            tc.requestActive();
        }
    }

    void rescan(ReplaceTask task) {
        ResultViewPanel panel;
        assert (EventQueue.isDispatchThread());
        SearchTask lastSearchTask = this.replaceToSearchMap.get(task);
        SearchTask newSearchTask = lastSearchTask.createNewGeneration();
        if (lastSearchTask.getResultModel() != null && (panel = lastSearchTask.getResultModel().getResultView()) != null) {
            ResultView.getInstance().addSearchPair(lastSearchTask.getResultModel().getResultView(), newSearchTask);
            panel.removeIssuesPanel();
        }
        Manager.getInstance().scheduleSearchTask(newSearchTask);
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private void closeAll(boolean butCurrent) {
        Component comp = this.getComponent(0);
        if (comp instanceof JTabbedPane) {
            JTabbedPane tabs = (JTabbedPane)comp;
            Component current = tabs.getSelectedComponent();
            Component[] c = tabs.getComponents();
            for (int i = 0; i < c.length; ++i) {
                if (butCurrent && c[i] == current || !(c[i] instanceof ResultViewPanel)) continue;
                this.removePanel((ResultViewPanel)c[i]);
            }
        }
    }

    private final class PrevNextAction
    extends AbstractAction {
        private boolean prev;

        public PrevNextAction(boolean prev) {
            this.prev = prev;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ResultViewPanel panel = ResultView.this.getCurrentResultViewPanel();
            if (panel != null) {
                panel.goToNext(!this.prev);
            }
        }
    }

    private class CloseAllButCurrent
    extends AbstractAction {
        public CloseAllButCurrent() {
            super(NbBundle.getMessage(ResultView.class, (String)"LBL_CloseAllButCurrent"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ResultView.this.closeAll(true);
        }
    }

    private final class CloseAll
    extends AbstractAction {
        public CloseAll() {
            super(NbBundle.getMessage(ResultView.class, (String)"LBL_CloseAll"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ResultView.this.closeAll(false);
        }
    }

    private class Close
    extends AbstractAction {
        public Close() {
            super(NbBundle.getMessage(ResultView.class, (String)"LBL_CloseWindow"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ResultView.this.removePanel(null);
        }
    }

    private class PopupListener
    extends MouseUtils.PopupMouseAdapter {
        private PopupListener() {
        }

        protected void showPopup(MouseEvent e) {
            ResultView.this.pop.show((Component)((Object)ResultView.this), e.getX(), e.getY());
        }
    }

    private class CloseListener
    implements PropertyChangeListener {
        private CloseListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("close".equals(evt.getPropertyName())) {
                ResultView.this.removePanel((JPanel)evt.getNewValue());
            }
        }
    }

    public static final class ResolvableHelper
    implements Serializable {
        static final long serialVersionUID = 7398708142639457544L;

        public Object readResolve() {
            return ResultView.getDefault();
        }
    }
}

