/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.javascript.editing.FunctionElement;
import org.netbeans.modules.javascript.editing.IndexedElement;
import org.netbeans.modules.javascript.editing.JsIndex;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;

public class IndexedFunction
extends IndexedElement
implements FunctionElement {
    private String[] args;
    private List<String> parameters;

    IndexedFunction(String fqn, String name, String in, JsIndex index, IndexResult indexResult, String attributes, int flags, ElementKind kind) {
        super(fqn, name, in, index, indexResult, attributes, flags, kind);
    }

    public String toString() {
        return this.getSignature() + ":" + this.getFilenameUrl() + ";" + IndexedFunction.decodeFlags(this.flags);
    }

    @Override
    public String getSignature() {
        if (this.signature == null) {
            StringBuilder sb = new StringBuilder();
            if (this.in != null) {
                sb.append(this.in);
                sb.append('.');
            }
            sb.append(this.name);
            sb.append("(");
            List<String> parameterList = this.getParameters();
            if (parameterList.size() > 0) {
                int n = parameterList.size();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(parameterList.get(i));
                }
            }
            sb.append(")");
            this.signature = sb.toString();
        }
        return this.signature;
    }

    public String[] getArgs() {
        if (this.args == null) {
            int argIndex = this.getAttributeSection(4);
            int endIndex = this.attributes.indexOf(59, argIndex);
            if (endIndex > argIndex) {
                String argsPortion = this.attributes.substring(argIndex, endIndex);
                this.args = argsPortion.split(",");
            } else {
                this.args = new String[0];
            }
        }
        return this.args;
    }

    @Override
    public List<String> getParameters() {
        if (this.parameters == null) {
            String[] a = this.getArgs();
            if (a != null && a.length > 0) {
                this.parameters = new ArrayList<String>(a.length);
                for (String arg : a) {
                    this.parameters.add(arg);
                }
            } else {
                this.parameters = Collections.emptyList();
            }
        }
        return this.parameters;
    }
}

