/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.ui.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.dlight.core.ui.components.ContentValidator;
import org.netbeans.modules.dlight.core.ui.components.DLightTargetSelectionDialogLayout;
import org.netbeans.modules.dlight.core.ui.components.JComboBox2;
import org.netbeans.modules.dlight.core.ui.components.JFileChooser2;
import org.netbeans.modules.dlight.core.ui.components.Validatable;
import org.openide.util.NbBundle;

public abstract class DLightTargetSelectionDialog
extends JDialog
implements ActionListener {
    public static final int RESULT_OK = 0;
    public static final int RESULT_CANCEL = 1;
    public static final int RESULT_ERROR = -1;
    private int result = -1;
    protected JButton btnOK = new JButton(NbBundle.getMessage(DLightTargetSelectionDialog.class, (String)"DLightTargetSelectionDialog.OK_Button"));
    protected JButton btnCancel = new JButton(NbBundle.getMessage(DLightTargetSelectionDialog.class, (String)"DLightTargetSelectionDialog.Cancel_Button"));
    protected JPanel buttonPanel = new JPanel();
    protected ArrayList<Validatable> toValidate = new ArrayList();

    public abstract String getProgramName();

    public abstract String getProgramArguments();

    public abstract String getWorkingDirectory();

    public DLightTargetSelectionDialog(String title) {
        this.setModal(true);
        this.setDefaultCloseOperation(1);
        this.setTitle(title);
    }

    public void show(Frame frame) {
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    final void init() {
        this.initComponents();
        this.initCancelOKButtons();
        this.getRootPane().setDefaultButton(this.btnOK);
        this.pack();
    }

    void initCancelOKButtons() {
        int btnHSize = (int)this.btnOK.getPreferredSize().getHeight();
        this.btnOK.addActionListener(this);
        this.btnOK.setPreferredSize(new Dimension(80, btnHSize));
        this.btnCancel.addActionListener(this);
        this.btnCancel.setPreferredSize(new Dimension(80, btnHSize));
        this.btnOK.setToolTipText(NbBundle.getMessage(DLightTargetSelectionDialog.class, (String)"DLightTargetSelectionDialog.OK_Button.Tooltip"));
        this.btnCancel.setToolTipText(NbBundle.getMessage(DLightTargetSelectionDialog.class, (String)"DLightTargetSelectionDialog.Cancel_Button.Tooltip"));
        this.buttonPanel.setLayout(new FlowLayout(4, 5, 20));
        this.buttonPanel.add(this.btnOK);
        this.buttonPanel.add(this.btnCancel);
        this.getContentPane().add(this.buttonPanel);
    }

    void setResult(int result) {
        this.result = result;
    }

    String selectFile(String startWith) {
        return this.selectFile(startWith, null, null);
    }

    String selectFile(String startWith, FileFilter filter) {
        return this.selectFile(startWith, filter, null);
    }

    String selectFile(String startWith, FileFilter filter, ContentValidator validator) {
        return this.select(startWith, filter, validator, 0);
    }

    String selectDirectory(String startWith) {
        return this.selectDirectory(startWith, null);
    }

    String selectDirectory(String startWith, ContentValidator validator) {
        return this.select(startWith, null, validator, 1);
    }

    String select(String startWith, FileFilter filter, ContentValidator validator, int mode) {
        if (startWith == null) {
            startWith = ".";
        }
        File startPath = new File(startWith);
        String selection = startWith;
        JFileChooser2 jfc = new JFileChooser2(startPath, validator);
        jfc.setFileSelectionMode(mode);
        jfc.setFileFilter(filter);
        jfc.addChoosableFileFilter(filter);
        jfc.setMultiSelectionEnabled(false);
        int i = jfc.showOpenDialog(this);
        if (i == 0) {
            try {
                File fResult = jfc.getSelectedFile();
                selection = fResult.getCanonicalPath();
                return selection;
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return null;
    }

    void addPanel(String title, JComboBox2 comboBox, JButton button) {
        JPanel panel = new JPanel(new DLightTargetSelectionDialogLayout());
        panel.setBorder(BorderFactory.createTitledBorder(title));
        if (comboBox != null) {
            panel.add((Component)comboBox, DLightTargetSelectionDialogLayout.COMBO_IDX);
            this.toValidate.add(comboBox);
        }
        if (button != null) {
            panel.add((Component)button, DLightTargetSelectionDialogLayout.BTN_IDX);
        }
        this.getContentPane().add(panel);
    }

    static void updateModel(DefaultComboBoxModel model, String value) {
        if (value == null) {
            return;
        }
        model.removeElement(value);
        model.insertElementAt(value, 0);
        model.setSelectedItem(value);
    }

    public int getResult() {
        return this.result;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (!(src instanceof JButton)) {
            return;
        }
        if (src == this.btnOK) {
            this.approveSelection();
        } else if (src == this.btnCancel) {
            this.setResult(1);
            this.setVisible(false);
        }
    }

    abstract void initComponents();

    public void approveSelection() {
        for (Validatable v : this.toValidate) {
            if (v.validateContent()) continue;
            return;
        }
        this.setResult(0);
        this.setVisible(false);
    }
}

