/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.codestructure;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeStatement;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.codestructure.UsedCodeObject;

abstract class AbstractCodeStatement
implements CodeStatement {
    protected CodeExpression parentExpression;

    protected AbstractCodeStatement(CodeExpression parentExpression) {
        this.parentExpression = parentExpression;
    }

    @Override
    public CodeExpression getParentExpression() {
        return this.parentExpression;
    }

    @Override
    public void usageRegistered(UsedCodeObject usedObject) {
    }

    @Override
    public boolean usedObjectRemoved(UsedCodeObject usedObject) {
        return false;
    }

    @Override
    public UsedCodeObject getDefiningObject() {
        return this.getParentExpression();
    }

    @Override
    public Iterator getUsedObjectsIterator() {
        return new UsedObjectsIterator();
    }

    private class UsedObjectsIterator
    implements Iterator {
        int index;
        CodeExpression[] parameters;

        UsedObjectsIterator() {
            this.index = AbstractCodeStatement.this.getParentExpression() != null ? -1 : 0;
            this.parameters = AbstractCodeStatement.this.getStatementParameters();
            if (this.parameters == null) {
                this.parameters = CodeStructure.EMPTY_PARAMS;
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < this.parameters.length;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            CodeExpression obj = this.index > -1 ? this.parameters[this.index] : AbstractCodeStatement.this.getParentExpression();
            ++this.index;
            return obj;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

