/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.codecoverage;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.text.Document;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.gsf.codecoverage.api.CoverageActionFactory;
import org.netbeans.modules.gsf.codecoverage.api.CoverageManager;
import org.netbeans.modules.gsf.codecoverage.api.CoverageProvider;
import org.netbeans.modules.gsf.codecoverage.api.CoverageProviderHelper;
import org.netbeans.modules.gsf.codecoverage.api.CoverageType;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageDetails;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageSummary;
import org.netbeans.modules.ruby.codecoverage.InstallRCovAction;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class RubyCoverageProvider
implements CoverageProvider {
    private static final String CODE_COVERAGE_TEST_ACTION = "code.coverage.test.action";
    private Map<String, String> hitCounts;
    private Map<String, String> fullNames;
    private long timestamp;
    private Set<String> mimeTypes;
    private Project project;
    private Boolean enabled;
    private Boolean aggregating;
    private static final boolean SKIP_EXCLUSIONS;
    private static final boolean RCOV_RAILS;

    public RubyCoverageProvider(Project project) {
        this.project = project;
        this.mimeTypes = new HashSet<String>();
        this.mimeTypes.add("text/x-ruby");
    }

    public static RubyCoverageProvider get(Project project) {
        return (RubyCoverageProvider)project.getLookup().lookup(RubyCoverageProvider.class);
    }

    public boolean supportsHitCounts() {
        return true;
    }

    public boolean supportsAggregation() {
        return true;
    }

    public synchronized boolean isAggregating() {
        if (this.aggregating == null) {
            this.aggregating = CoverageProviderHelper.isAggregating((Project)this.project);
        }
        return this.aggregating;
    }

    public synchronized void setAggregating(boolean on) {
        if (this.aggregating != null && on == this.isAggregating()) {
            return;
        }
        this.aggregating = on;
        CoverageProviderHelper.setAggregating((Project)this.project, (boolean)on);
    }

    public synchronized boolean isEnabled() {
        if (this.enabled == null) {
            this.enabled = CoverageProviderHelper.isEnabled((Project)this.project);
        }
        return this.enabled;
    }

    public synchronized void setEnabled(boolean on) {
        if (this.enabled != null && on == this.isEnabled()) {
            return;
        }
        this.timestamp = 0L;
        if (on) {
            GemManager gemManager = RubyPlatform.gemManagerFor((Project)this.project);
            if (gemManager == null || !gemManager.isGemInstalled("rcov")) {
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(RubyCoverageProvider.class, (String)"RcovNotInstalled"), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                return;
            }
        } else {
            this.hitCounts = null;
            this.fullNames = null;
        }
        this.enabled = on;
        CoverageProviderHelper.setEnabled((Project)this.project, (boolean)on);
    }

    private static List<LineCount> getLineCounts(String lines) {
        int start;
        int size = lines.length() / 5;
        ArrayList<LineCount> lineCounts = new ArrayList<LineCount>(size);
        int length = lines.length();
        int line = 0;
        int startLine = -1;
        for (int i = start = 0; i < length; ++i) {
            char c = lines.charAt(i);
            if (c == ':') {
                line = Integer.valueOf(lines.substring(start, i));
                start = i + 1;
                continue;
            }
            if (c == ',') {
                int count = Integer.valueOf(lines.substring(start, i));
                if (startLine != -1 && startLine < line) {
                    for (int l = startLine; l <= line; ++l) {
                        lineCounts.add(new LineCount(l, count));
                    }
                    startLine = -1;
                } else {
                    lineCounts.add(new LineCount(line, count));
                }
                start = i + 1;
                continue;
            }
            if (c == ' ') {
                start = i + 1;
                continue;
            }
            if (c != '>') continue;
            startLine = Integer.valueOf(lines.substring(start, i));
            start = i + 1;
        }
        return lineCounts;
    }

    private static FileCoverageSummary createSummary(Project project, String fileName, List<LineCount> counts) {
        Sources sources;
        int lineCount = 0;
        int notExecuted = 0;
        int partialCount = 0;
        int inferredCount = 0;
        for (LineCount lc : counts) {
            if (lc.lineno > lineCount) {
                lineCount = lc.lineno;
            }
            if (lc.count == -2) {
                ++notExecuted;
                continue;
            }
            if (lc.count != -1) continue;
            ++inferredCount;
        }
        int executedCount = lineCount - notExecuted;
        File f = new File(fileName);
        FileObject file = f.exists() ? FileUtil.toFileObject((File)f) : project.getProjectDirectory().getFileObject(fileName.replace('\\', '/'));
        if (file == null && (sources = (Sources)project.getLookup().lookup(Sources.class)) != null) {
            String SOURCES_TYPE_RUBY = "ruby";
            for (SourceGroup sg : sources.getSourceGroups(SOURCES_TYPE_RUBY)) {
                FileObject root = sg.getRootFolder();
                file = fileName.indexOf(92) != -1 ? root.getFileObject(fileName.replace("\\", "/")) : root.getFileObject(fileName);
                if (file != null) break;
            }
        }
        FileCoverageSummary result = new FileCoverageSummary(file, fileName, lineCount, executedCount, inferredCount, partialCount);
        return result;
    }

    public synchronized List<FileCoverageSummary> getResults() {
        ArrayList<FileCoverageSummary> results = new ArrayList<FileCoverageSummary>();
        this.update();
        if (this.hitCounts == null) {
            return null;
        }
        for (Map.Entry<String, String> entry : this.hitCounts.entrySet()) {
            String fileName = entry.getKey();
            if ("fcntl".equals(fileName)) continue;
            List<LineCount> counts = RubyCoverageProvider.getLineCounts(entry.getValue());
            FileCoverageSummary result = RubyCoverageProvider.createSummary(this.project, fileName, counts);
            results.add(result);
        }
        return results;
    }

    public static Action createCoverageAction(Project project) {
        InstallRCovAction installRCovAction = new InstallRCovAction(project);
        if (!installRCovAction.isEnabled()) {
            installRCovAction = null;
        }
        return CoverageActionFactory.createCollectorAction((Action)installRCovAction, null);
    }

    public synchronized void clear() {
        File file = this.getRubyCoverageFile();
        if (file.exists()) {
            file.delete();
        }
        if ((file = this.getNbCoverageFile()).exists()) {
            file.delete();
        }
        this.hitCounts = null;
        this.fullNames = null;
        this.timestamp = 0L;
    }

    public synchronized FileCoverageDetails getDetails(FileObject fo, Document doc) {
        String name;
        String fullName;
        this.update();
        if (this.hitCounts == null) {
            return null;
        }
        String path = FileUtil.toFile((FileObject)fo).getPath();
        if (path == null) {
            return null;
        }
        String lines = this.hitCounts.get(path);
        if (lines == null) {
            lines = this.hitCounts.get(path.toLowerCase());
        }
        if (lines == null && (fullName = this.fullNames.get((name = fo.getNameExt()).toLowerCase())) != null && !fullName.equalsIgnoreCase(path)) {
            lines = this.hitCounts.get(fullName);
        }
        if (lines != null) {
            List<LineCount> hits = RubyCoverageProvider.getLineCounts(lines);
            int max = 0;
            for (LineCount lineCount : hits) {
                if (lineCount.lineno <= max) continue;
                max = lineCount.lineno;
            }
            int[] result = new int[max + 1];
            for (int i = 0; i < max + 1; ++i) {
                result[i] = -1;
            }
            for (LineCount lineCount : hits) {
                assert (lineCount.lineno >= 0);
                result[((LineCount)lineCount).lineno] = lineCount.count;
            }
            return new RubyFileCoverageDetails(fo, result, this.project, path, hits, this.timestamp);
        }
        return null;
    }

    public Set<String> getMimeTypes() {
        return this.mimeTypes;
    }

    private File getNbCoverageDir() {
        return new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory().getFileObject("nbproject")), "private" + File.separator + "coverage");
    }

    private File getNbCoverageFile() {
        return new File(this.getNbCoverageDir(), ".nbcoverage");
    }

    private File getRubyCoverageFile() {
        return new File(this.getNbCoverageDir(), ".coverage");
    }

    public synchronized void notifyProjectOpened() {
        CoverageManager.INSTANCE.setEnabled(this.project, true);
    }

    public void setAvailable(boolean b) {
        CoverageManager.INSTANCE.setEnabled(this.project, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void update() {
        block20: {
            File rubyCoverage = this.getRubyCoverageFile();
            if (!rubyCoverage.exists()) {
                return;
            }
            File nbCoverage = this.getNbCoverageFile();
            if (nbCoverage.exists() && this.timestamp < nbCoverage.lastModified()) {
                this.timestamp = nbCoverage.lastModified();
                this.hitCounts = new HashMap<String, String>();
                this.fullNames = new HashMap<String, String>();
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new FileReader(nbCoverage));
                    while (true) {
                        try {
                            while (true) {
                                String file = br.readLine();
                                String lines = br.readLine();
                                if (file == null) break block20;
                                if (lines == null) {
                                    break block20;
                                }
                                int last = Math.max(file.lastIndexOf(92), file.lastIndexOf(47));
                                String base = file;
                                if (last != -1) {
                                    base = file.substring(last + 1);
                                }
                                this.fullNames.put(base.toLowerCase(), file);
                                this.hitCounts.put(file, lines);
                            }
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                            continue;
                        }
                        break;
                    }
                }
                catch (FileNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            }
        }
    }

    public RubyExecutionDescriptor wrapWithCoverage(final RubyExecutionDescriptor original, boolean isRake, String includeName) {
        String[] additionalArgs;
        RubyPlatform platform = original.getPlatform();
        File rcov = new File(platform.getInterpreterFile().getParentFile(), "rcov");
        if (!(rcov.exists() || (rcov = new File(platform.getInterpreterFile().getParentFile(), "rcov.bat")).exists() || (rcov = new File(platform.getInterpreterFile().getParentFile(), "rcov.cmd")).exists())) {
            Logger.getLogger(RubyCoverageProvider.class.getName()).log(Level.WARNING, "Warning: RCov not found at " + rcov.getPath());
            return original;
        }
        File dir = this.getNbCoverageDir();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        InstalledFileLocator locator = InstalledFileLocator.getDefault();
        File script = locator.locate("coverage/rcov_wrapper.rb", "org-netbeans-modules-ruby-codecoverage.jar", false);
        assert (script != null);
        String target = script.getPath();
        ArrayList<String> args = new ArrayList<String>(20);
        File nbCoverage = this.getNbCoverageFile();
        File rubyCoverage = this.getRubyCoverageFile();
        args.add(rubyCoverage.getPath());
        args.add(nbCoverage.getPath());
        boolean isAggregating = this.isAggregating();
        HashMap<String, String> additionalEnv = original.getAdditionalEnvironment();
        if (!isRake) {
            args.add(rcov.getPath());
            this.buildRcovArgs(null, args, isAggregating, includeName, original);
        }
        args.add(original.getScript());
        String initial = original.getInitialArgsPlain();
        if (isRake) {
            String[] ia;
            additionalEnv = new HashMap<String, String>(additionalEnv);
            File rakeWrapper = locator.locate("coverage/rake_wrapper.rb", "org-netbeans-modules-ruby-codecoverage.jar", false);
            assert (rakeWrapper != null);
            additionalEnv.put("NB_RAKE_WRAPPER", rakeWrapper.getPath());
            additionalEnv.put("NB_RCOV_PATH", rcov.getPath());
            if (initial != null && (ia = Utilities.parseParameters((String)initial)).length == 2 && "-r".equals(ia[0])) {
                additionalEnv.put("NB_DELEGATED_SCRIPT", ia[1]);
                initial = "-r \"" + rakeWrapper.getPath() + "\"";
            }
            if (!isAggregating) {
                this.clear();
            }
            StringBuilder rcovArgs = new StringBuilder();
            this.buildRcovArgs(rcovArgs, null, true, includeName, original);
            additionalEnv.put("NB_RCOV_ARGS", rcovArgs.toString());
        }
        if ((additionalArgs = original.getAdditionalArgs()) != null) {
            if (!isRake) {
                args.add("--");
            }
            for (String arg : additionalArgs) {
                args.add(arg);
            }
        }
        additionalArgs = args.toArray(new String[args.size()]);
        RubyExecutionDescriptor descriptor = new RubyExecutionDescriptor(original);
        descriptor.addAdditionalEnv(additionalEnv);
        descriptor.initialArgs(initial);
        descriptor.script(target);
        descriptor.additionalArgs(additionalArgs);
        HideCoverageFramesConvertor hideWrapperConverter = new HideCoverageFramesConvertor();
        descriptor.addOutConvertor((LineConvertor)hideWrapperConverter);
        descriptor.addErrConvertor((LineConvertor)hideWrapperConverter);
        descriptor.postBuild(new Runnable(){

            @Override
            public void run() {
                RubyCoverageProvider.this.update();
                CoverageManager.INSTANCE.resultsUpdated(RubyCoverageProvider.this.project, (CoverageProvider)RubyCoverageProvider.this);
                if (original.getPostBuild() != null) {
                    original.getPostBuild().run();
                }
            }
        });
        return descriptor;
    }

    public String getTestAllAction() {
        String action;
        PropertyEvaluator evaluator;
        if (this.project != null && (evaluator = (PropertyEvaluator)this.project.getLookup().lookup(PropertyEvaluator.class)) != null && (action = evaluator.getProperty(CODE_COVERAGE_TEST_ACTION)) != null) {
            return action;
        }
        return null;
    }

    private void buildRcovArgs(StringBuilder sb, List<String> args, boolean isAggregating, String includeName, RubyExecutionDescriptor original) {
        String dataFile = this.getRubyCoverageFile().getPath();
        if (isAggregating) {
            if (args != null) {
                args.add("--aggregate");
                args.add(dataFile);
            } else {
                sb.append(" --aggregate \"");
                sb.append(dataFile);
                sb.append("\"");
            }
        }
        if (args != null) {
            args.add("--save");
            args.add(dataFile);
        } else {
            sb.append(" --save \"");
            sb.append(dataFile);
            sb.append("\"");
        }
        if (args != null) {
            args.add("--no-html");
        } else {
            sb.append(" --no-html");
        }
        if (includeName == null && original.getFileObject() != null) {
            includeName = original.getFileObject().getNameExt();
        }
        if (includeName != null) {
            includeName = includeName.substring(Math.max(includeName.lastIndexOf(92), includeName.lastIndexOf(47)) + 1);
            if (args != null) {
                args.add("--include-file");
                args.add(includeName);
            } else {
                sb.append(" --include-file \"");
                sb.append(includeName);
                sb.append("\"");
            }
        }
        StringBuilder exclude = new StringBuilder(100);
        exclude.append("\\/ruby\\/,/\\\\ruby\\\\/");
        exclude.append(",\\bfcntl\\b");
        exclude.append(",/\\bvendor\\//");
        RubyPlatform platform = original.getPlatform();
        if (platform != null) {
            String gemHome;
            GemManager gemManager;
            String home = platform.getHome().getPath();
            exclude.append(',');
            exclude.append(home.replace("/", "\\/"));
            if (File.separatorChar == '\\') {
                exclude.append(home.replace('\\', '/').replace("/", "\\/"));
            }
            if (platform.hasRubyGemsInstalled() && (gemManager = platform.getGemManager()) != null && (gemHome = gemManager.getGemHome()) != null && !gemHome.startsWith(home)) {
                exclude.append(',');
                exclude.append(gemHome.replace("/", "\\/"));
                if (File.separatorChar == '\\') {
                    exclude.append(gemHome.replace('\\', '/').replace("/", "\\/"));
                }
            }
        }
        if (SKIP_EXCLUSIONS) {
            if (args != null) {
                args.add("--exclude-only");
                args.add("thisstringdefinitelydoesnotexist");
            } else {
                sb.append(" --exclude-only \"thisstringdefinitelydoesnotexist\"");
            }
        } else if (args != null) {
            args.add("--exclude-only");
            args.add(exclude.toString());
        } else {
            sb.append(" --exclude-only \"");
            sb.append(exclude.toString());
            sb.append("\"");
        }
        if (RCOV_RAILS && this.project.getClass().getSimpleName().contains("Rails")) {
            if (args != null) {
                args.add("--rails");
            } else {
                sb.append(" --rails");
            }
        }
    }

    static {
        String exclude = System.getProperty("coverage.exclude");
        SKIP_EXCLUSIONS = exclude != null && "true".equals(exclude);
        String rails = System.getProperty("coverage.rcov-rails");
        RCOV_RAILS = rails == null || "true".equals(rails);
    }

    private static class LineCount {
        private final int lineno;
        private final int count;

        public LineCount(int lineno, int count) {
            this.lineno = lineno;
            this.count = count;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LineCount other = (LineCount)obj;
            return this.lineno == other.lineno;
        }

        public int hashCode() {
            int hash = 7;
            hash = 59 * hash + this.lineno;
            return hash;
        }
    }

    private static class RubyFileCoverageDetails
    implements FileCoverageDetails {
        private final int[] hitCounts;
        private final String fileName;
        private final List<LineCount> lineCounts;
        private Project project;
        private final long lastUpdated;
        private final FileObject fileObject;

        public RubyFileCoverageDetails(FileObject fileObject, int[] hitCounts, Project project, String fileName, List<LineCount> lineCounts, long lastUpdated) {
            this.fileObject = fileObject;
            this.hitCounts = hitCounts;
            this.project = project;
            this.fileName = fileName;
            this.lineCounts = lineCounts;
            this.lastUpdated = lastUpdated;
        }

        public int getLineCount() {
            return this.hitCounts.length;
        }

        public boolean hasHitCounts() {
            return true;
        }

        public FileCoverageSummary getSummary() {
            return RubyCoverageProvider.createSummary(this.project, this.fileName, this.lineCounts);
        }

        public CoverageType getType(int lineNo) {
            int count = this.hitCounts[lineNo];
            switch (count) {
                case -3: {
                    return CoverageType.UNKNOWN;
                }
                case -2: {
                    return CoverageType.NOT_COVERED;
                }
                case -1: {
                    return CoverageType.INFERRED;
                }
            }
            return CoverageType.COVERED;
        }

        public int getHitCount(int lineNo) {
            return this.hitCounts[lineNo];
        }

        public long lastUpdated() {
            return this.lastUpdated;
        }

        public FileObject getFile() {
            return this.fileObject;
        }
    }

    private static class HideCoverageFramesConvertor
    implements LineConvertor {
        private HideCoverageFramesConvertor() {
        }

        public List<ConvertedLine> convert(String line) {
            if (line.contains("/ruby/coverage/") || line.contains("/rcov") || File.separatorChar == '\\' && (line.contains("\\ruby\\coverage\\") || line.contains("\\rcov"))) {
                return Collections.emptyList();
            }
            return null;
        }
    }
}

