/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.cli.options;

import java.util.Arrays;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.cli.CLIArgumentsList;
import org.netbeans.installer.utils.cli.CLIOptionOneArgument;
import org.netbeans.installer.utils.cli.options.RecordOption;
import org.netbeans.installer.utils.exceptions.CLIOptionException;

public class RegistryOption
extends CLIOptionOneArgument {
    public static final String REGISTRY_ARG = "--registry";
    private static final String WARNING_BAD_REGISTRY_ARG_KEY = "O.warning.bad.registry.arg";

    public void execute(CLIArgumentsList arguments) throws CLIOptionException {
        String value = arguments.next();
        String existing = System.getProperty("nbi.product.remote.registries");
        if (existing == null) {
            System.setProperty("nbi.product.remote.registries", value);
        } else if (!Arrays.asList(existing.split("\n")).contains(value)) {
            System.setProperty("nbi.product.remote.registries", existing + "\n" + value);
        }
    }

    protected String getLackOfArgumentsMessage() {
        return ResourceUtils.getString(RecordOption.class, WARNING_BAD_REGISTRY_ARG_KEY, REGISTRY_ARG);
    }

    public String getName() {
        return REGISTRY_ARG;
    }
}

