/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxwsmodel.project;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.modules.websvc.api.jaxws.project.JaxWsBuildScriptExtensionProvider;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.WebServiceNotifier;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.jaxwsmodel.project.EjbBuildScriptExtensionProvider;
import org.netbeans.modules.websvc.jaxwsmodel.project.TransformerUtils;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class EjbJaxWsOpenHook
extends ProjectOpenedHook {
    private Project prj;
    private JaxWsModel.ServiceListener serviceListener;

    public EjbJaxWsOpenHook(Project project) {
        this.prj = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void projectOpened() {
        JaxWsModel jaxWsModel = (JaxWsModel)this.prj.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null) {
            this.serviceListener = new JaxWsModel.ServiceListener(){

                @Override
                public void serviceAdded(String string, String string2) {
                    WebServiceNotifier webServiceNotifier = (WebServiceNotifier)EjbJaxWsOpenHook.this.prj.getLookup().lookup(WebServiceNotifier.class);
                    if (webServiceNotifier != null) {
                        webServiceNotifier.serviceAdded(string, string2);
                    }
                }

                @Override
                public void serviceRemoved(String string) {
                    WebServiceNotifier webServiceNotifier = (WebServiceNotifier)EjbJaxWsOpenHook.this.prj.getLookup().lookup(WebServiceNotifier.class);
                    if (webServiceNotifier != null) {
                        webServiceNotifier.serviceRemoved(string);
                    }
                }
            };
            jaxWsModel.addServiceListener(this.serviceListener);
            JaxWsBuildScriptExtensionProvider jaxWsBuildScriptExtensionProvider = (JaxWsBuildScriptExtensionProvider)this.prj.getLookup().lookup(JaxWsBuildScriptExtensionProvider.class);
            AntBuildExtender antBuildExtender = (AntBuildExtender)this.prj.getLookup().lookup(AntBuildExtender.class);
            if (jaxWsBuildScriptExtensionProvider != null && antBuildExtender != null) {
                Object object;
                boolean bl = false;
                FileObject fileObject = this.prj.getProjectDirectory().getFileObject("nbproject/jaxws-build.xml");
                FileObject fileObject2 = jaxWsModel.getJaxWsFile();
                try {
                    boolean bl2 = fileObject2 != null && WSUtils.hasServiceOrClient(fileObject2);
                    AntBuildExtender.Extension extension = antBuildExtender.getExtension("jaxws");
                    if (fileObject == null || extension == null) {
                        if (bl2) {
                            jaxWsBuildScriptExtensionProvider.addJaxWsExtension(antBuildExtender);
                            ProjectManager.getDefault().saveProject(this.prj);
                            bl = true;
                        }
                    } else if (!bl2) {
                        jaxWsBuildScriptExtensionProvider.removeJaxWsExtension(antBuildExtender);
                        ProjectManager.getDefault().saveProject(this.prj);
                        bl = true;
                    } else {
                        object = this.prj.getProjectDirectory().getFileObject("nbproject/project.xml");
                        if (object != null) {
                            this.removeCompileDependencies(this.prj, (FileObject)object, antBuildExtender);
                        }
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                if (fileObject2 != null && !bl) {
                    URL uRL = EjbJaxWsOpenHook.class.getResource(EjbBuildScriptExtensionProvider.JAX_WS_STYLESHEET_RESOURCE);
                    assert (uRL != null);
                    try {
                        String string;
                        EditableProperties editableProperties;
                        boolean bl3 = false;
                        object = uRL.openStream();
                        String string2 = null;
                        try {
                            string2 = TransformerUtils.getCrc32((InputStream)object);
                        }
                        finally {
                            ((InputStream)object).close();
                        }
                        if (string2 != null && (editableProperties = WSUtils.getEditableProperties(this.prj, "nbproject/genfiles.properties")) != null && !string2.equals(string = editableProperties.getProperty("nbproject/jaxws-build.xml.stylesheet.CRC32"))) {
                            editableProperties.setProperty("nbproject/jaxws-build.xml.stylesheet.CRC32", string2);
                            WSUtils.storeEditableProperties(this.prj, "nbproject/genfiles.properties", editableProperties);
                            bl3 = true;
                        }
                        if (bl3) {
                            TransformerUtils.transformClients(this.prj.getProjectDirectory(), EjbBuildScriptExtensionProvider.JAX_WS_STYLESHEET_RESOURCE, true);
                        }
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.FINE, "failed to generate jaxws-build.xml from stylesheet", iOException);
                    }
                }
            }
        }
    }

    protected void projectClosed() {
        JaxWsModel jaxWsModel = (JaxWsModel)this.prj.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null) {
            jaxWsModel.removeServiceListener(this.serviceListener);
        }
    }

    private void removeCompileDependencies(Project project, FileObject fileObject, AntBuildExtender antBuildExtender) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(FileUtil.toFile((FileObject)fileObject)));
        String string = null;
        boolean bl = false;
        while ((string = bufferedReader.readLine()) != null) {
            if (!string.contains("wsimport-client-compile") && !string.contains("wsimport-service-compile")) continue;
            bl = true;
            break;
        }
        bufferedReader.close();
        if (bl) {
            TransformerUtils.transformClients(project.getProjectDirectory(), EjbBuildScriptExtensionProvider.JAX_WS_STYLESHEET_RESOURCE);
            AntBuildExtender.Extension extension = antBuildExtender.getExtension("jaxws");
            if (extension != null) {
                extension.removeDependency("-do-compile", "wsimport-client-compile");
                extension.removeDependency("-do-compile-single", "wsimport-client-compile");
                extension.removeDependency("-do-compile", "wsimport-service-compile");
                extension.removeDependency("-do-compile-single", "wsimport-service-compile");
                ProjectManager.getDefault().saveProject(project);
            }
        }
    }
}

