/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.spi.indicator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.dlight.api.datafilter.DataFilterListener;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetListener;
import org.netbeans.modules.dlight.api.execution.Validateable;
import org.netbeans.modules.dlight.api.indicator.IndicatorDataProviderConfiguration;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.spi.impl.IndicatorAccessor;
import org.netbeans.modules.dlight.spi.impl.IndicatorDataProviderAccessor;
import org.netbeans.modules.dlight.spi.indicator.Indicator;
import org.netbeans.modules.dlight.spi.indicator.IndicatorNotificationsListener;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;

public abstract class IndicatorDataProvider<T extends IndicatorDataProviderConfiguration>
implements DLightTargetListener,
Validateable<DLightTarget>,
DataFilterListener {
    private final Collection<IndicatorNotificationsListener> notificationListeners = new ArrayList<IndicatorNotificationsListener>();
    private ServiceInfoDataStorage serviceInfoDataStorage;

    private final void addIndicatorDataProviderListener(IndicatorNotificationsListener l) {
        if (!this.notificationListeners.contains(l)) {
            this.notificationListeners.add(l);
        }
    }

    private final boolean removeIndicatorDataProviderListener(IndicatorNotificationsListener l) {
        return this.notificationListeners.remove(l);
    }

    public final boolean subscribe(Indicator<?> indicator) {
        List<DataTableMetadata.Column> indicatorColumns = IndicatorAccessor.getDefault().getMetadataColumns(indicator);
        for (DataTableMetadata tdm : this.getDataTablesMetadata()) {
            if (tdm == null) continue;
            List<DataTableMetadata.Column> providedColumns = tdm.getColumns();
            for (DataTableMetadata.Column pcol : providedColumns) {
                for (DataTableMetadata.Column icol : indicatorColumns) {
                    if (!icol.equals(pcol)) continue;
                    indicator.columnProvided(icol);
                    this.addIndicatorDataProviderListener(indicator);
                    return true;
                }
            }
        }
        return false;
    }

    public final void unsubscribe(Indicator<?> indicator) {
        this.removeIndicatorDataProviderListener(indicator);
    }

    protected final void resetIndicators() {
        for (IndicatorNotificationsListener l : this.notificationListeners) {
            l.reset();
        }
    }

    protected final void notifyIndicators(List<DataRow> data) {
        for (IndicatorNotificationsListener l : this.notificationListeners) {
            l.updated(data);
        }
    }

    protected final void suggestIndicatorsRepaint() {
        for (IndicatorNotificationsListener l : this.notificationListeners) {
            l.suggestRepaint();
        }
    }

    public abstract Collection<DataTableMetadata> getDataTablesMetadata();

    public abstract String getName();

    public final void init(ServiceInfoDataStorage infoStorage) {
        this.serviceInfoDataStorage = infoStorage;
    }

    protected final ServiceInfoDataStorage getServiceInfoDataStorage() {
        return this.serviceInfoDataStorage;
    }

    static {
        IndicatorDataProviderAccessor.setDefault(new IndicatorDataProviderAccessorImpl());
    }

    private static final class IndicatorDataProviderAccessorImpl
    extends IndicatorDataProviderAccessor {
        private IndicatorDataProviderAccessorImpl() {
        }

        @Override
        public void addIndicatorDataProviderListener(IndicatorDataProvider provider, IndicatorNotificationsListener l) {
            provider.addIndicatorDataProviderListener(l);
        }

        @Override
        public boolean removeIndicatorDataProviderListener(IndicatorDataProvider provider, IndicatorNotificationsListener l) {
            return provider.removeIndicatorDataProviderListener(l);
        }
    }
}

