/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Manifest;

public class JarWithModuleAttributes
extends Jar {
    private static final Pattern COMMA_SPACE = Pattern.compile(", *");
    private static final Pattern IMPL_DEP = Pattern.compile(" *([a-zA-Z0-9_.]+)(/[0-9]+)? *= *(.+) *");
    private File stamp;

    public void setStamp(File stamp) {
        this.stamp = stamp;
    }

    static String extractCodeName(Attributes attr) {
        return JarWithModuleAttributes.extractCodeName(attr, null);
    }

    static String extractCodeName(Attributes attr, boolean[] osgi) {
        int params;
        String codename = attr.getValue("OpenIDE-Module");
        if (codename != null) {
            return codename;
        }
        codename = attr.getValue("Bundle-SymbolicName");
        if (codename == null) {
            return null;
        }
        codename = codename.replace('-', '_');
        if (osgi != null) {
            osgi[0] = true;
        }
        if ((params = codename.indexOf(59)) >= 0) {
            return codename.substring(0, params);
        }
        return codename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setManifest(File manifestFile) throws BuildException {
        Manifest added = new Manifest();
        try {
            String buildNumber;
            String javaDep;
            String moduleDeps;
            String friends;
            String pubPkgs;
            String specVer;
            String implVers;
            Manifest staticManifest;
            FileInputStream is = new FileInputStream(manifestFile);
            boolean isOSGiMode = false;
            try {
                String cnbDots;
                staticManifest = new Manifest((Reader)new InputStreamReader((InputStream)is, "UTF-8"));
                Manifest.Section mainSection = staticManifest.getMainSection();
                implVers = mainSection.getAttributeValue("OpenIDE-Module-Implementation-Version");
                specVer = mainSection.getAttributeValue("OpenIDE-Module-Specification-Version");
                String myself = mainSection.getAttributeValue("OpenIDE-Module");
                if (myself == null) {
                    myself = mainSection.getAttributeValue("Bundle-SymbolicName");
                    boolean bl = isOSGiMode = myself != null;
                }
                if (myself == null) {
                    throw new BuildException("No OpenIDE-Module in " + manifestFile);
                }
                int slash = myself.indexOf(47);
                String ownCnb = slash == -1 ? myself : myself.substring(0, slash);
                String cnbs = this.getProject().getProperty("code.name.base.slashes");
                String string = cnbDots = cnbs != null ? cnbs.replace('/', '.') : null;
                if (!ownCnb.equals(cnbDots)) {
                    throw new BuildException("Mismatch in module code name base: manifest says " + ownCnb + " but project.xml says " + cnbDots, this.getLocation());
                }
            }
            finally {
                ((InputStream)is).close();
            }
            if (isOSGiMode) {
                added.addConfiguredAttribute(new Manifest.Attribute("Bundle-ManifestVersion", "2"));
            }
            if ((pubPkgs = this.getProject().getProperty("public.packages")) == null) {
                throw new BuildException("Must have defined 'public.packages'", this.getLocation());
            }
            if (isOSGiMode) {
                if (pubPkgs != null && !pubPkgs.equals("-")) {
                    added.addConfiguredAttribute(new Manifest.Attribute("Export-Package", pubPkgs.replaceAll("\\.\\*", "")));
                }
            } else {
                added.addConfiguredAttribute(new Manifest.Attribute("OpenIDE-Module-Public-Packages", pubPkgs));
            }
            if ((friends = this.getProject().getProperty("friends")) != null) {
                if (isOSGiMode) {
                    throw new BuildException("friends defined, yet OSGi does not support that " + friends);
                }
                added.addConfiguredAttribute(new Manifest.Attribute("OpenIDE-Module-Friends", friends));
            }
            String javahelpClassPathExtension = this.getProject().getProperty("javahelp.class.path.extension");
            String classPathExtensions = this.getProject().getProperty("class.path.extensions");
            String cp = javahelpClassPathExtension != null ? (classPathExtensions != null ? classPathExtensions + " " + javahelpClassPathExtension : javahelpClassPathExtension) : (classPathExtensions != null ? classPathExtensions : null);
            if (cp != null) {
                added.addConfiguredAttribute(new Manifest.Attribute("Class-Path", cp));
            }
            if ((moduleDeps = this.getProject().getProperty("module.dependencies")) != null) {
                if (isOSGiMode) {
                    StringBuilder sb = new StringBuilder();
                    String sep = "";
                    for (String one : moduleDeps.split(",")) {
                        int hiMajor;
                        String cnb;
                        String codename;
                        String versionS;
                        if (one.indexOf(61) != -1) {
                            throw new BuildException("Implementation dependencies not supported in Netigso mode: " + one);
                        }
                        int greaterThan = one.indexOf(62);
                        if (greaterThan == -1) {
                            versionS = "0";
                            codename = one.trim();
                        } else {
                            versionS = one.substring(greaterThan + 1).trim();
                            codename = one.substring(0, greaterThan).trim();
                        }
                        if (codename.equals("org.netbeans.libs.osgi")) continue;
                        int[] version = this.parseDecimal(versionS, 3);
                        int slash = codename.indexOf(47);
                        if (slash >= 0) {
                            cnb = codename.substring(0, slash).trim();
                            String range = codename.substring(slash + 1).trim();
                            int dash = range.indexOf(45);
                            if (dash == -1) {
                                hiMajor = Integer.parseInt(range);
                                version[0] = version[0] + 100 * hiMajor;
                            } else {
                                hiMajor = Integer.parseInt(range.substring(dash + 1));
                                version[0] = version[0] + 100 * Integer.parseInt(range.substring(0, dash));
                            }
                        } else {
                            cnb = codename;
                            hiMajor = 0;
                        }
                        sb.append(sep);
                        sep = ", ";
                        sb.append(cnb).append(";bundle-version=\"[");
                        String conditionalDot = "";
                        for (int i = 0; i < version.length; ++i) {
                            sb.append(conditionalDot);
                            sb.append(version[i]);
                            conditionalDot = ".";
                        }
                        sb.append(",").append((hiMajor + 1) * 100).append(")\"");
                    }
                    added.addConfiguredAttribute(new Manifest.Attribute("Require-Bundle", sb.toString()));
                } else {
                    added.addConfiguredAttribute(new Manifest.Attribute("OpenIDE-Module-Module-Dependencies", moduleDeps));
                }
            }
            if ((javaDep = this.getProject().getProperty("javac.target")) != null && javaDep.matches("[0-9]+(\\.[0-9]+)*")) {
                if (isOSGiMode) {
                    if (javaDep.matches("1\\.[0-5]")) {
                        added.addConfiguredAttribute(new Manifest.Attribute("Bundle-RequiredExecutionEnvironment", "J2SE-" + javaDep));
                    } else {
                        added.addConfiguredAttribute(new Manifest.Attribute("Bundle-RequiredExecutionEnvironment", "JavaSE-" + javaDep));
                    }
                } else {
                    added.addConfiguredAttribute(new Manifest.Attribute("OpenIDE-Module-Java-Dependencies", "Java > " + javaDep));
                }
            }
            if ((buildNumber = this.getProject().getProperty("buildnumber")) == null) {
                throw new BuildException("Must have defined 'buildnumber'", this.getLocation());
            }
            String attrToAdd = implVers != null ? "OpenIDE-Module-Build-Version" : "OpenIDE-Module-Implementation-Version";
            added.addConfiguredAttribute(new Manifest.Attribute(attrToAdd, buildNumber));
            String specVersBase = this.getProject().getProperty("spec.version.base");
            if (specVersBase != null) {
                String versionTag;
                boolean edited = false;
                if (implVers != null) {
                    try {
                        JarWithModuleAttributes.parseInt(implVers);
                        specVersBase = specVersBase + "." + implVers;
                        edited = true;
                    }
                    catch (NumberFormatException e) {
                        this.specVersBaseWarning(manifestFile, "use of spec.version.base with non-integer OpenIDE-Module-Implementation-Version");
                    }
                }
                TreeMap<String, Integer> additions = new TreeMap<String, Integer>();
                if (moduleDeps != null) {
                    for (String individualDep : COMMA_SPACE.split(moduleDeps)) {
                        Matcher m = IMPL_DEP.matcher(individualDep);
                        if (!m.matches()) continue;
                        String cnb = m.group(1);
                        String version = m.group(3);
                        try {
                            additions.put(cnb, JarWithModuleAttributes.parseInt(version));
                        }
                        catch (NumberFormatException e) {
                            this.specVersBaseWarning(manifestFile, "use of spec.version.base with non-integer OpenIDE-Module-Implementation-Version from " + cnb);
                        }
                    }
                }
                Iterator i$ = additions.values().iterator();
                while (i$.hasNext()) {
                    int version = (Integer)i$.next();
                    specVersBase = specVersBase + "." + version;
                    edited = true;
                }
                String string = versionTag = isOSGiMode ? "Bundle-Version" : "OpenIDE-Module-Specification-Version";
                if (edited) {
                    this.log("Computed " + versionTag + ": " + specVersBase);
                } else {
                    this.specVersBaseWarning(manifestFile, "using spec.version.base for no reason; could just use " + versionTag + " statically in the manifest");
                }
                if (staticManifest.getMainSection().getAttributeValue(versionTag) != null) {
                    this.specVersBaseWarning(manifestFile, "attempting to use spec.version.base while some " + versionTag + " is statically defined in manifest.mf; this cannot work");
                } else {
                    added.addConfiguredAttribute(new Manifest.Attribute(versionTag, specVersBase));
                }
            } else if (moduleDeps != null && moduleDeps.indexOf(61) != -1) {
                this.specVersBaseWarning(manifestFile, "not using spec.version.base, yet declaring implementation dependencies; may lead to problems with Auto Update");
            } else if (implVers != null) {
                if (specVersBase == null) {
                    this.specVersBaseWarning(manifestFile, "not using spec.version.base, yet declaring implementation version; may lead to problems with Auto Update");
                } else {
                    try {
                        JarWithModuleAttributes.parseInt(implVers);
                    }
                    catch (NumberFormatException e) {
                        this.specVersBaseWarning(manifestFile, "use of non-integer OpenIDE-Module-Implementation-Version may be problematic for clients trying to use spec.version.base");
                    }
                }
            }
            if (isOSGiMode && added.getMainSection().getAttribute("Bundle-Version") == null && specVer != null) {
                added.getMainSection().addConfiguredAttribute(new Manifest.Attribute("Bundle-Version", specVer));
            }
            boolean old = false;
            String destDir = this.getProject().getProperty("netbeans.dest.dir");
            if (destDir != null) {
                for (File cluster : this.getProject().resolveFile(destDir).listFiles()) {
                    if (!new File(cluster, "modules/org-netbeans-modules-autoupdate.jar").isFile()) continue;
                    old = true;
                    break;
                }
            }
            if (!old) {
                added.addConfiguredAttribute(new Manifest.Attribute("AutoUpdate-Show-In-Client", Boolean.toString(!Project.toBoolean((String)this.getProject().getProperty("is.autoload")) && !Project.toBoolean((String)this.getProject().getProperty("is.eager")) && "modules".equals(this.getProject().getProperty("module.jar.dir")))));
            }
            added.merge(staticManifest);
            if (!"lib".equals(this.getProject().getProperty("module.jar.dir")) && !isOSGiMode) {
                String newRequires;
                String key = "OpenIDE-Module-Requires";
                String token = "org.openide.modules.ModuleFormat1";
                String requires = staticManifest.getMainSection().getAttributeValue(key);
                if (requires != null) {
                    added.getMainSection().removeAttribute(key);
                    newRequires = requires + ", " + token;
                } else {
                    newRequires = token;
                }
                added.addConfiguredAttribute(new Manifest.Attribute(key, newRequires));
            }
            this.addConfiguredManifest(added);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }

    private int[] parseDecimal(String trim, int max) {
        String[] segments = trim.split("\\.");
        int[] arr = new int[segments.length > max ? max : segments.length];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = JarWithModuleAttributes.parseInt(segments[i]);
        }
        return arr;
    }

    private static int parseInt(String v) throws NumberFormatException {
        if (!v.matches("0|[1-9][0-9]*")) {
            throw new NumberFormatException(v);
        }
        return Integer.parseInt(v);
    }

    private void specVersBaseWarning(File manifestFile, String message) throws BuildException {
        message = manifestFile + ": " + message + "\n(see http://wiki.netbeans.org/DevFaqImplementationDependency)" + "\n(define spec.version.base.fatal.warning=false in project.properties to make this be a nonfatal warning)";
        if (Project.toBoolean((String)this.getProject().getProperty("spec.version.base.fatal.warning"))) {
            throw new BuildException(message);
        }
        this.log(message, 1);
    }

    public void execute() throws BuildException {
        super.execute();
        if (this.stamp != null) {
            this.log("Stamp " + this.stamp + " against " + this.zipFile, 4);
            if (this.stamp.lastModified() < this.zipFile.lastModified()) {
                try {
                    this.stamp.getParentFile().mkdirs();
                    this.stamp.createNewFile();
                    this.stamp.setLastModified(this.zipFile.lastModified());
                }
                catch (IOException ex) {
                    throw new BuildException((Throwable)ex);
                }
            }
        }
    }
}

