/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ProfilerControlPanel2;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.heapwalk.HeapWalkerManager;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.TriggeredTakeSnapshotProfilingPoint;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.TakeSnapshotCustomizer;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public final class TakeSnapshotProfilingPoint
extends CodeProfilingPoint.Single
implements PropertyChangeListener {
    private static final String NO_DATA_AVAILABLE_MSG = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_NoDataAvailableMsg");
    private static final String NO_DATA_REMOTE_MSG = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_RemoteUnsupportedMsg");
    private static final String NO_DATA_JDK_MSG = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_NoDataJdkMsg");
    private static final String ONE_HIT_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_OneHitString");
    private static final String N_HITS_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_NHitsString");
    private static final String NO_RESULTS_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_NoResultsString");
    private static final String REPORT_ACCESS_DESCR = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_ReportAccessDescr");
    private static final String NO_HITS_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_NoHitsString");
    private static final String HEADER_TYPE_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_HeaderTypeString");
    private static final String HEADER_ENABLED_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_HeaderEnabledString");
    private static final String HEADER_PROJECT_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_HeaderProjectString");
    private static final String HEADER_LOCATION_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_HeaderLocationString");
    private static final String HEADER_MODE_DATA_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_HeaderModeDataString");
    private static final String HEADER_MODE_DUMP_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_HeaderModeDumpString");
    private static final String HEADER_TARGET_PROJECT_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_HeaderTargetProjectString");
    private static final String HEADER_TARGET_CUSTOM_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_HeaderTargetCustomString");
    private static final String HEADER_RESET_RESULTS_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_HeaderResetResultsString");
    private static final String HEADER_HITS_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_HeaderHitsString");
    private static final String OPEN_SNAPSHOT_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_OpenSnapshotString");
    private static final String HIT_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_HitString");
    private static final String SNAPSHOT_NOT_AVAILABLE_MSG = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_SnapshotNotAvailableMsg");
    private static final String DATA_STRING = NbBundle.getMessage(TakeSnapshotProfilingPoint.class, (String)"TakeSnapshotProfilingPoint_DataString");
    static final String PROPERTY_TYPE = "p_snapshot";
    public static final String TYPE_PROFDATA_KEY = "profdata";
    public static final String TYPE_HEAPDUMP_KEY = "heapdump";
    static final String PROPERTY_TARGET = "p_target";
    public static final String TARGET_PROJECT_KEY = "project";
    public static final String TARGET_CUSTOM_KEY = "custom";
    static final String PROPERTY_CUSTOM_FILE = "p_file";
    static final String PROPERTY_RESET_RESULTS = "p_reset_results";
    private static final String SNAPSHOT_LOCATION_URLMASK = "file:";
    private static final String ANNOTATION_ENABLED = "takeSnapshotProfilingPoint";
    private static final String ANNOTATION_DISABLED = "takeSnapshotProfilingPointD";
    private Annotation annotation;
    private List<Result> results = new ArrayList<Result>();
    private final Object resultsSync = new Object();
    private String snapshotFile = System.getProperty("java.io.tmpdir");
    private String snapshotTarget = "project";
    private String snapshotType = "profdata";
    private WeakReference<Report> reportReference;
    private boolean resetResults = false;

    public TakeSnapshotProfilingPoint(String string, CodeProfilingPoint.Location location, Project project, ProfilingPointFactory profilingPointFactory) {
        super(string, location, project, profilingPointFactory);
        this.getChangeSupport().addPropertyChangeListener(this);
    }

    public void setResetResults(boolean bl) {
        if (this.resetResults == bl) {
            return;
        }
        this.resetResults = bl;
        this.getChangeSupport().firePropertyChange(PROPERTY_RESET_RESULTS, !this.resetResults, this.resetResults);
    }

    public boolean getResetResults() {
        return this.resetResults;
    }

    public void setSnapshotFile(String string) {
        if (string == null || !new File(string).exists()) {
            return;
        }
        if (this.snapshotFile != null && new File(this.snapshotFile).equals(new File(string))) {
            return;
        }
        String string2 = this.snapshotFile;
        this.snapshotFile = string;
        this.getChangeSupport().firePropertyChange(PROPERTY_CUSTOM_FILE, string2, string);
    }

    public String getSnapshotFile() {
        return this.snapshotFile;
    }

    public void setSnapshotTarget(String string) {
        if (!string.equals(TARGET_PROJECT_KEY) && !string.equals(TARGET_CUSTOM_KEY)) {
            throw new IllegalArgumentException("Invalid snapshot target category: " + string);
        }
        if (this.snapshotTarget.equals(string)) {
            return;
        }
        String string2 = this.snapshotTarget;
        this.snapshotTarget = string;
        this.getChangeSupport().firePropertyChange(PROPERTY_TARGET, string2, string);
    }

    public String getSnapshotTarget() {
        return this.snapshotTarget;
    }

    public void setSnapshotType(String string) {
        if (string == null || !string.equals(TYPE_PROFDATA_KEY) && !string.equals(TYPE_HEAPDUMP_KEY)) {
            throw new IllegalArgumentException("Invalid snapshot type: " + string);
        }
        if (this.snapshotType.equals(string)) {
            return;
        }
        String string2 = this.snapshotType;
        this.snapshotType = string;
        this.getChangeSupport().firePropertyChange(PROPERTY_TYPE, string2, string);
    }

    public String getSnapshotType() {
        return this.snapshotType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasResults() {
        Object object = this.resultsSync;
        synchronized (object) {
            return !this.results.isEmpty();
        }
    }

    @Override
    public void hideResults() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (TakeSnapshotProfilingPoint.this.hasReport()) {
                    TakeSnapshotProfilingPoint.this.getReport().close();
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.hasReport()) {
            if (propertyChangeEvent.getPropertyName() == "p_name") {
                this.getReport().refreshProperties();
            }
            this.getReport().refreshData();
        }
    }

    @Override
    public void showResults(URL uRL) {
        Report report = this.getReport();
        report.open();
        report.requestActive();
    }

    @Override
    protected CodeProfilingPoint.Annotation getAnnotation() {
        if (this.annotation == null) {
            this.annotation = new Annotation();
        }
        return this.annotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getResultsText() {
        Object object = this.resultsSync;
        synchronized (object) {
            if (this.hasResults()) {
                int n = this.results.size();
                return this.results.size() == 1 ? MessageFormat.format(ONE_HIT_STRING, Utils.formatProfilingPointTime(this.results.get(this.results.size() - 1).getTimestamp())) : MessageFormat.format(N_HITS_STRING, this.results.size(), Utils.formatProfilingPointTime(this.results.get(this.results.size() - 1).getTimestamp()));
            }
            return NO_RESULTS_STRING;
        }
    }

    @Override
    protected void updateCustomizer(ValidityAwarePanel validityAwarePanel) {
        TakeSnapshotCustomizer takeSnapshotCustomizer = (TakeSnapshotCustomizer)validityAwarePanel;
        takeSnapshotCustomizer.setPPName(this.getName());
        takeSnapshotCustomizer.setPPLocation(this.getLocation());
        takeSnapshotCustomizer.setPPType(TYPE_PROFDATA_KEY.equals(this.getSnapshotType()));
        takeSnapshotCustomizer.setPPTarget(TARGET_PROJECT_KEY.equals(this.getSnapshotTarget()));
        takeSnapshotCustomizer.setPPFile(this.getSnapshotFile());
        takeSnapshotCustomizer.setPPResetResults(this.getResetResults());
    }

    @Override
    String getServerHandlerClassName() {
        if (this.getSnapshotType().equals(TYPE_HEAPDUMP_KEY)) {
            return "org.netbeans.lib.profiler.server.TakeHeapdumpProfilingPointHandler";
        }
        if (this.getResetResults()) {
            return "org.netbeans.lib.profiler.server.TakeSnapshotWithResetProfilingPointHandler";
        }
        return "org.netbeans.lib.profiler.server.TakeSnapshotProfilingPointHandler";
    }

    @Override
    String getServerInfo() {
        if (this.getSnapshotType().equals(TYPE_HEAPDUMP_KEY)) {
            try {
                return FileUtil.toFile((FileObject)this.getSnapshotDirectory()).getAbsolutePath();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(65536, (Throwable)iOException);
            }
        }
        return null;
    }

    FileObject getSnapshotDirectory() throws IOException {
        if (this.snapshotTarget.equals(TARGET_PROJECT_KEY)) {
            return IDEUtils.getProjectSettingsFolder(this.getProject(), true);
        }
        File file = new File(this.snapshotFile);
        file.mkdirs();
        return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
    }

    @Override
    void setValues(ValidityAwarePanel validityAwarePanel) {
        TakeSnapshotCustomizer takeSnapshotCustomizer = (TakeSnapshotCustomizer)validityAwarePanel;
        this.setName(takeSnapshotCustomizer.getPPName());
        this.setLocation(takeSnapshotCustomizer.getPPLocation());
        this.setSnapshotType(takeSnapshotCustomizer.getPPType() ? TYPE_PROFDATA_KEY : TYPE_HEAPDUMP_KEY);
        this.setSnapshotTarget(takeSnapshotCustomizer.getPPTarget() ? TARGET_PROJECT_KEY : TARGET_CUSTOM_KEY);
        this.setSnapshotFile(takeSnapshotCustomizer.getPPFile());
        this.setResetResults(takeSnapshotCustomizer.getPPResetResults());
        Utils.checkLocation(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void hit(RuntimeProfilingPoint.HitEvent hitEvent, int n) {
        String string;
        Object object;
        if (this.snapshotType.equals(TYPE_HEAPDUMP_KEY)) {
            object = Profiler.getDefault().getTargetAppRunner();
            string = object.getProfilingSessionStatus().remoteProfiling ? NO_DATA_REMOTE_MSG : (!object.hasSupportedJDKForHeapDump() ? NO_DATA_JDK_MSG : this.takeHeapdumpHit(hitEvent.getTimestamp()));
        } else {
            string = this.takeSnapshotHit();
        }
        object = this.resultsSync;
        synchronized (object) {
            this.results.add(new Result(hitEvent.getTimestamp(), hitEvent.getThreadId(), string));
        }
        this.getChangeSupport().firePropertyChange("p_results", false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void reset() {
        Object object = this.resultsSync;
        synchronized (object) {
            boolean bl = this.hasResults();
            this.results.clear();
            if (bl) {
                this.getChangeSupport().firePropertyChange("p_results", false, true);
            }
        }
    }

    private Report getReport() {
        if (this.hasReport()) {
            return (Report)((Object)this.reportReference.get());
        }
        Report report = new Report();
        this.reportReference = new WeakReference<Report>(report);
        return report;
    }

    private File constructHeapDumpFile(long l) throws IOException {
        String string = FileUtil.toFile((FileObject)this.getSnapshotDirectory()).getAbsolutePath();
        String string2 = string + File.separatorChar + "heapdump-" + l + "." + "hprof";
        return new File(string2);
    }

    private boolean hasReport() {
        return this.reportReference != null && this.reportReference.get() != null;
    }

    private String takeHeapdumpHit(long l) {
        try {
            File file = this.constructHeapDumpFile(l);
            if (file.exists()) {
                File file2 = this.constructHeapDumpFile(Utils.getTimeInMillis(l));
                file.renameTo(file2);
                ProfilerControlPanel2.getDefault().refreshSnapshotsList();
                return file2.toURI().toURL().toExternalForm();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(65536, (Throwable)iOException);
            return NO_DATA_AVAILABLE_MSG;
        }
        return NO_DATA_AVAILABLE_MSG;
    }

    private static LoadedSnapshot takeSnapshot() throws CPUResultsSnapshot.NoDataAvailableException {
        return ResultsManager.getDefault().prepareSnapshot();
    }

    private String takeSnapshotHit() {
        LoadedSnapshot loadedSnapshot = null;
        String string = null;
        try {
            loadedSnapshot = TakeSnapshotProfilingPoint.takeSnapshot();
        }
        catch (CPUResultsSnapshot.NoDataAvailableException noDataAvailableException) {
            // empty catch block
        }
        if (loadedSnapshot != null) {
            try {
                FileObject fileObject = this.getSnapshotDirectory();
                FileObject fileObject2 = fileObject.createData(ResultsManager.getDefault().getDefaultSnapshotFileName(loadedSnapshot), "nps");
                ResultsManager.getDefault().saveSnapshot(loadedSnapshot, fileObject2);
                string = FileUtil.toFile((FileObject)fileObject2).toURI().toURL().toExternalForm();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(65536, (Throwable)iOException);
            }
        }
        return string == null ? NO_DATA_AVAILABLE_MSG : string;
    }

    private static class Result {
        private final String resultString;
        private final int threadId;
        private final long timestamp;

        public Result(long l, int n, String string) {
            this.timestamp = l;
            this.threadId = n;
            this.resultString = string;
        }

        public String getResultString() {
            return this.resultString;
        }

        public int getThreadID() {
            return this.threadId;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    private class Report
    extends TopComponent {
        private HTMLTextArea dataArea;
        private HTMLTextArea headerArea;

        public Report() {
            this.initDefaults();
            this.initComponents();
            this.refreshData();
        }

        public int getPersistenceType() {
            return 2;
        }

        protected String preferredID() {
            return ((Object)((Object)this)).getClass().getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void refreshData() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getHeaderName());
            stringBuilder.append("<br>");
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilder.append(this.getHeaderType());
            stringBuilder.append("<br>");
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilder.append(this.getHeaderEnabled());
            stringBuilder.append("<br>");
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilder.append(this.getHeaderProject());
            stringBuilder.append("<br>");
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilder.append(this.getHeaderLocation());
            stringBuilder.append("<br>");
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilder.append(this.getHeaderMode());
            stringBuilder.append("<br>");
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilder.append(this.getHeaderTarget());
            stringBuilder.append("<br>");
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilder.append(this.getHeaderResetResults());
            stringBuilder.append("<br>");
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilder.append(this.getHeaderHitsCount());
            this.headerArea.setText(stringBuilder.toString());
            StringBuilder stringBuilder2 = new StringBuilder();
            Object object = TakeSnapshotProfilingPoint.this.resultsSync;
            synchronized (object) {
                if (!TakeSnapshotProfilingPoint.this.hasResults()) {
                    stringBuilder2.append("&nbsp;&nbsp;&lt;" + NO_HITS_STRING + "&gt;");
                } else {
                    for (int i = 0; i < TakeSnapshotProfilingPoint.this.results.size(); ++i) {
                        stringBuilder2.append("&nbsp;&nbsp;");
                        stringBuilder2.append(this.getDataResultItem(i));
                        stringBuilder2.append("<br>");
                    }
                }
            }
            this.dataArea.setText(stringBuilder2.toString());
        }

        void refreshProperties() {
            this.setName(TakeSnapshotProfilingPoint.this.getName());
            this.setIcon(((ImageIcon)TakeSnapshotProfilingPoint.this.getFactory().getIcon()).getImage());
            this.getAccessibleContext().setAccessibleDescription(MessageFormat.format(REPORT_ACCESS_DESCR, this.getName()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getDataResultItem(int n) {
            Object object = TakeSnapshotProfilingPoint.this.resultsSync;
            synchronized (object) {
                Result result = (Result)TakeSnapshotProfilingPoint.this.results.get(n);
                String string = result.getResultString();
                String string2 = string.startsWith(TakeSnapshotProfilingPoint.SNAPSHOT_LOCATION_URLMASK) ? "<a href='" + string + "'>" + OPEN_SNAPSHOT_STRING + "</a>" : string;
                return MessageFormat.format(HIT_STRING, n + 1, Utils.formatProfilingPointTimeHiRes(result.getTimestamp()), string2);
            }
        }

        private String getHeaderEnabled() {
            return MessageFormat.format(HEADER_ENABLED_STRING, TakeSnapshotProfilingPoint.this.isEnabled());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getHeaderHitsCount() {
            Object object = TakeSnapshotProfilingPoint.this.resultsSync;
            synchronized (object) {
                return MessageFormat.format(HEADER_HITS_STRING, TakeSnapshotProfilingPoint.this.results.size());
            }
        }

        private String getHeaderLocation() {
            CodeProfilingPoint.Location location = TakeSnapshotProfilingPoint.this.getLocation();
            String string = new File(location.getFile()).getName();
            int n = location.getLine();
            return MessageFormat.format(HEADER_LOCATION_STRING, string, n);
        }

        private String getHeaderMode() {
            return TakeSnapshotProfilingPoint.this.getSnapshotType().equals(TakeSnapshotProfilingPoint.TYPE_PROFDATA_KEY) ? HEADER_MODE_DATA_STRING : HEADER_MODE_DUMP_STRING;
        }

        private String getHeaderName() {
            return "<h2><b>" + TakeSnapshotProfilingPoint.this.getName() + "</b></h2>";
        }

        private String getHeaderProject() {
            return MessageFormat.format(HEADER_PROJECT_STRING, ProjectUtils.getInformation((Project)TakeSnapshotProfilingPoint.this.getProject()).getDisplayName());
        }

        private String getHeaderResetResults() {
            return MessageFormat.format(HEADER_RESET_RESULTS_STRING, TakeSnapshotProfilingPoint.this.getResetResults());
        }

        private String getHeaderTarget() {
            return TakeSnapshotProfilingPoint.this.getSnapshotTarget().equals(TakeSnapshotProfilingPoint.TARGET_PROJECT_KEY) ? HEADER_TARGET_PROJECT_STRING : MessageFormat.format(HEADER_TARGET_PROJECT_STRING, TakeSnapshotProfilingPoint.this.getSnapshotFile());
        }

        private String getHeaderType() {
            return MessageFormat.format(HEADER_TYPE_STRING, TakeSnapshotProfilingPoint.this.getFactory().getType());
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBackground(UIUtils.getProfilerResultsBackground());
            jPanel.setOpaque(true);
            jPanel.setBorder(BorderFactory.createMatteBorder(0, 15, 15, 15, UIUtils.getProfilerResultsBackground()));
            this.headerArea = new HTMLTextArea(){

                protected void showURL(URL uRL) {
                    Utils.openLocation(TakeSnapshotProfilingPoint.this.getLocation());
                }
            };
            JScrollPane jScrollPane = new JScrollPane((Component)this.headerArea, 20, 30);
            jScrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 15, 0, UIUtils.getProfilerResultsBackground()));
            jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            jPanel.add((Component)jScrollPane, "North");
            this.dataArea = new HTMLTextArea(){

                protected void showURL(URL uRL) {
                    File file = null;
                    try {
                        file = new File(uRL.toURI());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        uRISyntaxException.printStackTrace();
                    }
                    final File file2 = file;
                    if (file2 != null && file2.exists()) {
                        if (TakeSnapshotProfilingPoint.this.getSnapshotType().equals(TakeSnapshotProfilingPoint.TYPE_PROFDATA_KEY)) {
                            File file3 = FileUtil.normalizeFile((File)file2);
                            LoadedSnapshot loadedSnapshot = ResultsManager.getDefault().loadSnapshot(FileUtil.toFileObject((File)file3));
                            ResultsManager.getDefault().openSnapshot(loadedSnapshot);
                        } else if (TakeSnapshotProfilingPoint.this.getSnapshotType().equals(TakeSnapshotProfilingPoint.TYPE_HEAPDUMP_KEY)) {
                            RequestProcessor.getDefault().post(new Runnable(){

                                @Override
                                public void run() {
                                    HeapWalkerManager.getDefault().openHeapWalker(file2);
                                }
                            });
                        }
                    } else {
                        NetBeansProfiler.getDefaultNB().displayWarning(SNAPSHOT_NOT_AVAILABLE_MSG);
                    }
                }
            };
            JScrollPane jScrollPane2 = new JScrollPane((Component)this.dataArea, 20, 30);
            TitledBorder titledBorder = new TitledBorder(DATA_STRING);
            titledBorder.setTitleFont(titledBorder.getTitleFont().deriveFont(1));
            titledBorder.setTitleColor(UIManager.getColor("Label.foreground"));
            jScrollPane2.setBorder(titledBorder);
            jScrollPane2.setViewportBorder(BorderFactory.createEmptyBorder());
            jScrollPane2.setBackground(UIUtils.getProfilerResultsBackground());
            jPanel.add((Component)jScrollPane2, "Center");
            this.add(jPanel, "Center");
        }

        private void initDefaults() {
            this.refreshProperties();
            this.setFocusable(true);
        }
    }

    private class Annotation
    extends CodeProfilingPoint.Annotation {
        private Annotation() {
        }

        @Override
        public String getAnnotationType() {
            return TakeSnapshotProfilingPoint.this.isEnabled() ? TakeSnapshotProfilingPoint.ANNOTATION_ENABLED : TakeSnapshotProfilingPoint.ANNOTATION_DISABLED;
        }

        @Override
        public String getShortDescription() {
            return TakeSnapshotProfilingPoint.this.getName();
        }
    }
}

