/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.fixes;

import java.io.IOException;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.websvc.editor.hints.common.Utilities;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class RemoveAnnotation
implements Fix {
    private FileObject fileObject;
    private Element element;
    private AnnotationMirror annMirror;

    public RemoveAnnotation(FileObject fileObject, Element element, AnnotationMirror annotationMirror) {
        this.element = element;
        this.fileObject = fileObject;
        this.annMirror = annotationMirror;
    }

    public ChangeInfo implement() {
        CancellableTask<WorkingCopy> cancellableTask = new CancellableTask<WorkingCopy>(){

            public void cancel() {
            }

            public void run(WorkingCopy workingCopy) throws Exception {
                Utilities.removeAnnotation(workingCopy, RemoveAnnotation.this.element, RemoveAnnotation.this.annMirror);
            }
        };
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
        try {
            javaSource.runModificationTask((Task)cancellableTask).commit();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public String getText() {
        String string = this.annMirror.getAnnotationType().asElement().getSimpleName().toString();
        return NbBundle.getMessage(RemoveAnnotation.class, (String)"LBL_RemoveAnnotation", (Object)string);
    }
}

