/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.KeyStroke;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.spi.model.services.FunctionCallsProvider;
import org.netbeans.spi.debugger.ui.MethodChooser;
import org.openide.text.Annotation;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class MethodChooserSupport
implements PropertyChangeListener {
    private final GdbDebugger debugger;
    private final String url;
    private MethodChooser chooser;
    ArrayList<Annotation> annotations;
    private int selectedIndex = -1;
    private CsmReference[] refs;

    MethodChooserSupport(GdbDebugger debugger, String url) {
        this.debugger = debugger;
        this.url = url;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public MethodChooser.Segment[] getSegments() {
        MethodChooser.Segment[] segments = new MethodChooser.Segment[this.refs.length];
        for (int x = 0; x < segments.length; ++x) {
            int start = this.refs[x].getStartOffset();
            int end = this.refs[x].getEndOffset();
            segments[x] = new MethodChooser.Segment(start, end);
        }
        return segments;
    }

    public int getSegmentsCount() {
        return this.refs.length;
    }

    public String getHint() {
        return NbBundle.getMessage(MethodChooserSupport.class, (String)"MSG_RunIntoMethod_Status_Line_Help");
    }

    public KeyStroke[] getStopEvents() {
        return new KeyStroke[]{KeyStroke.getKeyStroke(119, 0), KeyStroke.getKeyStroke(118, 64), KeyStroke.getKeyStroke(118, 128)};
    }

    public KeyStroke[] getConfirmEvents() {
        return new KeyStroke[]{KeyStroke.getKeyStroke(118, 0)};
    }

    public MethodChooser createChooser() {
        return new MethodChooser(this.url, this.getSegments(), this.selectedIndex, this.getHint(), this.getStopEvents(), this.getConfirmEvents());
    }

    public void tearUp(MethodChooser selector) {
        this.chooser = selector;
        this.debugger.addPropertyChangeListener(this);
        this.annotateLines();
    }

    public void tearDown() {
        this.debugger.removePropertyChangeListener(this);
        this.clearAnnotations();
    }

    public void doStepInto() {
        final CsmReference ref = this.refs[this.chooser.getSelectedIndex()];
        this.debugger.getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                CsmObject referencedObject = ref.getReferencedObject();
                if (CsmKindUtilities.isFunction((CsmObject)referencedObject)) {
                    MethodChooserSupport.this.debugger.until((CsmFunction)referencedObject);
                }
            }
        });
    }

    public boolean init() {
        this.refs = new CsmReference[0];
        FunctionCallsProvider fcProvider = (FunctionCallsProvider)Lookup.getDefault().lookup(FunctionCallsProvider.class);
        if (fcProvider == null) {
            this.debugger.stepInto();
            return true;
        }
        List functionCallsList = fcProvider.getFunctionCalls(this.debugger.getCurrentCallStackFrame().getDocument(), this.debugger.getCurrentCallStackFrame().getLineNumber() - 1);
        this.refs = functionCallsList.toArray(new CsmReference[functionCallsList.size()]);
        this.selectedIndex = 0;
        if (this.refs.length == 0) {
            this.debugger.stepInto();
            return true;
        }
        if (this.refs.length == 1) {
            this.debugger.stepInto();
            return true;
        }
        return false;
    }

    private void annotateLines() {
    }

    private void clearAnnotations() {
        if (this.annotations != null) {
            for (Annotation anno : this.annotations) {
                anno.detach();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.debugger.getState() == GdbDebugger.State.EXITED) {
            this.chooser.releaseUI(false);
        }
    }
}

