/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.actions;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.modules.cnd.debugger.common.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.gdb.GdbCallStackFrame;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.actions.GdbDebuggerActionProvider;
import org.netbeans.modules.cnd.debugger.gdb.actions.MethodChooserSupport;
import org.netbeans.modules.cnd.debugger.gdb.disassembly.Disassembly;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.MethodChooser;

public class StepActionProvider
extends GdbDebuggerActionProvider {
    private MethodChooser currentMethodChooser;
    private final Set<Object> actions = new HashSet<Object>(Arrays.asList(ActionsManager.ACTION_STEP_INTO, ActionsManager.ACTION_STEP_OUT, ActionsManager.ACTION_STEP_OVER, ActionsManager.ACTION_CONTINUE, ActionsManager.ACTION_RUN_TO_CURSOR));

    public StepActionProvider(ContextProvider lookupProvider) {
        super(lookupProvider);
        this.setProviderToDisableOnLazyAction(this);
    }

    public Set getActions() {
        return this.actions;
    }

    public void doAction(Object action) {
        this.runAction(action);
    }

    public void runAction(Object action) {
        if (action == ActionsManager.ACTION_STEP_INTO) {
            if (Disassembly.isInDisasm()) {
                this.getDebugger().stepI();
            } else {
                this.doSmartStepInto();
            }
            return;
        }
        if (action == ActionsManager.ACTION_STEP_OUT) {
            this.getDebugger().stepOut();
            return;
        }
        if (action == ActionsManager.ACTION_STEP_OVER) {
            if (Disassembly.isInDisasm()) {
                this.getDebugger().stepOverInstr();
            } else {
                this.getDebugger().stepOver();
            }
            return;
        }
        if (action == ActionsManager.ACTION_CONTINUE) {
            this.getDebugger().resume();
            return;
        }
        if (action == ActionsManager.ACTION_RUN_TO_CURSOR) {
            this.getDebugger().runToCursor();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSmartStepInto() {
        StepActionProvider stepActionProvider = this;
        synchronized (stepActionProvider) {
            if (this.currentMethodChooser != null) {
                this.currentMethodChooser.releaseUI(true);
                return;
            }
        }
        String url = EditorContextBridge.getContext().getCurrentURL();
        final MethodChooserSupport cSupport = new MethodChooserSupport(this.getDebugger(), url);
        boolean continuedDirectly = cSupport.init();
        if (cSupport.getSegmentsCount() == 0) {
            return;
        }
        if (continuedDirectly) {
            return;
        }
        MethodChooser.ReleaseListener releaseListener = new MethodChooser.ReleaseListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void released(boolean performAction) {
                StepActionProvider stepActionProvider = StepActionProvider.this;
                synchronized (stepActionProvider) {
                    StepActionProvider.this.currentMethodChooser = null;
                    cSupport.tearDown();
                    if (performAction) {
                        cSupport.doStepInto();
                    }
                }
            }
        };
        MethodChooser chooser = cSupport.createChooser();
        chooser.addReleaseListener(releaseListener);
        boolean success = chooser.showUI();
        if (success && chooser.isUIActive()) {
            StepActionProvider stepActionProvider2 = this;
            synchronized (stepActionProvider2) {
                cSupport.tearUp(chooser);
                this.currentMethodChooser = chooser;
            }
        } else {
            chooser.removeReleaseListener(releaseListener);
        }
    }

    public void postAction(final Object action, final Runnable actionPerformedNotifier) {
        this.doLazyAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    StepActionProvider.this.runAction(action);
                }
                finally {
                    actionPerformedNotifier.run();
                }
            }
        });
    }

    @Override
    protected void checkEnabled(GdbDebugger.State debuggerState) {
        boolean enabled = debuggerState == GdbDebugger.State.STOPPED;
        for (Object action : this.getActions()) {
            if (action == ActionsManager.ACTION_STEP_OUT) {
                this.setEnabled(action, enabled && this.isStepOutValid());
                continue;
            }
            this.setEnabled(action, enabled);
        }
    }

    private boolean isStepOutValid() {
        List<GdbCallStackFrame> callstack = this.getDebugger().getCallStack();
        return callstack.size() == 1 || callstack.size() > 1 && callstack.get(1).isValid();
    }
}

