/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.bnf;

import java.util.HashMap;
import org.h2.test.bnf.Config;
import org.h2.test.bnf.Rule;
import org.h2.test.bnf.RuleHead;

public class RuleElement
implements Rule {
    private boolean keyword;
    private String name;
    private Rule link;

    public RuleElement(String name) {
        this.name = name;
        if (name.length() == 1 || name.equals(name.toUpperCase())) {
            this.keyword = true;
        }
    }

    public String random(Config config, int level) {
        if (this.keyword) {
            return this.name.length() > 1 ? " " + this.name + " " : this.name;
        }
        if (this.link != null) {
            return this.link.random(config, level + 1);
        }
        throw new Error(">>>" + this.name + "<<<");
    }

    public String name() {
        return this.name;
    }

    public Rule last() {
        return this;
    }

    public void setLinks(HashMap ruleMap) {
        if (this.link != null) {
            this.link.setLinks(ruleMap);
        }
        if (this.keyword) {
            return;
        }
        for (int i = 0; i < this.name.length() && this.link == null; ++i) {
            String test = this.name.substring(i).toLowerCase();
            RuleHead r = (RuleHead)ruleMap.get(test);
            if (r == null) continue;
            this.link = r.rule;
            return;
        }
        if (this.link == null) {
            throw new Error(">>>" + this.name + "<<<");
        }
    }
}

