/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.expression.Expression;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.store.UndoLogRecord;
import org.h2.table.Column;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.value.Value;

public class Update
extends Prepared {
    private Expression condition;
    private TableFilter tableFilter;
    private Expression[] expressions;

    public Update(Parser parser) {
        super(parser);
    }

    public void setTableFilter(TableFilter tableFilter) {
        this.tableFilter = tableFilter;
        Table table = tableFilter.getTable();
        this.expressions = new Expression[table.getColumns().length];
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    public void setAssignment(Column column, Expression expression) throws SQLException {
        int id = column.getColumnId();
        if (this.expressions[id] != null) {
            throw Message.getSQLException(42121, column.getName());
        }
        this.expressions[id] = expression;
    }

    public int update() throws SQLException {
        int i;
        this.tableFilter.startQuery();
        this.tableFilter.reset();
        ObjectArray oldRows = new ObjectArray();
        ObjectArray newRows = new ObjectArray();
        Table table = this.tableFilter.getTable();
        this.session.getUser().checkRight(table, 8);
        table.fireBefore(this.session);
        table.lock(this.session, true);
        int columnCount = table.getColumns().length;
        while (this.tableFilter.next()) {
            this.checkCancelled();
            this.session.setCurrentRowNumber(oldRows.size() + 1);
            if (this.condition != null && !Boolean.TRUE.equals(this.condition.getBooleanValue(this.session))) continue;
            Row oldRow = this.tableFilter.get();
            oldRows.add(oldRow);
            Row newRow = table.getTemplateRow();
            for (int i2 = 0; i2 < columnCount; ++i2) {
                Value newValue;
                Expression newExpr = this.expressions[i2];
                if (newExpr == null) {
                    newValue = oldRow.getValue(i2);
                } else {
                    Column column = table.getColumn(i2);
                    newValue = newExpr.getValue(this.session).convertTo(column.getType());
                }
                newRow.setValue(i2, newValue);
            }
            table.validateConvertUpdateSequence(this.session, newRow);
            table.fireBeforeRow(this.session, oldRow, newRow);
            newRows.add(newRow);
        }
        for (i = 0; i < oldRows.size(); ++i) {
            this.checkCancelled();
            Row o = (Row)oldRows.get(i);
            table.removeRow(this.session, o);
            this.session.log(new UndoLogRecord(table, 1, o));
        }
        for (i = 0; i < newRows.size(); ++i) {
            this.checkCancelled();
            Row n = (Row)newRows.get(i);
            table.addRow(this.session, n);
            this.session.log(new UndoLogRecord(table, 0, n));
            Row o = (Row)oldRows.get(i);
            table.fireAfterRow(this.session, o, n);
        }
        table.fireAfter(this.session);
        return newRows.size();
    }

    public String getPlan() {
        StringBuffer buff = new StringBuffer();
        buff.append("UPDATE ");
        buff.append(this.tableFilter.getSQL(false));
        buff.append(" SET ");
        Table table = this.tableFilter.getTable();
        int columnCount = table.getColumns().length;
        int j = 0;
        for (int i = 0; i < columnCount; ++i) {
            Expression newExpr = this.expressions[i];
            if (newExpr == null) continue;
            if (j > 0) {
                buff.append(", ");
            }
            ++j;
            Column column = table.getColumn(i);
            buff.append(column.getName());
            buff.append(" = ");
            buff.append(StringUtils.unEnclose(newExpr.getSQL()));
        }
        if (this.condition != null) {
            buff.append(" WHERE " + StringUtils.unEnclose(this.condition.getSQL()));
        }
        return buff.toString();
    }

    public void prepare() throws SQLException {
        if (this.condition != null) {
            this.condition.mapColumns(this.tableFilter, 0);
            this.condition = this.condition.optimize(this.session);
            this.condition.createIndexConditions(this.tableFilter);
        }
        for (int i = 0; i < this.expressions.length; ++i) {
            Expression expr = this.expressions[i];
            if (expr == null) continue;
            expr.mapColumns(this.tableFilter, 0);
            this.expressions[i] = expr.optimize(this.session);
        }
        PlanItem item = this.tableFilter.getBestPlanItem(this.session);
        this.tableFilter.setPlanItem(item);
        this.tableFilter.prepare();
    }

    public boolean isTransactional() {
        return true;
    }
}

