/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test;

import java.io.File;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.h2.jdbc.JdbcConnection;
import org.h2.test.TestAll;
import org.h2.tools.DeleteDbFiles;

public abstract class TestBase {
    protected static String BASE_DIR = "data";
    protected TestAll config;
    private long start;

    protected void startServerIfRequired() {
        this.config.startServerIfRequired();
    }

    protected void stopServerIfRequired() {
        this.config.stopServerIfRequired();
    }

    public void runTest(TestAll conf) {
        block2: {
            this.config = conf;
            try {
                this.start = System.currentTimeMillis();
                this.print("start", "\r");
                this.test();
                this.println("done ");
            }
            catch (Exception e) {
                this.println("FAIL " + e.toString());
                e.printStackTrace();
                if (!this.config.stopOnError) break block2;
                throw new Error("ERROR");
            }
        }
    }

    public Connection getConnection(String name) throws Exception {
        return this.getConnectionInternal(this.getURL(name, true), this.getUser(), this.getPassword());
    }

    protected Connection getConnection(String name, String user, String password) throws Exception {
        return this.getConnectionInternal(this.getURL(name, false), user, password);
    }

    protected String getPassword() {
        return "123";
    }

    private void deleteIndexFiles(String name) throws SQLException {
        if (name.indexOf(";") > 0) {
            name = name.substring(0, name.indexOf(59));
        }
        if (new File(name = name + ".index.db").canWrite()) {
            new File(name).delete();
        }
    }

    protected String getURL(String name, boolean admin) throws SQLException {
        String url;
        if (name.startsWith("jdbc:")) {
            return name;
        }
        if (this.config.memory) {
            url = "mem:" + name;
        } else {
            if (!name.startsWith("inmemory:") && !name.startsWith(BASE_DIR + "/")) {
                name = BASE_DIR + "/" + name;
            }
            if (this.config.deleteIndex) {
                this.deleteIndexFiles(name);
            }
            url = this.config.networked ? (this.config.ssl ? "ssl://localhost:9092/" + name : "tcp://localhost:9092/" + name) : name;
            if (this.config.traceSystemOut) {
                url = url + ";TRACE_LEVEL_SYSTEM_OUT=2";
            }
            if (this.config.traceLevelFile > 0 && admin) {
                url = url + ";TRACE_LEVEL_FILE=" + this.config.traceLevelFile;
            }
        }
        if (this.config.throttle > 0) {
            url = url + ";THROTTLE=" + this.config.throttle;
        }
        if (this.config.textStorage) {
            url = url + ";STORAGE=TEXT";
        }
        url = url + ";LOCK_TIMEOUT=50";
        if (admin) {
            url = url + ";LOG=" + this.config.logMode;
        }
        if (this.config.smallLog && admin) {
            url = url + ";MAX_LOG_SIZE=1";
        }
        if (this.config.diskResult && admin) {
            url = url + ";MAX_MEMORY_ROWS=100;CACHE_SIZE=1000";
        }
        return "jdbc:h2:" + url;
    }

    private Connection getConnectionInternal(String url, String user, String password) throws Exception {
        Connection conn;
        Class.forName("org.h2.Driver");
        if (this.config.cipher != null) {
            url = url + ";cipher=" + this.config.cipher;
            password = "filePassword " + password;
            Properties info = new Properties();
            info.setProperty("user", user);
            info.put("password", password.toCharArray());
            conn = DriverManager.getConnection(url, info);
        } else {
            conn = DriverManager.getConnection(url, user, password);
        }
        return conn;
    }

    protected int getSize(int small, int big) throws Exception {
        return this.config.big ? big : small;
    }

    protected String getUser() {
        return "sa";
    }

    protected void trace(int x) {
        this.trace("" + x);
    }

    public void trace(String s) {
        if (this.config.traceTest) {
            this.println(s);
        }
    }

    protected void traceMemory() {
        if (this.config.traceTest) {
            this.trace("mem=" + TestBase.getMemoryUsed());
        }
    }

    public void printTimeMemory(String s, long time) {
        if (this.config.big) {
            this.println(time + " ms; " + TestBase.getMemoryUsed() + " MB: " + s);
        }
    }

    public static int getMemoryUsed() {
        Runtime rt = Runtime.getRuntime();
        long memory = Long.MAX_VALUE;
        while (true) {
            rt.gc();
            long memNow = rt.totalMemory() - rt.freeMemory();
            if (memNow == memory) break;
            memory = memNow;
        }
        int mb = (int)(memory / 1024L / 1024L);
        return mb;
    }

    protected void error(String string) throws Exception {
        this.println(string);
        throw new Exception(string);
    }

    protected void println(String s) {
        this.print(s, "\n");
    }

    private void print(String s, String end) {
        long time = System.currentTimeMillis() - this.start;
        String t = "          " + time;
        t = t.substring(t.length() - 6);
        System.out.print(s + " (" + t + " ms) " + this.getClass().getName() + end);
    }

    protected static void printTime(String s) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println(sdf.format(new Date()) + " " + s);
    }

    protected void deleteDb(String name) throws Exception {
        new DeleteDbFiles().processFiles(BASE_DIR, name, false);
    }

    protected void deleteDb(String dir, String name) throws Exception {
        new DeleteDbFiles().processFiles(dir, name, false);
    }

    public abstract void test() throws Exception;

    void check(int a, int b) throws Exception {
        if (a != b) {
            this.error("int a: " + a + " b: " + b);
        }
    }

    protected void check(byte[] a, byte[] b) throws Exception {
        this.check(a.length == b.length);
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            this.error("byte[" + i + "]: a=" + a[i] + " b=" + b[i]);
        }
    }

    protected void check(String a, String b) throws Exception {
        if (a == null && b == null) {
            return;
        }
        if (!a.equals(b)) {
            for (int i = 0; i < a.length(); ++i) {
                String s = a.substring(0, i);
                if (b.startsWith(s)) continue;
                s = s.substring(0, i) + "<*>" + s.substring(i);
                break;
            }
            this.error("string a: " + a + " (" + a.length() + ") b: " + b + " (" + b.length() + ")");
        }
    }

    protected void checkFalse(String a, String b) throws Exception {
        if (a.equals(b)) {
            this.error("string false a: " + a + " b: " + b);
        }
    }

    protected void check(long a, long b) throws Exception {
        if (a != b) {
            this.error("long a: " + a + " b: " + b);
        }
    }

    protected void checkSmaller(long a, long b) throws Exception {
        if (a >= b) {
            this.error("a: " + a + " is not smaller than b: " + b);
        }
    }

    protected void check(double a, double b) throws Exception {
        if (a != b) {
            this.error("double a: " + a + " b: " + b);
        }
    }

    protected void check(float a, float b) throws Exception {
        if (a != b) {
            this.error("float a: " + a + " b: " + b);
        }
    }

    protected void check(boolean a, boolean b) throws Exception {
        if (a != b) {
            this.error("boolean a: " + a + " b: " + b);
        }
    }

    protected void check(boolean value) throws Exception {
        if (!value) {
            this.error("expected: true got: false");
        }
    }

    protected void checkFalse(boolean value) throws Exception {
        if (value) {
            this.error("expected: false got: true");
        }
    }

    protected void checkResultRowCount(ResultSet rs, int expected) throws Exception {
        int i = 0;
        while (rs.next()) {
            ++i;
        }
        this.check(i, expected);
    }

    protected void testResultSetMeta(ResultSet rs, int columncount, String[] labels, int[] datatypes, int[] precision, int[] scale) throws Exception {
        ResultSetMetaData meta = rs.getMetaData();
        int cc = meta.getColumnCount();
        if (cc != columncount) {
            this.error("result set contains " + cc + " columns not " + columncount);
        }
        for (int i = 0; i < columncount; ++i) {
            int s;
            int p;
            String l;
            if (labels != null && !labels[i].equals(l = meta.getColumnLabel(i + 1))) {
                this.error("column label " + i + " is " + l + " not " + labels[i]);
            }
            if (datatypes != null) {
                int t = meta.getColumnType(i + 1);
                if (datatypes[i] != t) {
                    this.error("column datatype " + i + " is " + t + " not " + datatypes[i] + " (prec=" + meta.getPrecision(i + 1) + " scale=" + meta.getScale(i + 1) + ")");
                }
                String typeName = meta.getColumnTypeName(i + 1);
                String className = meta.getColumnClassName(i + 1);
                switch (t) {
                    case 4: {
                        this.check(typeName, "INTEGER");
                        this.check(className, "java.lang.Integer");
                        break;
                    }
                    case 12: {
                        this.check(typeName, "VARCHAR");
                        this.check(className, "java.lang.String");
                        break;
                    }
                    case 5: {
                        this.check(typeName, "SMALLINT");
                        this.check(className, "java.lang.Short");
                        break;
                    }
                    case 93: {
                        this.check(typeName, "TIMESTAMP");
                        this.check(className, "java.sql.Timestamp");
                        break;
                    }
                    case 3: {
                        this.check(typeName, "DECIMAL");
                        this.check(className, "java.math.BigDecimal");
                    }
                }
            }
            if (precision != null && precision[i] != (p = meta.getPrecision(i + 1))) {
                this.error("column precision " + i + " is " + p + " not " + precision[i]);
            }
            if (scale == null || scale[i] == (s = meta.getScale(i + 1))) continue;
            this.error("column scale " + i + " is " + s + " not " + scale[i]);
        }
    }

    protected void testResultSetOrdered(ResultSet rs, String[][] data) throws Exception {
        this.testResultSet(true, rs, data);
    }

    void testResultSetUnordered(ResultSet rs, String[][] data) throws Exception {
        this.testResultSet(false, rs, data);
    }

    void testResultSet(boolean ordered, ResultSet rs, String[][] data) throws Exception {
        int len2;
        int len = rs.getMetaData().getColumnCount();
        int rows = data.length;
        if (rows == 0 && rs.next()) {
            this.error("testResultSet expected rowcount:" + rows + " got:0");
        }
        if (len < (len2 = data[0].length)) {
            this.error("testResultSet expected columncount:" + len2 + " got:" + len);
        }
        for (int i = 0; i < rows; ++i) {
            if (!rs.next()) {
                this.error("testResultSet expected rowcount:" + rows + " got:" + i);
            }
            String[] row = this.getData(rs, len);
            if (ordered) {
                String[] good = data[i];
                if (this.testRow(good, row, good.length)) continue;
                this.error("testResultSet row not equal, got:\n" + this.formatRow(row) + "\n" + this.formatRow(good));
                continue;
            }
            boolean found = false;
            for (int j = 0; j < rows; ++j) {
                String[] good = data[i];
                if (!this.testRow(good, row, good.length)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.error("testResultSet no match for row:" + this.formatRow(row));
        }
        if (rs.next()) {
            String[] row = this.getData(rs, len);
            this.error("testResultSet expected rowcount:" + rows + " got:>=" + (rows + 1) + " data:" + this.formatRow(row));
        }
    }

    boolean testRow(String[] a, String[] b, int len) {
        for (int i = 0; i < len; ++i) {
            String sa = a[i];
            String sb = b[i];
            if (!(sa == null || sb == null ? sa != sb : !sa.equals(sb))) continue;
            return false;
        }
        return true;
    }

    String[] getData(ResultSet rs, int len) throws SQLException {
        String[] data = new String[len];
        for (int i = 0; i < len; ++i) {
            data[i] = rs.getString(i + 1);
            rs.getObject(i + 1);
        }
        return data;
    }

    String formatRow(String[] row) {
        String sb = "";
        for (int i = 0; i < row.length; ++i) {
            sb = sb + "{" + row[i] + "}";
        }
        return "{" + sb + "}";
    }

    protected void crash(Connection conn) throws Exception {
        ((JdbcConnection)conn).setPowerOffCount(1);
        try {
            conn.createStatement().execute("SET WRITE_DELAY 0");
            conn.createStatement().execute("CREATE TABLE AAA(ID INT)");
            this.error("should be crashed already");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected String readString(Reader reader) throws Exception {
        if (reader == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        try {
            int c;
            while ((c = reader.read()) != -1) {
                buffer.append((char)c);
            }
            return buffer.toString();
        }
        catch (Exception e) {
            this.check(false);
            return null;
        }
    }

    protected void checkNotGeneralException(SQLException e) throws Exception {
        if (e.getSQLState().startsWith("HY000")) {
            this.error("Unexpected General error: " + e.toString());
        }
    }
}

