/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.bench;

import java.sql.PreparedStatement;
import java.util.Random;
import org.h2.test.bench.Bench;
import org.h2.test.bench.Database;

public class BenchSimple
implements Bench {
    Database db;
    int records;

    public void init(Database db, int size) throws Exception {
        this.db = db;
        this.records = size * 50;
        db.start(this, "Init");
        db.openConnection();
        db.dropTable("TEST");
        db.setAutoCommit(false);
        int commitEvery = 1000;
        db.update("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        PreparedStatement prep = db.prepare("INSERT INTO TEST VALUES(?, ?)");
        for (int i = 0; i < this.records; ++i) {
            prep.setInt(1, i);
            prep.setString(2, "Hello World " + i);
            db.update(prep);
            if (i % commitEvery != 0) continue;
            db.commit();
        }
        db.commit();
        db.closeConnection();
        db.end();
        db.start(this, "Open/Close");
        db.openConnection();
        db.closeConnection();
        db.end();
    }

    public void run() throws Exception {
        int i;
        Random random = this.db.getRandom();
        this.db.openConnection();
        this.db.start(this, "Query (random)");
        PreparedStatement prep = this.db.prepare("SELECT * FROM TEST WHERE ID=?");
        for (i = 0; i < this.records; ++i) {
            prep.setInt(1, random.nextInt(this.records));
            this.db.queryReadResult(prep);
        }
        this.db.end();
        this.db.start(this, "Query (sequential)");
        prep = this.db.prepare("SELECT * FROM TEST WHERE ID=?");
        for (i = 0; i < this.records; ++i) {
            prep.setInt(1, i);
            this.db.queryReadResult(prep);
        }
        this.db.end();
        this.db.start(this, "Update (random)");
        prep = this.db.prepare("UPDATE TEST SET NAME=? WHERE ID=?");
        for (i = 0; i < this.records; ++i) {
            prep.setString(1, "Hallo Welt");
            prep.setInt(2, i);
            this.db.update(prep);
        }
        this.db.end();
        this.db.start(this, "Delete (sequential)");
        prep = this.db.prepare("DELETE FROM TEST WHERE ID=?");
        for (i = 0; i < this.records; i += 2) {
            prep.setInt(1, i);
            this.db.update(prep);
        }
        this.db.end();
        this.db.closeConnection();
        this.db.openConnection();
        prep = this.db.prepare("SELECT * FROM TEST WHERE ID=?");
        for (i = 0; i < this.records; ++i) {
            prep.setInt(1, random.nextInt(this.records));
            this.db.queryReadResult(prep);
        }
        this.db.logMemory(this, "Memory Usage");
        this.db.closeConnection();
    }

    public String getName() {
        return "Simple";
    }
}

