/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import org.h2.test.synth.Column;
import org.h2.test.synth.Table;

public class Index {
    Table table;
    String name;
    Column[] columns;
    boolean unique;

    Index(Table table, String name, Column[] columns, boolean unique) {
        this.table = table;
        this.name = name;
        this.columns = columns;
        this.unique = unique;
    }

    public String getName() {
        return this.name;
    }

    public String getCreateSQL() {
        String sql = "CREATE ";
        if (this.unique) {
            sql = sql + "UNIQUE ";
        }
        sql = sql + "INDEX " + this.name + " ON " + this.table.getName() + "(";
        for (int i = 0; i < this.columns.length; ++i) {
            if (i > 0) {
                sql = sql + ", ";
            }
            sql = sql + this.columns[i].getName();
        }
        sql = sql + ")";
        return sql;
    }

    public String getDropSQL() {
        return "DROP INDEX " + this.name;
    }

    public Table getTable() {
        return this.table;
    }
}

