/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import org.h2.test.synth.Column;
import org.h2.test.synth.Row;
import org.h2.test.synth.TestSynth;

class Result
implements Comparable {
    static final int SUCCESS = 0;
    static final int BOOLEAN = 1;
    static final int INT = 2;
    static final int EXCEPTION = 3;
    static final int RESULTSET = 4;
    private int type;
    private boolean bool;
    private int intValue;
    private SQLException exception;
    private ArrayList rows;
    private ArrayList header;
    String sql;

    Result(String sql) {
        this.sql = sql;
        this.type = 0;
    }

    Result(String sql, SQLException e) {
        this.sql = sql;
        this.type = 3;
        this.exception = e;
    }

    Result(String sql, boolean b) {
        this.sql = sql;
        this.type = 1;
        this.bool = b;
    }

    Result(String sql, int i) {
        this.sql = sql;
        this.type = 2;
        this.intValue = i;
    }

    Result(TestSynth config, String sql, ResultSet rs) {
        this.sql = sql;
        this.type = 4;
        try {
            this.rows = new ArrayList();
            this.header = new ArrayList();
            ResultSetMetaData meta = rs.getMetaData();
            int len = meta.getColumnCount();
            Column[] cols = new Column[len];
            for (int i = 0; i < len; ++i) {
                cols[i] = new Column(meta, i + 1);
            }
            while (rs.next()) {
                Row row = new Row(config, rs, len);
                this.rows.add(row);
            }
            Collections.sort(this.rows);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new Error("error reading result set");
        }
    }

    public String toString() {
        switch (this.type) {
            case 0: {
                return "success";
            }
            case 1: {
                return "boolean: " + this.bool;
            }
            case 2: {
                return "int: " + this.intValue;
            }
            case 3: {
                StringWriter w = new StringWriter();
                this.exception.printStackTrace(new PrintWriter(w));
                return "exception: " + this.exception.getSQLState() + ": " + this.exception.getMessage() + "\r\n" + w.toString();
            }
            case 4: {
                int i;
                String result = "ResultSet { // size=" + this.rows.size() + "\r\n  ";
                for (i = 0; i < this.header.size(); ++i) {
                    Column column = (Column)this.header.get(i);
                    result = result + column.toString() + "; ";
                }
                result = result + "} = {\r\n";
                for (i = 0; i < this.rows.size(); ++i) {
                    Row row = (Row)this.rows.get(i);
                    result = result + "  { " + row.toString() + "};\r\n";
                }
                return result + "}";
            }
        }
        throw new Error("internal");
    }

    public int compareTo(Object o) {
        Result r = (Result)o;
        switch (this.type) {
            case 3: {
                if (r.type != 3) {
                    return 1;
                }
                return 0;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                return this.toString().compareTo(r.toString());
            }
        }
        throw new Error("internal");
    }

    public void log() {
        switch (this.type) {
            case 0: {
                System.out.println("> ok");
                break;
            }
            case 3: {
                System.out.println("> exception");
                break;
            }
            case 2: {
                if (this.intValue == 0) {
                    System.out.println("> ok");
                    break;
                }
                System.out.println("> update count: " + this.intValue);
                break;
            }
            case 4: {
                System.out.println("> rs " + this.rows.size());
            }
        }
        System.out.println();
    }
}

