/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.util.Random;
import org.h2.test.TestBase;
import org.h2.tools.CompressTool;

public class TestCompress
extends TestBase {
    public void test() throws Exception {
        if (this.config.big) {
            int i;
            for (i = 0; i < 100; ++i) {
                this.test(i);
            }
            for (i = 100; i < 10000; i += i + i + 1) {
                this.test(i);
            }
        } else {
            this.test(0);
            this.test(1);
            this.test(7);
            this.test(50);
            this.test(200);
        }
    }

    void test(int len) throws Exception {
        for (int pattern = 0; pattern < 3; ++pattern) {
            byte[] buff = new byte[len];
            switch (pattern) {
                case 0: {
                    break;
                }
                case 1: {
                    for (int x = 0; x < len; ++x) {
                        buff[x] = (byte)(x & 0xA);
                    }
                    break;
                }
                case 2: {
                    Random r = new Random(len);
                    r.nextBytes(buff);
                    break;
                }
            }
            String[] algorithm = new String[]{"LZF", "Deflate", "No"};
            CompressTool utils = CompressTool.getInstance();
            for (int i = 0; i < algorithm.length; ++i) {
                byte[] out = utils.compress(buff, algorithm[i]);
                byte[] test = utils.expand(out);
                this.check(test.length, buff.length);
                this.check(buff, test);
            }
        }
    }
}

