/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import org.h2.util.ByteUtils;
import org.h2.util.StringUtils;

public class Resources {
    private static final HashMap FILES = new HashMap();
    private static boolean loadFromFiles;
    static /* synthetic */ Class class$org$h2$util$Resources;

    public static void main(String[] args) throws Exception {
        String inDir = args.length > 0 ? args[0] : null;
        String outDir = args.length > 1 ? args[1] : null;
        new Resources().run(inDir, outDir);
    }

    void run(String outDir, String inDir) throws Exception {
        if (outDir == null) {
            outDir = "bin";
        }
        if (inDir == null) {
            inDir = "src/main";
        }
        if (new File(outDir + "/org/h2/util").exists()) {
            String file = outDir + "/org/h2/util/ResourceData.java";
            PrintWriter out = new PrintWriter(new FileWriter(file));
            out.println("package org.h2.util;");
            out.println("// Do not change this code manually");
            out.println("// This code is generated by " + this.getClass().getName());
            out.println("class ResourceData {");
            out.println("    static {");
            this.generate(out, inDir + "/org/h2/res", "org.h2");
            this.generate(out, inDir + "/org/h2/web/res", "org.h2.web");
            out.println("    }");
            out.println("}");
            out.close();
        }
    }

    void generate(PrintWriter out, String inDir, String packageName) throws Exception {
        File dir = new File(inDir);
        String[] list = dir.list();
        for (int i = 0; list != null && i < list.length; ++i) {
            File f = new File(dir, list[i]);
            if (!f.isFile() || list[i].endsWith(".java")) continue;
            String name = "/" + packageName.replace('.', '/') + "/res/" + f.getName();
            out.print("        Resources.add(" + StringUtils.quoteJavaString(name) + ", ");
            FileInputStream in = new FileInputStream(f);
            byte[] buffer = ByteUtils.getBytesAndClose(in, 0);
            String s = ByteUtils.convertToBinString(buffer);
            out.println(StringUtils.quoteJavaString(s) + ");");
        }
    }

    static void add(String name, String data) {
        FILES.put(name, ByteUtils.convertBinStringToBytes(data));
    }

    public static byte[] get(String name) throws IOException {
        InputStream in;
        Object data = loadFromFiles ? (Object)((in = (class$org$h2$util$Resources == null ? (class$org$h2$util$Resources = Resources.class$("org.h2.util.Resources")) : class$org$h2$util$Resources).getResourceAsStream(name)) == null ? null : ByteUtils.getBytesAndClose(in, 0)) : (byte[])FILES.get(name);
        return data == null ? new byte[]{} : data;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Class.forName("org.h2.util.ResourceData");
            loadFromFiles = false;
        }
        catch (ClassNotFoundException e) {
            loadFromFiles = true;
        }
    }
}

