/*
 * Decompiled with CFR 0.152.
 */
package railo.loader.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import railo.commons.io.res.Resource;

public class Util {
    private static File tempFile;
    private static File homeFile;
    private static final SimpleDateFormat HTTP_TIME_STRING_FORMAT;

    static {
        HTTP_TIME_STRING_FORMAT = new SimpleDateFormat("EE, dd MMM yyyy HH:mm:ss zz", Locale.ENGLISH);
        HTTP_TIME_STRING_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public static final void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[65535];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        Util.closeEL(in);
        Util.closeEL(out);
    }

    public static String toString(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer content = new StringBuffer();
        String line = br.readLine();
        if (line != null) {
            content.append(line);
            while ((line = br.readLine()) != null) {
                content.append("\n" + line);
            }
        }
        br.close();
        return content.toString();
    }

    public static boolean toBooleanValue(String str) throws IOException {
        if ("true".equals(str = str.trim().toLowerCase())) {
            return true;
        }
        if ("false".equals(str)) {
            return false;
        }
        if ("yes".equals(str)) {
            return true;
        }
        if ("no".equals(str)) {
            return false;
        }
        throw new IOException("can't cast string to a boolean value");
    }

    public static void closeEL(InputStream is, OutputStream os) {
        Util.closeEL(is);
        Util.closeEL(os);
    }

    public static void closeEL(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void closeEL(Reader r) {
        try {
            if (r != null) {
                r.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void closeEL(Writer w) {
        try {
            if (w != null) {
                w.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void closeEL(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String getContentAsString(InputStream is, String charset) throws IOException {
        BufferedReader br = charset == null ? new BufferedReader(new InputStreamReader(is)) : new BufferedReader(new InputStreamReader(is, charset));
        StringBuffer content = new StringBuffer();
        String line = br.readLine();
        if (line != null) {
            content.append(line);
            while ((line = br.readLine()) != null) {
                content.append("\n" + line);
            }
        }
        br.close();
        return content.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty(String str, boolean trim) {
        if (!trim) {
            return Util.isEmpty(str);
        }
        return str == null || str.trim().length() == 0;
    }

    public static int length(String str) {
        if (str == null) {
            return 0;
        }
        return str.length();
    }

    public static int toInVersion(String version) {
        int rIndex = version.lastIndexOf(".rcs");
        if (rIndex == -1) {
            rIndex = version.lastIndexOf(".rc");
        }
        if (rIndex != -1) {
            version = version.substring(0, rIndex);
        }
        int beginIndex = 0;
        int endIndex = version.indexOf(46, beginIndex);
        int intVersion = 0;
        intVersion += Integer.parseInt(version.substring(beginIndex, endIndex)) * 1000000;
        beginIndex = endIndex + 1;
        endIndex = version.indexOf(46, beginIndex);
        intVersion += Integer.parseInt(version.substring(beginIndex, endIndex)) * 10000;
        beginIndex = endIndex + 1;
        endIndex = version.indexOf(46, beginIndex);
        intVersion += Integer.parseInt(version.substring(beginIndex, endIndex)) * 100;
        beginIndex = endIndex + 1;
        return intVersion += Integer.parseInt(version.substring(beginIndex));
    }

    public static String toStringVersion(int version) {
        StringBuffer sb = new StringBuffer();
        int tmp = version / 1000000;
        version -= tmp * 1000000;
        sb.append(String.valueOf(tmp));
        sb.append(".");
        tmp = version / 10000;
        version -= tmp * 10000;
        sb.append(Util.len(String.valueOf(tmp), 2));
        sb.append(".");
        tmp = version / 100;
        sb.append(Util.len(String.valueOf(tmp), 2));
        sb.append(".");
        sb.append(Util.len(String.valueOf(version -= tmp * 100), 3));
        return sb.toString();
    }

    private static Object len(String str, int i) {
        while (str.length() < i) {
            str = "0" + str;
        }
        return str;
    }

    public static String replace(String str, String sub1, String sub2, boolean onlyFirst) {
        int pos;
        if (sub1.equals(sub2)) {
            return str;
        }
        if (!onlyFirst && sub1.length() == 1 && sub2.length() == 1) {
            return str.replace(sub1.charAt(0), sub2.charAt(0));
        }
        StringBuffer sb = new StringBuffer();
        int start = 0;
        int sub1Length = sub1.length();
        while ((pos = str.indexOf(sub1, start)) != -1) {
            sb.append(str.substring(start, pos));
            sb.append(sub2);
            start = pos + sub1Length;
            if (onlyFirst) break;
        }
        sb.append(str.substring(start));
        return sb.toString();
    }

    public static String parsePlaceHolder(String path) {
        if (path == null) {
            return path;
        }
        if (path.startsWith("{temp")) {
            if (path.startsWith("}", 5)) {
                path = new File(Util.getTempDirectory(), path.substring(6)).toString();
            } else if (path.startsWith("-dir}", 5)) {
                path = new File(Util.getTempDirectory(), path.substring(10)).toString();
            } else if (path.startsWith("-directory}", 5)) {
                path = new File(Util.getTempDirectory(), path.substring(16)).toString();
            }
        } else if (path.startsWith("{system")) {
            if (path.startsWith("}", 7)) {
                path = new File(Util.getSystemDirectory(), path.substring(8)).toString();
            } else if (path.startsWith("-dir}", 7)) {
                path = new File(Util.getSystemDirectory(), path.substring(12)).toString();
            } else if (path.startsWith("-directory}", 7)) {
                path = new File(Util.getSystemDirectory(), path.substring(18)).toString();
            }
        } else if (path.startsWith("{home")) {
            if (path.startsWith("}", 5)) {
                path = new File(Util.getHomeDirectory(), path.substring(6)).toString();
            } else if (path.startsWith("-dir}", 5)) {
                path = new File(Util.getHomeDirectory(), path.substring(10)).toString();
            } else if (path.startsWith("-directory}", 5)) {
                path = new File(Util.getHomeDirectory(), path.substring(16)).toString();
            }
        }
        return path;
    }

    public static File getTempDirectory() {
        if (tempFile != null) {
            return tempFile;
        }
        String tmpStr = System.getProperty("java.io.tmpdir");
        if (tmpStr != null && (tempFile = new File(tmpStr)).exists()) {
            tempFile = Util.getCanonicalFileEL(tempFile);
            return tempFile;
        }
        try {
            File tmp = File.createTempFile("a", "a");
            tempFile = tmp.getParentFile();
            tempFile = Util.getCanonicalFileEL(tempFile);
            tmp.delete();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return tempFile;
    }

    public static File getHomeDirectory() {
        if (homeFile != null) {
            return homeFile;
        }
        String homeStr = System.getProperty("user.home");
        if (homeStr != null) {
            homeFile = new File(homeStr);
            homeFile = Util.getCanonicalFileEL(homeFile);
        }
        return homeFile;
    }

    public static File getSystemDirectory() {
        String pathes = System.getProperty("java.library.path");
        if (pathes != null) {
            File file;
            String[] arr = pathes.split(File.pathSeparator);
            int i = 0;
            while (i < arr.length) {
                if (arr[i].toLowerCase().indexOf("windows\\system") != -1 && (file = new File(arr[i])).exists() && file.isDirectory() && file.canWrite()) {
                    return Util.getCanonicalFileEL(file);
                }
                ++i;
            }
            i = 0;
            while (i < arr.length) {
                if (arr[i].toLowerCase().indexOf("windows") != -1 && (file = new File(arr[i])).exists() && file.isDirectory() && file.canWrite()) {
                    return Util.getCanonicalFileEL(file);
                }
                ++i;
            }
            i = 0;
            while (i < arr.length) {
                if (arr[i].toLowerCase().indexOf("winnt") != -1 && (file = new File(arr[i])).exists() && file.isDirectory() && file.canWrite()) {
                    return Util.getCanonicalFileEL(file);
                }
                ++i;
            }
            i = 0;
            while (i < arr.length) {
                if (arr[i].toLowerCase().indexOf("win") != -1 && (file = new File(arr[i])).exists() && file.isDirectory() && file.canWrite()) {
                    return Util.getCanonicalFileEL(file);
                }
                ++i;
            }
            i = 0;
            while (i < arr.length) {
                file = new File(arr[i]);
                if (file.exists() && file.isDirectory() && file.canWrite()) {
                    return Util.getCanonicalFileEL(file);
                }
                ++i;
            }
        }
        return null;
    }

    public static File getCanonicalFileEL(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file;
        }
    }

    public static String toHTTPTimeString(Date date) {
        return Util.replace(HTTP_TIME_STRING_FORMAT.format(date), "+00:00", "", true);
    }

    public static String toHTTPTimeString() {
        return Util.replace(HTTP_TIME_STRING_FORMAT.format(new Date()), "+00:00", "", true);
    }

    public static boolean hasUpperCase(String str) {
        if (Util.isEmpty(str)) {
            return false;
        }
        return !str.equals(str.toLowerCase());
    }

    public static BufferedInputStream toBufferedInputStream(InputStream is) {
        if (is instanceof BufferedInputStream) {
            return (BufferedInputStream)is;
        }
        return new BufferedInputStream(is);
    }

    public static BufferedOutputStream toBufferedOutputStream(OutputStream os) {
        if (os instanceof BufferedOutputStream) {
            return (BufferedOutputStream)os;
        }
        return new BufferedOutputStream(os);
    }

    public static void copy(Resource in, Resource out) throws IOException {
        BufferedInputStream is = null;
        BufferedOutputStream os = null;
        try {
            is = Util.toBufferedInputStream(in.getInputStream());
            os = Util.toBufferedOutputStream(out.getOutputStream());
        }
        catch (IOException ioe) {
            Util.closeEL(os);
            Util.closeEL(is);
            throw ioe;
        }
        Util.copy(is, os);
    }

    public static String toVariableName(String str, boolean addIdentityNumber) {
        StringBuffer rtn = new StringBuffer();
        char[] chars = str.toCharArray();
        long changes = 0L;
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (i == 0 && c >= '0' && c <= '9') {
                rtn.append("_" + c);
            } else if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '$') {
                rtn.append(c);
            } else {
                rtn.append('_');
                changes += (long)(c * (i + 1));
            }
            ++i;
        }
        if (addIdentityNumber && changes > 0L) {
            rtn.append(changes);
        }
        return rtn.toString();
    }

    public static String first(String str, String delimeter) {
        StringTokenizer st = new StringTokenizer(str, delimeter);
        return st.nextToken();
    }

    public static String last(String str, String delimeter) {
        StringTokenizer st = new StringTokenizer(str, delimeter);
        String rtn = null;
        while (st.hasMoreTokens()) {
            rtn = st.nextToken();
        }
        return rtn;
    }
}

