/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.MemoryStore;
import net.sf.ehcache.store.Store;

public class LruMemoryStore
extends MemoryStore {
    private static final Logger LOG = Logger.getLogger(LruMemoryStore.class.getName());

    public LruMemoryStore(Ehcache cache, Store diskStore) {
        super(cache, diskStore);
        try {
            this.map = new SpoolingLinkedHashMap();
        }
        catch (CacheException e) {
            LOG.log(Level.SEVERE, cache.getName() + "Cache: Cannot start LruMemoryStore. Initial cause was " + e.getMessage(), e);
        }
    }

    public final class SpoolingLinkedHashMap
    extends LinkedHashMap {
        private static final int INITIAL_CAPACITY = 100;
        private static final float GROWTH_FACTOR = 0.75f;

        public SpoolingLinkedHashMap() {
            super(100, 0.75f, true);
        }

        protected final boolean removeEldestEntry(Map.Entry eldest) {
            Element element = (Element)eldest.getValue();
            return this.removeLeastRecentlyUsedElement(element);
        }

        private boolean removeLeastRecentlyUsedElement(Element element) throws CacheException {
            if (element.isExpired()) {
                LruMemoryStore.this.notifyExpiry(element);
                return true;
            }
            if (LruMemoryStore.this.isFull()) {
                LruMemoryStore.this.evict(element);
                return true;
            }
            return false;
        }
    }
}

