/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.PessimisticLockException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PessimisticWriteUpdateLockingStrategy
implements LockingStrategy {
    private static final Logger log = LoggerFactory.getLogger((Class)PessimisticWriteUpdateLockingStrategy.class);
    private final Lockable lockable;
    private final LockMode lockMode;
    private final String sql;

    public PessimisticWriteUpdateLockingStrategy(Lockable lockable, LockMode lockMode) {
        this.lockable = lockable;
        this.lockMode = lockMode;
        if (lockMode.lessThan(LockMode.PESSIMISTIC_READ)) {
            throw new HibernateException("[" + lockMode + "] not valid for update statement");
        }
        if (!lockable.isVersioned()) {
            log.warn("write locks via update not supported for non-versioned entities [" + lockable.getEntityName() + "]");
            this.sql = null;
        } else {
            this.sql = this.generateLockString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Serializable id, Object version, Object object, int timeout, SessionImplementor session) throws StaleObjectStateException, JDBCException {
        if (!this.lockable.isVersioned()) {
            throw new HibernateException("write locks via update not supported for non-versioned entities [" + this.lockable.getEntityName() + "]");
        }
        SessionFactoryImplementor factory = session.getFactory();
        try {
            PreparedStatement st = session.getBatcher().prepareSelectStatement(this.sql);
            try {
                int affected;
                this.lockable.getVersionType().nullSafeSet(st, version, 1, session);
                int offset = 2;
                this.lockable.getIdentifierType().nullSafeSet(st, id, offset, session);
                offset += this.lockable.getIdentifierType().getColumnSpan(factory);
                if (this.lockable.isVersioned()) {
                    this.lockable.getVersionType().nullSafeSet(st, version, offset, session);
                }
                if ((affected = st.executeUpdate()) < 0) {
                    factory.getStatisticsImplementor().optimisticFailure(this.lockable.getEntityName());
                    throw new StaleObjectStateException(this.lockable.getEntityName(), id);
                }
                Object var11_12 = null;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                session.getBatcher().closeStatement(st);
                throw throwable;
            }
            session.getBatcher().closeStatement(st);
            {
            }
        }
        catch (SQLException sqle) {
            JDBCException e = JDBCExceptionHelper.convert(session.getFactory().getSQLExceptionConverter(), sqle, "could not lock: " + MessageHelper.infoString((EntityPersister)this.lockable, id, session.getFactory()), this.sql);
            throw new PessimisticLockException("could not obtain pessimistic lock", e, object);
        }
    }

    protected String generateLockString() {
        SessionFactoryImplementor factory = this.lockable.getFactory();
        Update update = new Update(factory.getDialect());
        update.setTableName(this.lockable.getRootTableName());
        update.addPrimaryKeyColumns(this.lockable.getRootTableIdentifierColumnNames());
        update.setVersionColumnName(this.lockable.getVersionColumnName());
        update.addColumn(this.lockable.getVersionColumnName());
        if (factory.getSettings().isCommentsEnabled()) {
            update.setComment(this.lockMode + " lock " + this.lockable.getEntityName());
        }
        return update.toStatementString();
    }

    protected LockMode getLockMode() {
        return this.lockMode;
    }
}

