/*
 * Decompiled with CFR 0.152.
 */
package sbaz.functional;

import java.io.File;
import java.io.FileNotFoundException;
import junit.framework.Assert;
import sbaz.Filename;
import sbaz.functional.FunctionalTestCase;
import sbaz.functional.FunctionalTestCase$;
import sbaz.util.RichFile$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.tools.nsc.io.Process;
import scala.tools.nsc.io.Process$;
import scala.util.Properties$;

public abstract class FunctionalTestCase$class {
    public static /* synthetic */ boolean execSbaz$default$2(FunctionalTestCase $this) {
        return false;
    }

    public static Filename packageBuildDir(FunctionalTestCase $this) {
        Filename filename = $this.packageRepoDir();
        String string = $this.testName();
        return RichFile$.MODULE$.directory((List<String>)Nil$.MODULE$.$colon$colon((Object)string).$colon$colon$colon(RichFile$.MODULE$.pimpFilenameToStringList(filename)));
    }

    public static boolean initDir(FunctionalTestCase $this, Filename filename) {
        File dir;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    dir = RichFile$.MODULE$.pimpFilenameToFile(filename);
                    if (!dir.exists()) break block2;
                    bl = false;
                    break block3;
                }
                if (!dir.mkdirs()) break block4;
                bl = true;
            }
            return bl;
        }
        throw new FileNotFoundException(new StringBuilder().append((Object)"Could not create directory ").append((Object)dir.getAbsolutePath()).toString());
    }

    public static Process execSbaz(FunctionalTestCase $this, String cmd, boolean asyncDownload) {
        Nil$ nil$;
        String fileSep = System.getProperty("file.separator");
        String pathSep = System.getProperty("path.separator");
        String javaHome = System.getProperty("java.home");
        String javaExec = Properties$.MODULE$.isWin() ? "java.exe" : "java";
        Filename rel = RichFile$.MODULE$.relfile((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bin", javaExec}));
        String javaCmd = rel.relativeTo(new File(javaHome)).toString();
        Filename rel2 = RichFile$.MODULE$.relfile((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"misc", "sbaz", "scala-bazaars.jar"}));
        String scalabazaarsJar = rel2.relativeTo($this.managedDir().toFile()).toString();
        Assert.assertTrue((String)new StringBuilder().append((Object)"Java command '").append((Object)javaCmd).append((Object)"' could not be found.").toString(), (boolean)new File(javaCmd).exists());
        Assert.assertTrue((String)new StringBuilder().append((Object)"Scala Bazaars JAR '").append((Object)scalabazaarsJar).append((Object)"' could not be found.").toString(), (boolean)new File(scalabazaarsJar).exists());
        String classpath = FunctionalTestCase$class.wrap$1($this, scalabazaarsJar);
        String scalaHome = new StringBuilder().append((Object)"-Dscala.home=").append((Object)FunctionalTestCase$class.wrap$1($this, $this.managedDir().toFile().toString())).toString();
        String string = "-Denv.classpath=";
        String string2 = "-Denv.emacs=";
        if (asyncDownload) {
            String string3 = "-Dsbaz.download.maxWorkers=2";
            nil$ = Nil$.MODULE$.$colon$colon((Object)string3);
        } else {
            nil$ = Nil$.MODULE$;
        }
        List javaArgs = nil$.$colon$colon((Object)string2).$colon$colon((Object)string);
        String string4 = FunctionalTestCase$class.wrap$1($this, javaCmd);
        String string5 = "-Xmx256M";
        String string6 = "-Xms16M";
        String string7 = "-cp";
        String string8 = classpath;
        String string9 = scalaHome;
        List list = javaArgs;
        String string10 = "sbaz.clui.CommandLine";
        String string11 = cmd;
        String shellCmd = Nil$.MODULE$.$colon$colon((Object)string11).$colon$colon((Object)string10).$colon$colon$colon(list).$colon$colon((Object)string9).$colon$colon((Object)string8).$colon$colon((Object)string7).$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).mkString("", " ", "");
        String wrappedCmd = Properties$.MODULE$.isWin() ? new StringBuilder().append((Object)"\" ").append((Object)shellCmd).append((Object)" \"").toString() : shellCmd;
        return Process$.MODULE$.apply(wrappedCmd, Process$.MODULE$.apply$default$2(), Process$.MODULE$.apply$default$3(), Process$.MODULE$.apply$default$4());
    }

    public static String getStdout(FunctionalTestCase $this, Process proc) {
        return new StringBuilder().append((Object)"stdout = [").append((Object)proc.stdout().mkString("\n")).append((Object)"]").toString();
    }

    public static String getStderr(FunctionalTestCase $this, Process proc) {
        return new StringBuilder().append((Object)"stderr = [").append((Object)proc.stderr().mkString("\n")).append((Object)"]").toString();
    }

    public static String getOutput(FunctionalTestCase $this, Process proc) {
        return new StringBuilder().append((Object)$this.getStdout(proc)).append((Object)"\n").append((Object)$this.getStderr(proc)).toString();
    }

    public static void assertExists(FunctionalTestCase $this, File f) {
        if (!f.exists()) {
            Assert.fail((String)new StringBuilder().append((Object)"File ").append((Object)f.getPath()).append((Object)" does not exist as expected.").toString());
        }
    }

    public static void assertNotExists(FunctionalTestCase $this, File f) {
        if (f.exists()) {
            Assert.fail((String)new StringBuilder().append((Object)"File ").append((Object)f.getPath()).append((Object)" exists when it should not.").toString());
        }
    }

    public static void assertEndsWith(FunctionalTestCase $this, String expected, String actual) {
        if (!actual.endsWith(expected)) {
            int len = expected.length();
            String actualPiece = len < actual.length() ? new StringBuilder().append((Object)"shoretened to ").append((Object)BoxesRunTime.boxToInteger((int)len)).append((Object)" chars ...[").append((Object)actual.substring(actual.length() - len)).append((Object)"]").toString() : new StringBuilder().append((Object)"[").append((Object)actual).append((Object)"]").toString();
            Assert.fail((String)new StringBuilder().append((Object)"Expected ").append((Object)expected).append((Object)"\nActual ").append((Object)actualPiece).toString());
        }
    }

    public static void start(FunctionalTestCase $this) {
        $this.sbaz$functional$FunctionalTestCase$$startTime_$eq(System.currentTimeMillis());
        $this.sbaz$functional$FunctionalTestCase$$setupTime_$eq($this.sbaz$functional$FunctionalTestCase$$startTime());
    }

    public static void setupDone(FunctionalTestCase $this) {
        $this.sbaz$functional$FunctionalTestCase$$setupTime_$eq(System.currentTimeMillis());
    }

    public static void publishDone(FunctionalTestCase $this) {
        $this.sbaz$functional$FunctionalTestCase$$publishTime_$eq(System.currentTimeMillis());
    }

    public static void printStats(FunctionalTestCase $this) {
        long execTime = System.currentTimeMillis();
        double setupDur = (double)($this.sbaz$functional$FunctionalTestCase$$setupTime() - $this.sbaz$functional$FunctionalTestCase$$startTime()) / 1000.0;
        double publishDur = (double)($this.sbaz$functional$FunctionalTestCase$$publishTime() - $this.sbaz$functional$FunctionalTestCase$$setupTime()) / 1000.0;
        double execDur = (double)(execTime - $this.sbaz$functional$FunctionalTestCase$$setupTime()) / 1000.0;
        double totalDur = (double)(execTime - $this.sbaz$functional$FunctionalTestCase$$startTime()) / 1000.0;
        Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString($this.statMsg()).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.testName(), BoxesRunTime.boxToDouble((double)setupDur), BoxesRunTime.boxToDouble((double)publishDur), BoxesRunTime.boxToDouble((double)execDur), BoxesRunTime.boxToDouble((double)totalDur)})));
    }

    private static final String wrap$1(FunctionalTestCase $this, String s) {
        return new StringBuilder().append((Object)"\"").append((Object)s).append((Object)"\"").toString();
    }

    public static void $init$(FunctionalTestCase $this) {
        String systemTemp = System.getProperty("java.io.tmpdir");
        String rootDir = System.getProperty("sbaz.functional.dir", systemTemp);
        $this.sbaz$functional$FunctionalTestCase$_setter_$functionalTestDir_$eq(RichFile$.MODULE$.directory((List<String>)((List)((TraversableLike)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.augmentString(rootDir).split('/')).toList().flatMap((Function1)new FunctionalTestCase$.anonfun.1($this), List$.MODULE$.canBuildFrom())).filter((Function1)new FunctionalTestCase$.anonfun.2($this)))));
        Filename filename = $this.functionalTestDir();
        String string = "package-repo";
        $this.sbaz$functional$FunctionalTestCase$_setter_$packageRepoDir_$eq(RichFile$.MODULE$.directory((List<String>)Nil$.MODULE$.$colon$colon((Object)string).$colon$colon$colon(RichFile$.MODULE$.pimpFilenameToStringList(filename))));
        Filename filename2 = $this.functionalTestDir();
        String string2 = "managed-dir";
        $this.sbaz$functional$FunctionalTestCase$_setter_$managedDir_$eq(RichFile$.MODULE$.directory((List<String>)Nil$.MODULE$.$colon$colon((Object)string2).$colon$colon$colon(RichFile$.MODULE$.pimpFilenameToStringList(filename2))));
        $this.sbaz$functional$FunctionalTestCase$$startTime_$eq(0L);
        $this.sbaz$functional$FunctionalTestCase$$setupTime_$eq(0L);
        $this.sbaz$functional$FunctionalTestCase$$publishTime_$eq(0L);
        $this.sbaz$functional$FunctionalTestCase$_setter_$statMsg_$eq("[%s]setup: %.2f sec, publish: %.2f sec, exec: %.2f sec, total: %.2f sec");
    }
}

