/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import scala.Predef$;
import scala.ScalaObject;
import scala.actors.Debug$;
import scala.actors.IScheduler;
import scala.actors.IScheduler$class;
import scala.actors.Reactor;
import scala.actors.scheduler.DrainableForkJoinPool;
import scala.actors.scheduler.ForkJoinScheduler$;
import scala.actors.scheduler.QuitControl;
import scala.actors.scheduler.TerminationMonitor;
import scala.actors.scheduler.TerminationMonitor$class;
import scala.actors.scheduler.ThreadPoolConfig$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ManagedBlocker;
import scala.concurrent.forkjoin.ForkJoinPool;
import scala.concurrent.forkjoin.ForkJoinTask;
import scala.concurrent.forkjoin.RecursiveAction;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForkJoinScheduler
implements Runnable,
ScalaObject,
IScheduler,
TerminationMonitor {
    private final int initCoreSize;
    private final int maxSize;
    private final boolean daemon;
    private final boolean fair;
    private DrainableForkJoinPool pool;
    private boolean terminating;
    private boolean snapshoting;
    private Collection<ForkJoinTask<?>> drainedTasks;
    private final int CHECK_FREQ;
    private int activeActors;
    private final HashMap terminationHandlers;
    private boolean scala$actors$scheduler$TerminationMonitor$$started;

    @Override
    public int activeActors() {
        return this.activeActors;
    }

    @Override
    public void activeActors_$eq(int n) {
        this.activeActors = n;
    }

    public HashMap terminationHandlers() {
        return this.terminationHandlers;
    }

    @Override
    public final boolean scala$actors$scheduler$TerminationMonitor$$started() {
        return this.scala$actors$scheduler$TerminationMonitor$$started;
    }

    @Override
    public final void scala$actors$scheduler$TerminationMonitor$$started_$eq(boolean bl) {
        this.scala$actors$scheduler$TerminationMonitor$$started = bl;
    }

    @Override
    public void scala$actors$scheduler$TerminationMonitor$_setter_$terminationHandlers_$eq(HashMap hashMap) {
        this.terminationHandlers = hashMap;
    }

    public void newActor(Reactor a) {
        TerminationMonitor$class.newActor(this, a);
    }

    public void terminated(Reactor a) {
        TerminationMonitor$class.terminated(this, a);
    }

    @Override
    public boolean allActorsTerminated() {
        return TerminationMonitor$class.allActorsTerminated(this);
    }

    @Override
    public void gc() {
        TerminationMonitor$class.gc(this);
    }

    public int initCoreSize() {
        return this.initCoreSize;
    }

    public int maxSize() {
        return this.maxSize;
    }

    private DrainableForkJoinPool pool() {
        return this.pool;
    }

    private boolean terminating() {
        return this.terminating;
    }

    private void terminating_$eq(boolean bl) {
        this.terminating = bl;
    }

    private boolean snapshoting() {
        return this.snapshoting;
    }

    private void drainedTasks_$eq(Collection<ForkJoinTask<?>> collection) {
        this.drainedTasks = collection;
    }

    public int CHECK_FREQ() {
        return this.CHECK_FREQ;
    }

    public ForkJoinScheduler(boolean d) {
        this(ThreadPoolConfig$.MODULE$.corePoolSize(), ThreadPoolConfig$.MODULE$.maxPoolSize(), d, true);
    }

    public ForkJoinScheduler() {
        this(false);
    }

    /*
     * WARNING - void declaration
     */
    private DrainableForkJoinPool makeNewPool() {
        void var1_1;
        DrainableForkJoinPool p = new DrainableForkJoinPool();
        p.setAsyncMode(true);
        p.setParallelism(this.initCoreSize());
        p.setMaximumPoolSize(this.maxSize());
        Debug$.MODULE$.info(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(this).$plus(": parallelism ")).append(BoxesRunTime.boxToInteger(p.getParallelism())).toString());
        Debug$.MODULE$.info(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(this).$plus(": max pool size ")).append(BoxesRunTime.boxToInteger(p.getMaximumPoolSize())).toString());
        return var1_1;
    }

    public void start() {
        try {
            Thread t = new Thread(this);
            t.setDaemon(this.daemon);
            t.setName("ForkJoinScheduler");
            t.start();
        }
        catch (Exception exception) {
            Debug$.MODULE$.info(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(this).$plus(": could not create scheduler thread: ")).append(exception).toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        try {
            while (true) lbl-1000:
            // 2 sources

            {
                var2_1 = this;
                synchronized (var2_1) {
                    this.liftedTree1$1();
                    if (this.terminating()) {
                        throw new QuitControl();
                    }
                    if (this.allActorsTerminated()) {
                        Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": all actors terminated"));
                        this.terminating_$eq(true);
                        throw new QuitControl();
                    }
                    if (this.snapshoting()) {
                        if (this.pool().isQuiescent()) {
                            var3_2 = new ArrayList<ForkJoinTask<?>>();
                            var4_3 = this.pool().drainTasksTo(var3_2);
                            Debug$.MODULE$.info(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(this).$plus(": drained ")).append(BoxesRunTime.boxToInteger(var4_3)).append((Object)" tasks").toString());
                            this.drainedTasks_$eq(var3_2);
                            this.terminating_$eq(true);
                            throw new QuitControl();
                        }
                        v0 = BoxedUnit.UNIT;
                    } else {
                        this.gc();
                        v0 = BoxedUnit.UNIT;
                    }
                    continue;
                }
                break;
            }
        }
        catch (QuitControl v2) {
            Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": initiating shutdown..."));
            while (true) {
                if (this.pool().isQuiescent()) {
                    this.pool().shutdown();
                    return;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException var1_4) {}
                {
                }
            }
        }
        {
            ** while (true)
        }
    }

    @Override
    public void execute(Runnable task) {
        this.pool().execute(task);
    }

    @Override
    public void executeFromActor(Runnable runnable) {
        if (this.fair && Random$.MODULE$.nextInt(50) == 1) {
            this.pool().execute(runnable);
        } else {
            ((RecursiveAction)((Object)runnable)).fork();
        }
    }

    @Override
    public boolean isActive() {
        ForkJoinScheduler forkJoinScheduler = this;
        synchronized (forkJoinScheduler) {
            Boolean bl = BoxesRunTime.boxToBoolean(!this.terminating() && this.pool() != null && !this.pool().isShutdown());
            return BoxesRunTime.unboxToBoolean(bl);
        }
    }

    @Override
    public void managedBlock(ManagedBlocker blocker$1) {
        ForkJoinPool.managedBlock(new $anon$2(this, blocker$1), true);
    }

    private final void liftedTree1$1() {
        try {
            this.wait(this.CHECK_FREQ());
        }
        catch (InterruptedException interruptedException) {}
    }

    public ForkJoinScheduler(int n, int n2, boolean bl, boolean bl2) {
        this.initCoreSize = n;
        this.maxSize = n2;
        this.daemon = bl;
        this.fair = bl2;
        IScheduler$class.$init$(this);
        TerminationMonitor$class.$init$(this);
        this.pool = this.makeNewPool();
        this.terminating = false;
        this.snapshoting = false;
        this.drainedTasks = null;
        this.CHECK_FREQ = 10;
    }
}

