/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.balancer.rules;

import javax.servlet.http.HttpServletRequest;
import org.apache.webapp.balancer.rules.BaseRule;

public class RequestHeaderRule
extends BaseRule {
    private String headerName;
    private String headerValue;

    public void setHeaderName(String theName) {
        if (theName == null) {
            throw new IllegalArgumentException("The header name cannot be null.");
        }
        this.headerName = theName;
    }

    protected String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderValue(String theValue) {
        this.headerValue = theValue;
    }

    protected String getHeaderValue() {
        return this.headerValue;
    }

    public boolean matches(HttpServletRequest request) {
        String actualHeaderValue = request.getHeader(this.getHeaderName());
        if (actualHeaderValue == null) {
            return this.getHeaderValue() == null;
        }
        return actualHeaderValue.compareTo(this.getHeaderValue()) == 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append(this.getClass().getName());
        buffer.append(": ");
        buffer.append("Header name: ");
        buffer.append(this.getHeaderName());
        buffer.append(" / ");
        buffer.append("Header value: ");
        buffer.append(this.getHeaderValue());
        buffer.append(" / ");
        buffer.append("Redirect URL: ");
        buffer.append(this.getRedirectUrl());
        buffer.append("]");
        return buffer.toString();
    }
}

