/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.util.ByteUtils;
import org.h2.util.RandomUtils;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueUuid
extends Value {
    private static final int PRECISION = 16;
    private static final int DISPLAY_SIZE = 36;
    private final long high;
    private final long low;

    private ValueUuid(long l, long l2) {
        this.high = l;
        this.low = l2;
    }

    public int hashCode() {
        return (int)(this.high >>> 32 ^ this.high ^ this.low >>> 32 ^ this.low);
    }

    public static ValueUuid getNewRandom() {
        long l = RandomUtils.getSecureLong();
        long l2 = RandomUtils.getSecureLong();
        l = l & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
        l2 = l2 & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new ValueUuid(l, l2);
    }

    public static ValueUuid get(byte[] byArray) {
        if (byArray.length < 32) {
            return ValueUuid.get(ByteUtils.convertBytesToString(byArray));
        }
        long l = ByteUtils.readLong(byArray, 0);
        long l2 = ByteUtils.readLong(byArray, 16);
        return (ValueUuid)Value.cache(new ValueUuid(l, l2));
    }

    public static ValueUuid get(long l, long l2) {
        return (ValueUuid)Value.cache(new ValueUuid(l, l2));
    }

    public static ValueUuid get(String string) {
        char c;
        int n;
        long l = 0L;
        long l2 = 0L;
        int n2 = 0;
        for (n = 0; n < string.length() && n2 < 16; ++n) {
            c = string.charAt(n);
            if (c == '-') continue;
            l = l << 4 | (long)Character.digit(c, 16);
            ++n2;
        }
        n2 = 0;
        while (n < string.length() && n2 < 16) {
            c = string.charAt(n);
            if (c != '-') {
                l2 = l2 << 4 | (long)Character.digit(c, 16);
                ++n2;
            }
            ++n;
        }
        return (ValueUuid)Value.cache(new ValueUuid(l, l2));
    }

    public String getSQL() {
        return StringUtils.quoteStringSQL(this.getString());
    }

    public int getType() {
        return 20;
    }

    public long getPrecision() {
        return 16L;
    }

    private void appendHex(StringBuffer stringBuffer, long l, int n) {
        for (int i = n * 8 - 4; i >= 0; i -= 8) {
            stringBuffer.append(Integer.toHexString((int)(l >> i) & 0xF));
            stringBuffer.append(Integer.toHexString((int)(l >> i - 4) & 0xF));
        }
    }

    public String getString() {
        StringBuffer stringBuffer = new StringBuffer(36);
        this.appendHex(stringBuffer, this.high >> 32, 4);
        stringBuffer.append('-');
        this.appendHex(stringBuffer, this.high >> 16, 2);
        stringBuffer.append('-');
        this.appendHex(stringBuffer, this.high, 2);
        stringBuffer.append('-');
        this.appendHex(stringBuffer, this.low >> 48, 2);
        stringBuffer.append('-');
        this.appendHex(stringBuffer, this.low, 6);
        return stringBuffer.toString();
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        if (value == this) {
            return 0;
        }
        ValueUuid valueUuid = (ValueUuid)value;
        if (this.high == valueUuid.high) {
            return this.low == valueUuid.low ? 0 : (this.low > valueUuid.low ? 1 : -1);
        }
        return this.high > valueUuid.high ? 1 : -1;
    }

    public boolean equals(Object object) {
        return object instanceof ValueUuid && this.compareSecure((Value)object, null) == 0;
    }

    public Object getObject() {
        return new long[]{this.high, this.low};
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[16];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)(this.high >> 8 * (8 - i) & 0xFFL);
            byArray[8 + i] = (byte)(this.low >> 8 * (8 - i) & 0xFFL);
        }
        return byArray;
    }

    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setBytes(n, this.getBytes());
    }

    public long getHigh() {
        return this.high;
    }

    public long getLow() {
        return this.low;
    }

    public int getDisplaySize() {
        return 36;
    }
}

