/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.internal.net.DNS;

import com.sun.jndi.internal.net.DNS.Packet;

class ResourceRecord {
    private static final int TYPE_OFFSET = 0;
    private static final int CLASS_OFFSET = 2;
    private static final int TTL_OFFSET = 4;
    private static final int DLEN_OFFSET = 8;
    private static final int DATA_OFFSET = 10;
    private static final int TYPE_A = 1;
    private static final int TYPE_NS = 2;
    private static final int TYPE_CNAME = 5;
    private static final int TYPE_PTR = 12;
    private static final int TYPE_TXT = 16;
    String domain_name;
    int type;
    int data_class;
    int ttl;
    Object answer;
    private static boolean debug = false;

    ResourceRecord(Packet packet, int n) {
        this.domain_name = this.parseName(packet, n);
        this.type = packet.getShort(0);
        this.data_class = packet.getShort(2);
        this.ttl = packet.getInt(4);
        int n2 = packet.getShort(8);
        packet.shiftHeader(10);
        switch (this.type) {
            case 1: {
                byte[] byArray = new byte[]{(byte)packet.getByte(0), (byte)packet.getByte(1), (byte)packet.getByte(2), (byte)packet.getByte(3)};
                packet.shiftHeader(n2);
                this.answer = byArray;
                break;
            }
            case 5: 
            case 12: {
                this.answer = this.parseName(packet, n);
                break;
            }
            case 16: {
                this.answer = this.parseString(packet, n, n2);
                ResourceRecord.dprint("name <" + this.domain_name + "> has TXT record <" + this.answer + ">");
                break;
            }
            default: {
                this.answer = null;
            }
        }
    }

    private static void dprint(String string) {
        if (debug) {
            ResourceRecord.err(string);
        }
    }

    private static void err(String string) {
        System.err.println("DNS RR: " + string);
    }

    private String parseName(Packet packet, int n) {
        StringBuffer stringBuffer = new StringBuffer(32);
        int n2 = 0;
        boolean bl = true;
        block0: while (true) {
            int n3;
            if (((n3 = packet.getByte(n2++)) & 0xC0) == 192) {
                n3 = packet.getShort(n2 - 1) & 0x3FFF;
                ++n2;
                ResourceRecord.dprint("compression offset:" + n3);
                int n4 = packet.getHeaderOffset();
                packet.setHeaderOffset(n + n3);
                ResourceRecord.dprint("shifted to: " + packet.getHeaderOffset());
                String string = String.valueOf(new String(stringBuffer)) + this.parseName(packet, n);
                packet.setHeaderOffset(n4 + n2);
                ResourceRecord.dprint("compressed parseName done: <" + string + ">, hdr off:" + packet.getHeaderOffset());
                return string;
            }
            if (n3 == 0) {
                ResourceRecord.dprint("parseName done: <" + stringBuffer + ">, shifting:" + n2);
                packet.shiftHeader(n2);
                return new String(stringBuffer);
            }
            if (!bl) {
                stringBuffer.append('.');
            }
            bl = false;
            while (true) {
                if (n3 <= 0) continue block0;
                stringBuffer.append((char)packet.getByte(n2++));
                --n3;
            }
            break;
        }
    }

    private byte[] parseString(Packet packet, int n, int n2) {
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            int n5 = packet.getByte(n3++);
            while (n5 > 0) {
                byArray[n4++] = (byte)packet.getByte(n3++);
                --n5;
            }
        }
        packet.shiftHeader(n3);
        ResourceRecord.dprint("parseString:  string <" + byArray + ">" + byArray.length);
        return byArray;
    }
}

