/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth.login;

import com.sun.security.auth.login.PropertyExpander;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.security.auth.AuthPermission;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public class ConfigFile
extends Configuration {
    private static final ResourceBundle rb = ResourceBundle.getBundle("com.sun.security.auth.Resources");
    private StreamTokenizer st;
    private int lookahead;
    private int linenum;
    private HashMap configuration;
    private boolean testing = false;
    private boolean initialized = false;

    private void init() throws IOException {
        Object var1_1 = null;
        String string = File.separator;
        if (this.initialized) {
            return;
        }
        this.configuration = new HashMap();
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    String string;
                    String string2;
                    String string3 = Security.getProperty("policy.allowSystemProperty");
                    if ("true".equalsIgnoreCase(string3) && (string2 = System.getProperty("java.security.auth.login.config")) != null) {
                        boolean bl = false;
                        if (string2.startsWith("=")) {
                            bl = true;
                            string2 = string2.substring(1);
                        }
                        try {
                            string2 = PropertyExpander.expand(string2);
                            File file = new File(string2);
                            URL uRL = file.exists() ? new URL("file:" + file.getCanonicalPath()) : new URL(string2);
                            if (ConfigFile.this.testing) {
                                System.out.println("reading " + uRL);
                            }
                            ConfigFile.this.init(uRL);
                        }
                        catch (PropertyExpander.ExpandException expandException) {
                            throw new IOException(rb.getString("Unable to properly expand ") + string2);
                        }
                        ConfigFile.this.initialized = true;
                        if (bl) {
                            if (ConfigFile.this.testing) {
                                System.out.println("overriding other policies!");
                            }
                            return null;
                        }
                    }
                    int n = 1;
                    while ((string = Security.getProperty("login.config.url." + n)) != null) {
                        try {
                            string = PropertyExpander.expand(string).replace(File.separatorChar, '/');
                            if (ConfigFile.this.testing) {
                                System.out.println("\tReading config: " + string);
                            }
                            ConfigFile.this.init(new URL(string));
                            ConfigFile.this.initialized = true;
                        }
                        catch (PropertyExpander.ExpandException expandException) {
                            throw new IOException(rb.getString("Unable to properly expand ") + string);
                        }
                        ++n;
                    }
                    if (!ConfigFile.this.initialized && n == 1 && string == null) {
                        if (ConfigFile.this.testing) {
                            System.out.println("\tReading Policy from ~/.java.login.config");
                        }
                        string = System.getProperty("user.home");
                        try {
                            ConfigFile.this.init(new URL("file:" + string + File.separatorChar + ".java.login.config"));
                        }
                        catch (IOException iOException) {
                            throw new IOException(rb.getString("Unable to locate a ") + rb.getString("login configuration"));
                        }
                    }
                    ConfigFile.this.initialized = true;
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private void init(URL uRL) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(this.getInputStream(uRL));
        this.readConfig(inputStreamReader);
        inputStreamReader.close();
    }

    public AppConfigurationEntry[] getAppConfigurationEntry(String string) {
        LinkedList linkedList;
        if (!this.initialized) {
            try {
                this.init();
            }
            catch (IOException iOException) {
                throw new SecurityException(iOException.getMessage());
            }
        }
        if ((linkedList = (LinkedList)this.configuration.get(string)) == null || linkedList.size() == 0) {
            return null;
        }
        AppConfigurationEntry[] appConfigurationEntryArray = new AppConfigurationEntry[linkedList.size()];
        Iterator iterator = linkedList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            AppConfigurationEntry appConfigurationEntry = (AppConfigurationEntry)iterator.next();
            appConfigurationEntryArray[n] = new AppConfigurationEntry(appConfigurationEntry.getLoginModuleName(), appConfigurationEntry.getControlFlag(), appConfigurationEntry.getOptions());
            ++n;
        }
        return appConfigurationEntryArray;
    }

    public void refresh() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("refreshLoginConfiguration"));
        }
        this.initialized = false;
        try {
            this.init();
        }
        catch (IOException iOException) {
            throw new SecurityException(iOException.toString());
        }
    }

    private void readConfig(Reader reader) throws IOException {
        boolean bl = true;
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        this.st = new StreamTokenizer(reader);
        this.st.quoteChar(34);
        this.st.lowerCaseMode(false);
        this.st.slashSlashComments(true);
        this.st.slashStarComments(true);
        this.st.eolIsSignificant(true);
        this.lookahead = this.nextToken();
        while (this.lookahead != -1) {
            if (this.testing) {
                System.out.print("\tReading next config entry: ");
            }
            this.parseLoginEntry();
        }
    }

    private void parseLoginEntry() throws IOException {
        LinkedList<AppConfigurationEntry> linkedList = new LinkedList<AppConfigurationEntry>();
        String string = this.st.sval;
        this.lookahead = this.nextToken();
        if (this.testing) {
            System.out.println("appName = " + string);
        }
        this.match("{");
        while (!this.peek("}")) {
            Object object;
            String string2;
            AppConfigurationEntry.LoginModuleControlFlag loginModuleControlFlag;
            HashSet hashSet = new HashSet();
            String string3 = this.match("module class name");
            String string4 = this.match("controlFlag");
            if (string4.equalsIgnoreCase("REQUIRED")) {
                loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
            } else if (string4.equalsIgnoreCase("REQUISITE")) {
                loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
            } else if (string4.equalsIgnoreCase("SUFFICIENT")) {
                loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
            } else if (string4.equalsIgnoreCase("OPTIONAL")) {
                loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            } else {
                throw new IOException(rb.getString("Configuration Error:\n\tInvalid control flag, ") + string4);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            while (!this.peek(";")) {
                string2 = this.match("option key");
                this.match("=");
                String string5 = this.match("option value");
                hashMap.put(string2, string5);
            }
            this.lookahead = this.nextToken();
            if (this.testing) {
                System.out.print("\t\t" + string3 + ", " + string4);
                object = hashMap.keySet().iterator();
                while (object.hasNext()) {
                    string2 = (String)object.next();
                    System.out.print(", " + string2 + "=" + (String)hashMap.get(string2));
                }
                System.out.println("");
            }
            object = new AppConfigurationEntry(string3, loginModuleControlFlag, hashMap);
            linkedList.add((AppConfigurationEntry)object);
        }
        this.match("}");
        this.match(";");
        if (this.configuration.containsKey(string)) {
            throw new IOException(rb.getString("Configuration Error:") + rb.getString("\n\tCan not specify multiple entries for ") + string);
        }
        this.configuration.put(string, linkedList);
        if (this.testing) {
            System.out.println("\t\t***Added entry for " + string + " to overall configuration***");
        }
    }

    private String match(String string) throws IOException {
        String string2 = null;
        switch (this.lookahead) {
            case -1: {
                throw new IOException(rb.getString("Configuration Error:\n\tExpected ") + string + rb.getString(", read end of file"));
            }
            case -3: 
            case 34: {
                if (string.equalsIgnoreCase("module class name") || string.equalsIgnoreCase("controlFlag") || string.equalsIgnoreCase("option key") || string.equalsIgnoreCase("option value")) {
                    string2 = this.st.sval;
                    this.lookahead = this.nextToken();
                    break;
                }
                throw new IOException(rb.getString("Configuration Error:\n\tLine ") + this.linenum + rb.getString(": expected '") + string + rb.getString("', found '") + this.st.sval + rb.getString("'"));
            }
            case 123: {
                if (string.equalsIgnoreCase("{")) {
                    this.lookahead = this.nextToken();
                    break;
                }
                throw new IOException(rb.getString("Configuration Error:\n\tLine ") + this.linenum + rb.getString(": expected '") + string + rb.getString("', found '") + this.st.sval + rb.getString("'"));
            }
            case 59: {
                if (string.equalsIgnoreCase(";")) {
                    this.lookahead = this.nextToken();
                    break;
                }
                throw new IOException(rb.getString("Configuration Error:\n\tLine ") + this.linenum + rb.getString(": expected '") + string + rb.getString("', found '") + this.st.sval + rb.getString("'"));
            }
            case 125: {
                if (string.equalsIgnoreCase("}")) {
                    this.lookahead = this.nextToken();
                    break;
                }
                throw new IOException(rb.getString("Configuration Error:\n\tLine ") + this.linenum + rb.getString(": expected '") + string + rb.getString("', found '") + this.st.sval + rb.getString("'"));
            }
            case 61: {
                if (string.equalsIgnoreCase("=")) {
                    this.lookahead = this.nextToken();
                    break;
                }
                throw new IOException(rb.getString("Configuration Error:\n\tLine ") + this.linenum + rb.getString(": expected '") + string + rb.getString("', found '") + this.st.sval + rb.getString("'"));
            }
            default: {
                throw new IOException(rb.getString("Configuration Error:\n\tLine ") + this.linenum + rb.getString(": expected '") + string + rb.getString("', found '") + this.st.sval + rb.getString("'"));
            }
        }
        return string2;
    }

    private boolean peek(String string) {
        boolean bl = false;
        switch (this.lookahead) {
            case 44: {
                if (!string.equalsIgnoreCase(",")) break;
                bl = true;
                break;
            }
            case 59: {
                if (!string.equalsIgnoreCase(";")) break;
                bl = true;
                break;
            }
            case 123: {
                if (!string.equalsIgnoreCase("{")) break;
                bl = true;
                break;
            }
            case 125: {
                if (!string.equalsIgnoreCase("}")) break;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private int nextToken() throws IOException {
        int n;
        while ((n = this.st.nextToken()) == 10) {
            ++this.linenum;
        }
        return n;
    }

    private InputStream getInputStream(URL uRL) throws IOException {
        if ("file".equals(uRL.getProtocol())) {
            String string = uRL.getFile().replace('/', File.separatorChar);
            return new FileInputStream(string);
        }
        return uRL.openStream();
    }
}

