/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Schema;
import org.h2.index.Index;
import org.h2.message.Message;

public class AlterIndexRename
extends SchemaCommand {
    private Index oldIndex;
    private String newIndexName;

    public AlterIndexRename(Parser parser, Schema schema) {
        super(parser, schema);
    }

    public void setOldIndex(Index index) {
        this.oldIndex = index;
    }

    public void setNewName(String name) {
        this.newIndexName = name;
    }

    public int update() throws SQLException {
        this.session.commit();
        Database db = this.session.getDatabase();
        if (this.getSchema().findIndex(this.newIndexName) != null || this.newIndexName.equals(this.oldIndex.getName())) {
            throw Message.getSQLException(42111, this.newIndexName);
        }
        this.session.getUser().checkRight(this.oldIndex.getTable(), 15);
        db.renameSchemaObject(this.session, this.oldIndex, this.newIndexName);
        return 0;
    }
}

